/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.xml;

import com.liferay.portal.kernel.layoutconfiguration.util.xml.RuntimeLogic;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletParameterUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletLogic
extends RuntimeLogic {
    public static final String CLOSE_1_TAG = "</runtime-portlet>";
    public static final String CLOSE_2_TAG = "/>";
    public static final String OPEN_TAG = "<runtime-portlet";
    private final HttpServletRequest _httpServletRequest;
    private final HttpServletResponse _httpServletResponse;

    public PortletLogic(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this._httpServletRequest = httpServletRequest;
        this._httpServletResponse = httpServletResponse;
    }

    public String getClose1Tag() {
        return CLOSE_1_TAG;
    }

    public String getOpenTag() {
        return OPEN_TAG;
    }

    public String processXML(String xml) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        String portletId = rootElement.attributeValue("name");
        String instanceId = rootElement.attributeValue("instance");
        String queryString = rootElement.attributeValue("queryString");
        if (Validator.isNotNull((String)instanceId)) {
            PortletIdCodec.validatePortletName((String)portletId);
            portletId = PortletIdCodec.encode((String)portletId, (String)instanceId);
        }
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._httpServletResponse);
        queryString = PortletParameterUtil.addNamespace((String)portletId, (String)queryString);
        HashMap parameterMap = this._httpServletRequest.getParameterMap();
        if (!portletId.equals(this._httpServletRequest.getParameter("p_p_id"))) {
            parameterMap = new HashMap(parameterMap);
            Set keySet = parameterMap.keySet();
            keySet.removeIf(key -> key.startsWith("p_p_"));
        }
        HttpServletRequest httpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)this._httpServletRequest, parameterMap, (String)queryString, (boolean)false);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletContainerUtil.render((HttpServletRequest)httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this.getPortlet(themeDisplay, portletId));
        return bufferCacheServletResponse.getString();
    }

    protected Portlet getPortlet(ThemeDisplay themeDisplay, String portletId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        long count = PortletPreferencesLocalServiceUtil.getPortletPreferencesCount((int)3, (long)themeDisplay.getPlid(), (String)portletId);
        if (count < 1L) {
            PortletPreferencesFactoryUtil.getPortletSetup((HttpServletRequest)this._httpServletRequest, (String)portletId);
            PortletLayoutListener portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            if (portletLayoutListener != null) {
                portletLayoutListener.onAddToLayout(portletId, themeDisplay.getPlid());
            }
        }
        if (!portlet.isInstanceable()) {
            portlet = (Portlet)portlet.clone();
        }
        portlet.setStatic(true);
        return portlet;
    }
}

