/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.model.impl.LayoutTypePortletImpl;
import java.util.Map;

public class LayoutTypeURLImpl
extends LayoutTypePortletImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutTypeURLImpl.class);

    public LayoutTypeURLImpl(Layout layout, LayoutTypeController layoutTypeController, LayoutTypeAccessPolicy layoutTypeAccessPolicy) {
        super(layout, layoutTypeController, layoutTypeAccessPolicy);
    }

    @Override
    public String getURL(Map<String, String> variables) {
        if (this.hasViewPermission()) {
            return super.getURL(variables);
        }
        return LayoutTypeURLImpl.replaceVariables(LayoutTypeURLImpl.getDefaultURL(), variables);
    }

    protected boolean hasViewPermission() {
        try {
            LayoutTypeAccessPolicy layoutTypeAccessPolicy = this.getLayoutTypeAccessPolicy();
            return layoutTypeAccessPolicy.isViewLayoutAllowed(PermissionThreadLocal.getPermissionChecker(), this.getLayout());
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to check view permission", (Throwable)portalException);
            return false;
        }
    }
}

