/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class PortletAppImpl
implements PortletApp {
    private final Map<String, String[]> _containerRuntimeOptions = new HashMap<String, String[]>();
    private String _contextPath = "";
    private final Map<String, String> _customUserAttributes = new LinkedHashMap<String, String>();
    private String _defaultNamespace = "";
    private final Set<EventDefinition> _eventDefinitions = new LinkedHashSet<EventDefinition>();
    private final Set<PortletFilter> _portletFilters = new LinkedHashSet<PortletFilter>();
    private final Map<String, PortletFilter> _portletFiltersMap = new HashMap<String, PortletFilter>();
    private final Set<Portlet> _portlets = new LinkedHashSet<Portlet>();
    private final Set<PortletURLListener> _portletURLListeners = new LinkedHashSet<PortletURLListener>();
    private final Map<String, PortletURLListener> _portletURLListenersMap = new HashMap<String, PortletURLListener>();
    private final Map<String, PublicRenderParameter> _publicRenderParametersMap = new HashMap<String, PublicRenderParameter>();
    private ServletContext _servletContext;
    private final String _servletContextName;
    private final Set<String> _servletURLPatterns = new LinkedHashSet<String>();
    private int _specMajorVersion = 2;
    private int _specMinorVersion;
    private final Set<String> _userAttributes = new LinkedHashSet<String>();
    private boolean _warFile;

    public PortletAppImpl(String servletContextName) {
        this._servletContextName = servletContextName;
        if (Validator.isNotNull((String)this._servletContextName)) {
            this._contextPath = "/".concat(this._servletContextName);
            this._warFile = true;
        } else {
            this._warFile = false;
        }
    }

    public void addEventDefinition(EventDefinition eventDefinition) {
        this._eventDefinitions.add(eventDefinition);
    }

    public void addPortlet(Portlet portlet) {
        this._portlets.add(portlet);
    }

    public void addPortletFilter(PortletFilter portletFilter) {
        this._portletFilters.add(portletFilter);
        this._portletFiltersMap.put(portletFilter.getFilterName(), portletFilter);
    }

    public void addPortletURLListener(PortletURLListener portletURLListener) {
        this._portletURLListeners.add(portletURLListener);
        this._portletURLListenersMap.put(portletURLListener.getListenerClass(), portletURLListener);
    }

    public void addPublicRenderParameter(PublicRenderParameter publicRenderParameter) {
        this._publicRenderParametersMap.put(publicRenderParameter.getIdentifier(), publicRenderParameter);
    }

    public void addPublicRenderParameter(String identifier, QName qName) {
        PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, qName, this);
        this.addPublicRenderParameter(publicRenderParameter);
    }

    public void addServletURLPatterns(Set<String> servletURLPatterns) {
        this._servletURLPatterns.addAll(servletURLPatterns);
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        return this._containerRuntimeOptions;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Map<String, String> getCustomUserAttributes() {
        return this._customUserAttributes;
    }

    public String getDefaultNamespace() {
        return this._defaultNamespace;
    }

    public Set<EventDefinition> getEventDefinitions() {
        return this._eventDefinitions;
    }

    public PortletFilter getPortletFilter(String filterName) {
        return this._portletFiltersMap.get(filterName);
    }

    public Set<PortletFilter> getPortletFilters() {
        return this._portletFilters;
    }

    public List<Portlet> getPortlets() {
        return new ArrayList<Portlet>(this._portlets);
    }

    public PortletURLListener getPortletURLListener(String listenerClass) {
        return this._portletURLListenersMap.get(listenerClass);
    }

    public Set<PortletURLListener> getPortletURLListeners() {
        return this._portletURLListeners;
    }

    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        return this._publicRenderParametersMap.get(identifier);
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public Set<String> getServletURLPatterns() {
        return this._servletURLPatterns;
    }

    public int getSpecMajorVersion() {
        return this._specMajorVersion;
    }

    public int getSpecMinorVersion() {
        return this._specMinorVersion;
    }

    public Set<String> getUserAttributes() {
        return this._userAttributes;
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public void removePortlet(Portlet portletModel) {
        this._portlets.remove(portletModel);
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this._defaultNamespace = defaultNamespace;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._contextPath = this._servletContext.getContextPath();
    }

    public void setSpecMajorVersion(int specMajorVersion) {
        this._specMajorVersion = specMajorVersion;
    }

    public void setSpecMinorVersion(int specMinorVersion) {
        this._specMinorVersion = specMinorVersion;
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }
}

