/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.BrowserTracker;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.service.BrowserTrackerLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.poller.PollerRequestHandler;
import com.liferay.portal.poller.PollerSession;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PollerRequestHandlerImpl
implements MessageListener,
PollerRequestHandler {
    private static final String _ESCAPED_CLOSE_CURLY_BRACE = "[$CLOSE_CURLY_BRACE$]";
    private static final String _ESCAPED_OPEN_CURLY_BRACE = "[$OPEN_CURLY_BRACE$]";
    private static final String _OPEN_HASH_MAP_WRAPPER = "{\"javaClass\":\"java.util.HashMap\",\"map\":{";
    private static final String _PATH_RECEIVE = "/receive";
    private static final Log _log = LogFactoryUtil.getLog(PollerRequestHandlerImpl.class);
    private final Map<String, PollerSession> _pollerSessions = new HashMap<String, PollerSession>();

    @Override
    public PollerHeader getPollerHeader(String pollerRequestString) {
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        Map<String, Object>[] pollerRequestChunks = this.parsePollerRequestParameters(pollerRequestString);
        return this.parsePollerRequestHeader(pollerRequestChunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject processRequest(HttpServletRequest httpServletRequest, String pollerRequestString) throws Exception {
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        Map<String, Object>[] pollerRequestChunks = this.parsePollerRequestParameters(pollerRequestString);
        PollerHeader pollerHeader = this.parsePollerRequestHeader(pollerRequestChunks);
        if (!this.isValidPollerHeader(pollerHeader)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid poller header for request " + pollerRequestString));
            }
            return null;
        }
        boolean receiveRequest = this.isReceiveRequest(HttpComponentsUtil.normalizePath((String)httpServletRequest.getPathInfo()));
        String pollerSessionId = this.getPollerSessionId(pollerHeader);
        PollerSession pollerSession = null;
        Map<String, PollerSession> map = this._pollerSessions;
        synchronized (map) {
            pollerSession = this._pollerSessions.get(pollerSessionId);
            if (pollerSession == null && receiveRequest) {
                pollerSession = new PollerSession(pollerSessionId);
                this._pollerSessions.put(pollerSessionId, pollerSession);
            }
        }
        List<PollerRequest> pollerRequests = this.createPollerRequests(pollerHeader, pollerRequestChunks, receiveRequest);
        this.executePollerRequests(pollerSession, pollerRequests);
        if (receiveRequest) {
            return this.createPollerResponseHeader(pollerHeader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        Object messagePayload = message.getPayload();
        if (!(messagePayload instanceof PollerResponse)) {
            return;
        }
        PollerResponse pollerResponse = (PollerResponse)messagePayload;
        String pollerSessionId = this.getPollerSessionId(pollerResponse.getPollerHeader());
        Map<String, PollerSession> map = this._pollerSessions;
        synchronized (map) {
            PollerSession pollerSession = this._pollerSessions.get(pollerSessionId);
            if (pollerSession != null && pollerSession.completePortletProcessing(pollerResponse.getPortletId(), message.getResponseId())) {
                this._pollerSessions.remove(pollerSessionId);
            }
        }
    }

    protected PollerRequest createPollerRequest(PollerHeader pollerHeader, String portletId, boolean receiveRequest) throws Exception {
        return this.createPollerRequest(pollerHeader, portletId, new HashMap<String, String>(), null, receiveRequest);
    }

    protected PollerRequest createPollerRequest(PollerHeader pollerHeader, String portletId, Map<String, String> parameterMap, String chunkId, boolean receiveRequest) throws Exception {
        PollerProcessor pollerProcessor = PollerProcessorUtil.getPollerProcessor(portletId);
        if (pollerProcessor == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Poller processor not found for portlet " + portletId));
            }
            return null;
        }
        return new PollerRequest(pollerHeader, portletId, parameterMap, chunkId, receiveRequest);
    }

    protected List<PollerRequest> createPollerRequests(PollerHeader pollerHeader, Map<String, Object>[] pollerRequestChunks, boolean receiveRequest) throws Exception {
        Map portletIdsMap = pollerHeader.getPortletIdsMap();
        ArrayList<PollerRequest> pollerRequests = new ArrayList<PollerRequest>(portletIdsMap.size());
        HashSet<String> receiveRequestPortletIds = null;
        if (receiveRequest) {
            receiveRequestPortletIds = new HashSet<String>((int)((double)pollerRequestChunks.length / 0.75) + 1);
        }
        for (int i = 1; i < pollerRequestChunks.length; ++i) {
            Map<String, Object> pollerRequestChunk = pollerRequestChunks[i];
            String portletId = (String)pollerRequestChunk.get("portletId");
            Map<String, String> parameterMap = this.parseData(pollerRequestChunk);
            String chunkId = (String)pollerRequestChunk.get("chunkId");
            try {
                PollerRequest pollerRequest = this.createPollerRequest(pollerHeader, portletId, parameterMap, chunkId, receiveRequest);
                pollerRequests.add(pollerRequest);
                if (!receiveRequest) continue;
                receiveRequestPortletIds.add(portletId);
                continue;
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        if (receiveRequest) {
            Set portletIds = portletIdsMap.keySet();
            for (String portletId : portletIds) {
                if (receiveRequestPortletIds.contains(portletId)) continue;
                try {
                    PollerRequest pollerRequest = this.createPollerRequest(pollerHeader, portletId, receiveRequest);
                    pollerRequests.add(pollerRequest);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
        }
        return pollerRequests;
    }

    protected JSONObject createPollerResponseHeader(PollerHeader pollerHeader) {
        if (pollerHeader == null) {
            return null;
        }
        boolean suspendPolling = false;
        if (pollerHeader.isStartPolling()) {
            BrowserTrackerLocalServiceUtil.updateBrowserTracker((long)pollerHeader.getUserId(), (long)pollerHeader.getBrowserKey());
        } else {
            BrowserTracker browserTracker = BrowserTrackerLocalServiceUtil.getBrowserTracker((long)pollerHeader.getUserId(), (long)pollerHeader.getBrowserKey());
            if (browserTracker.getBrowserKey() != pollerHeader.getBrowserKey()) {
                suspendPolling = true;
            }
        }
        return JSONUtil.put((String)"suspendPolling", (Object)suspendPolling).put("userId", pollerHeader.getUserId());
    }

    protected void executePollerRequests(PollerSession pollerSession, List<PollerRequest> pollerRequests) {
        for (PollerRequest pollerRequest : pollerRequests) {
            if (pollerRequest == null) continue;
            String responseId = null;
            if (pollerRequest.isReceiveRequest() && !pollerSession.beginPortletProcessing(pollerRequest, responseId = PortalUUIDUtil.generate())) continue;
            Message message = new Message();
            message.setPayload((Object)pollerRequest);
            if (pollerRequest.isReceiveRequest()) {
                message.setResponseId(responseId);
                message.setResponseDestinationName("liferay/poller_response");
            }
            MessageBusUtil.sendMessage((String)"liferay/poller", (Message)message);
        }
    }

    protected String fixPollerRequestString(String pollerRequestString) {
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        return StringUtil.replace((String)pollerRequestString, (String[])new String[]{"{", "}", _ESCAPED_OPEN_CURLY_BRACE, _ESCAPED_CLOSE_CURLY_BRACE}, (String[])new String[]{_OPEN_HASH_MAP_WRAPPER, "}}", "{", "}"});
    }

    protected String getPollerSessionId(PollerHeader pollerHeader) {
        return String.valueOf(pollerHeader.getUserId());
    }

    protected long getUserId(long companyId, String userIdString) {
        long userId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
            userId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)userIdString));
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Invalid credentials for company id ", companyId, " and user id ", userIdString}), (Throwable)exception);
        }
        return userId;
    }

    protected boolean isReceiveRequest(String path) {
        return path != null && path.endsWith(_PATH_RECEIVE);
    }

    protected boolean isValidPollerHeader(PollerHeader pollerHeader) {
        if (pollerHeader == null) {
            return false;
        }
        Map portletIdsMap = pollerHeader.getPortletIdsMap();
        return portletIdsMap != null && !portletIdsMap.isEmpty();
    }

    protected Map<String, String> parseData(Map<String, Object> pollerRequestChunk) throws Exception {
        Map oldParameterMap = (Map)pollerRequestChunk.get("data");
        HashMap<String, String> newParameterMap = new HashMap<String, String>();
        if (oldParameterMap == null) {
            return newParameterMap;
        }
        for (Map.Entry entry : oldParameterMap.entrySet()) {
            newParameterMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return newParameterMap;
    }

    protected PollerHeader parsePollerRequestHeader(Map<String, Object>[] pollerRequestChunks) {
        String userIdString;
        if (pollerRequestChunks == null || pollerRequestChunks.length < 1) {
            return null;
        }
        Map<String, Object> pollerRequestChunk = pollerRequestChunks[0];
        long companyId = GetterUtil.getLong((String)String.valueOf(pollerRequestChunk.get("companyId")));
        long userId = this.getUserId(companyId, userIdString = GetterUtil.getString((String)String.valueOf(pollerRequestChunk.get("userId"))));
        if (userId == 0L) {
            return null;
        }
        long browserKey = GetterUtil.getLong((String)String.valueOf(pollerRequestChunk.get("browserKey")));
        Map portletIdsMap = (Map)pollerRequestChunk.get("portletIdsMap");
        boolean startPolling = GetterUtil.getBoolean((String)String.valueOf(pollerRequestChunk.get("startPolling")));
        return new PollerHeader(companyId, userId, browserKey, portletIdsMap, startPolling);
    }

    protected Map<String, Object>[] parsePollerRequestParameters(String pollerRequestString) {
        String fixedPollerRequestString = this.fixPollerRequestString(pollerRequestString);
        return (Map[])JSONFactoryUtil.deserialize((String)fixedPollerRequestString);
    }
}

