/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.CountryA2Exception;
import com.liferay.portal.kernel.exception.CountryA3Exception;
import com.liferay.portal.kernel.exception.CountryNameException;
import com.liferay.portal.kernel.exception.CountryNumberException;
import com.liferay.portal.kernel.exception.DuplicateCountryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.CountryLocalizationTable;
import com.liferay.portal.kernel.model.CountryTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.CountryLocalServiceBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.List;
import java.util.Locale;

public class CountryLocalServiceImpl
extends CountryLocalServiceBaseImpl {
    @BeanReference(type=AddressLocalService.class)
    private AddressLocalService _addressLocalService;
    @BeanReference(type=OrganizationLocalService.class)
    private OrganizationLocalService _organizationLocalService;
    @BeanReference(type=RegionLocalService.class)
    private RegionLocalService _regionLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public Country addCountry(String a2, String a3, boolean active, boolean billingAllowed, String idd, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT, boolean zipRequired, ServiceContext serviceContext) throws PortalException {
        if (this.fetchCountryByA2(serviceContext.getCompanyId(), a2) != null) {
            throw new DuplicateCountryException();
        }
        this.validate(a2, a3, idd, name, number);
        long countryId = this.counterLocalService.increment();
        Country country = this.countryPersistence.create(countryId);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        country.setCompanyId(user.getCompanyId());
        country.setUserId(user.getUserId());
        country.setUserName(user.getFullName());
        country.setA2(a2);
        country.setA3(a3);
        country.setActive(active);
        country.setBillingAllowed(billingAllowed);
        country.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
        country.setGroupFilterEnabled(false);
        country.setIdd(idd);
        country.setName(name);
        country.setNumber(number);
        country.setPosition(position);
        country.setShippingAllowed(shippingAllowed);
        country.setSubjectToVAT(subjectToVAT);
        country.setZipRequired(zipRequired);
        return (Country)this.countryPersistence.update((BaseModel)country);
    }

    public void deleteCompanyCountries(long companyId) throws PortalException {
        List countries = this.countryPersistence.findByCompanyId(companyId);
        for (Country country : countries) {
            this.countryLocalService.deleteCountry(country);
        }
    }

    @Override
    @SystemEvent(type=1)
    public Country deleteCountry(Country country) throws PortalException {
        this.countryPersistence.remove((BaseModel)country);
        this._addressLocalService.deleteCountryAddresses(country.getCountryId());
        this._updateOrganizations(country.getCountryId());
        this._regionLocalService.deleteCountryRegions(country.getCountryId());
        return country;
    }

    @Override
    public Country deleteCountry(long countryId) throws PortalException {
        Country country = this.countryPersistence.findByPrimaryKey(countryId);
        return this.countryLocalService.deleteCountry(country);
    }

    public Country fetchCountryByA2(long companyId, String a2) {
        return this.countryPersistence.fetchByC_A2(companyId, a2);
    }

    public Country fetchCountryByA3(long companyId, String a3) {
        return this.countryPersistence.fetchByC_A3(companyId, a3);
    }

    public Country fetchCountryByName(long companyId, String name) {
        return this.countryPersistence.fetchByC_Name(companyId, name);
    }

    public Country fetchCountryByNumber(long companyId, String number) {
        return this.countryPersistence.fetchByC_Number(companyId, number);
    }

    public List<Country> getCompanyCountries(long companyId) {
        return this.countryPersistence.findByCompanyId(companyId);
    }

    public List<Country> getCompanyCountries(long companyId, boolean active) {
        return this.countryPersistence.findByC_Active(companyId, active);
    }

    public List<Country> getCompanyCountries(long companyId, boolean active, int start, int end, OrderByComparator<Country> orderByComparator) {
        return this.countryPersistence.findByC_Active(companyId, active, start, end, orderByComparator);
    }

    public List<Country> getCompanyCountries(long companyId, int start, int end, OrderByComparator<Country> orderByComparator) {
        return this.countryPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCompanyCountriesCount(long companyId) {
        return this.countryPersistence.countByCompanyId(companyId);
    }

    public int getCompanyCountriesCount(long companyId, boolean active) {
        return this.countryPersistence.countByC_Active(companyId, active);
    }

    public Country getCountryByA2(long companyId, String a2) throws PortalException {
        return this.countryPersistence.findByC_A2(companyId, a2);
    }

    public Country getCountryByA3(long companyId, String a3) throws PortalException {
        return this.countryPersistence.findByC_A3(companyId, a3);
    }

    public Country getCountryByName(long companyId, String name) throws PortalException {
        return this.countryPersistence.findByC_Name(companyId, name);
    }

    public Country getCountryByNumber(long companyId, String number) throws PortalException {
        return this.countryPersistence.findByC_Number(companyId, number);
    }

    public BaseModelSearchResult<Country> searchCountries(long companyId, Boolean active, String keywords, int start, int end, OrderByComparator<Country> orderByComparator) throws PortalException {
        return BaseModelSearchResult.unsafeCreateWithStartAndEnd(startAndEnd -> (List)this.countryPersistence.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CountryTable.INSTANCE), companyId, active, keywords).orderBy((Table)CountryTable.INSTANCE, (OrderByInfo)orderByComparator).limit(startAndEnd.getStart(), startAndEnd.getEnd())), (int)this.countryPersistence.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CountryTable.INSTANCE.countryId), companyId, active, keywords)), (int)start, (int)end);
    }

    public Country updateActive(long countryId, boolean active) throws PortalException {
        Country country = this.countryPersistence.findByPrimaryKey(countryId);
        country.setActive(active);
        return (Country)this.countryPersistence.update((BaseModel)country);
    }

    public Country updateCountry(long countryId, String a2, String a3, boolean active, boolean billingAllowed, String idd, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT) throws PortalException {
        Country country = this.countryPersistence.findByPrimaryKey(countryId);
        this.validate(a2, a3, idd, name, number);
        country.setA2(a2);
        country.setA3(a3);
        country.setActive(active);
        country.setBillingAllowed(billingAllowed);
        country.setIdd(idd);
        country.setName(name);
        country.setNumber(number);
        country.setPosition(position);
        country.setShippingAllowed(shippingAllowed);
        country.setSubjectToVAT(subjectToVAT);
        return (Country)this.countryPersistence.update((BaseModel)country);
    }

    public Country updateGroupFilterEnabled(long countryId, boolean groupFilterEnabled) throws PortalException {
        Country country = this.countryLocalService.getCountry(countryId);
        country.setGroupFilterEnabled(groupFilterEnabled);
        return (Country)this.countryPersistence.update((BaseModel)country);
    }

    protected void validate(String a2, String a3, String idd, String name, String number) throws PortalException {
        if (Validator.isNull((String)a2) || a2.length() != 2) {
            throw new CountryA2Exception();
        }
        if (Validator.isNull((String)a3) || a3.length() != 3) {
            throw new CountryA3Exception();
        }
        if (Validator.isNull((String)name)) {
            throw new CountryNameException();
        }
        if (Validator.isNull((String)number)) {
            throw new CountryNumberException();
        }
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long companyId, boolean active, String keywords) throws PortalException {
        JoinStep joinStep = fromStep.from((Table)CountryTable.INSTANCE).leftJoinOn((Table)CountryLocalizationTable.INSTANCE, CountryTable.INSTANCE.countryId.eq((Expression)CountryLocalizationTable.INSTANCE.countryId));
        return joinStep.where(() -> {
            Predicate predicate = CountryTable.INSTANCE.companyId.eq((Object)companyId);
            predicate = predicate.and((Expression)CountryTable.INSTANCE.active.eq((Object)active));
            if (Validator.isNotNull((String)keywords)) {
                String[] terms = CustomSQLUtil.keywords((String)keywords, (boolean)true);
                Predicate keywordsPredicate = null;
                for (String term : terms) {
                    Predicate namePredicate = DSLFunctionFactoryUtil.lower((Expression)CountryTable.INSTANCE.name).like(term);
                    Predicate titlePredicate = DSLFunctionFactoryUtil.lower((Expression)CountryLocalizationTable.INSTANCE.title).like(term);
                    Predicate termPredicate = namePredicate.or((Expression)titlePredicate);
                    keywordsPredicate = keywordsPredicate == null ? termPredicate : keywordsPredicate.or((Expression)termPredicate);
                }
                if (keywordsPredicate != null) {
                    predicate = predicate.and((Expression)keywordsPredicate.withParentheses());
                }
            }
            return predicate;
        });
    }

    private void _updateOrganizations(long countryId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._organizationLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property countryIdProperty = PropertyFactoryUtil.forName((String)"countryId");
            dynamicQuery.add(countryIdProperty.eq((Object)countryId));
        });
        actionableDynamicQuery.setPerformActionMethod(organization -> {
            organization.setCountryId(0L);
            organization.setRegionId(0L);
            this._organizationLocalService.updateOrganization(organization);
        });
        actionableDynamicQuery.performActions();
    }
}

