/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.DuplicateOrganizationException;
import com.liferay.portal.kernel.exception.OrganizationNameException;
import com.liferay.portal.kernel.exception.OrganizationParentException;
import com.liferay.portal.kernel.exception.OrganizationTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredOrganizationException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.search.reindexer.ReindexerBridge;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyRelLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.CountryPersistence;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.RegionPersistence;
import com.liferay.portal.kernel.service.persistence.UserFinder;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.OrganizationIdComparator;
import com.liferay.portal.kernel.util.comparator.OrganizationNameComparator;
import com.liferay.portal.service.base.OrganizationLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.search.OrganizationUsersSearcher;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import com.liferay.users.admin.kernel.organization.types.OrganizationTypesSettings;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OrganizationLocalServiceImpl
extends OrganizationLocalServiceBaseImpl {
    private static final String _TYPE_FIELD_NAME = Field.getSortableFieldName((String)"type_String");
    private static volatile OrganizationTypesSettings _organizationTypesSettings = (OrganizationTypesSettings)ServiceProxyFactory.newServiceTrackedInstance(OrganizationTypesSettings.class, OrganizationLocalServiceImpl.class, (String)"_organizationTypesSettings", (boolean)false);
    private static volatile ReindexerBridge _reindexerBridge = (ReindexerBridge)ServiceProxyFactory.newServiceTrackedInstance(ReindexerBridge.class, OrganizationLocalServiceImpl.class, (String)"_reindexerBridge", (boolean)false);
    private static volatile UserFileUploadsSettings _userFileUploadsSettings = (UserFileUploadsSettings)ServiceProxyFactory.newServiceTrackedInstance(UserFileUploadsSettings.class, OrganizationLocalServiceImpl.class, (String)"_userFileUploadsSettings", (boolean)false);
    @BeanReference(type=AddressLocalService.class)
    private AddressLocalService _addressLocalService;
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=CompanyPersistence.class)
    private CompanyPersistence _companyPersistence;
    @BeanReference(type=CountryPersistence.class)
    private CountryPersistence _countryPersistence;
    @BeanReference(type=EmailAddressLocalService.class)
    private EmailAddressLocalService _emailAddressLocalService;
    @BeanReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=ListTypeLocalService.class)
    private ListTypeLocalService _listTypeLocalService;
    @BeanReference(type=PasswordPolicyRelLocalService.class)
    private PasswordPolicyRelLocalService _passwordPolicyRelLocalService;
    @BeanReference(type=PhoneLocalService.class)
    private PhoneLocalService _phoneLocalService;
    @BeanReference(type=RegionPersistence.class)
    private RegionPersistence _regionPersistence;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;
    @BeanReference(type=UserFinder.class)
    private UserFinder _userFinder;
    @BeanReference(type=UserGroupRoleLocalService.class)
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;
    @BeanReference(type=WebsiteLocalService.class)
    private WebsiteLocalService _websiteLocalService;

    @Override
    public void addGroupOrganization(long groupId, long organizationId) {
        super.addGroupOrganization(groupId, organizationId);
        try {
            this.reindexUsers(organizationId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addGroupOrganization(long groupId, Organization organization) {
        super.addGroupOrganization(groupId, organization);
        try {
            this.reindexUsers(organization);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addGroupOrganizations(long groupId, List<Organization> organizations) {
        super.addGroupOrganizations(groupId, organizations);
        try {
            this.reindexUsers(organizations);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addGroupOrganizations(long groupId, long[] organizationIds) {
        super.addGroupOrganizations(groupId, organizationIds);
        try {
            this.reindexUsers(organizationIds);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public Organization addOrganization(long userId, long parentOrganizationId, String name, boolean site) throws PortalException {
        String[] types = this.getTypes();
        return this.addOrganization(userId, parentOrganizationId, name, types[0], 0L, 0L, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, "", site, null);
    }

    public Organization addOrganization(long userId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        Organization parentOrganization;
        User user = this._userPersistence.findByPrimaryKey(userId);
        parentOrganizationId = this.getParentOrganizationId(user.getCompanyId(), parentOrganizationId);
        this.validate(user.getCompanyId(), parentOrganizationId, name, type, countryId, statusId);
        long organizationId = this.counterLocalService.increment();
        Organization organization = this.organizationPersistence.create(organizationId);
        if (serviceContext != null) {
            organization.setUuid(serviceContext.getUuid());
        }
        organization.setCompanyId(user.getCompanyId());
        organization.setUserId(user.getUserId());
        organization.setUserName(user.getFullName());
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setTreePath(organization.buildTreePath());
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(true);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        organization.setExpandoBridgeAttributes(serviceContext);
        organization = (Organization)this.organizationPersistence.update((BaseModel)organization);
        long parentGroupId = 0L;
        if (parentOrganizationId != 0L && (parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId)) != null) {
            Group parentGroup = parentOrganization.getGroup();
            if (site && parentGroup.isSite()) {
                parentGroupId = parentOrganization.getGroupId();
            }
        }
        Group group = this._groupLocalService.addGroup(userId, parentGroupId, Organization.class.getName(), organizationId, 0L, this.getLocalizationMap(name), null, 3, false, 0, null, site, true, null);
        Role role = this._roleLocalService.getRole(organization.getCompanyId(), "Organization Owner");
        this._userGroupRoleLocalService.addUserGroupRoles(userId, group.getGroupId(), new long[]{role.getRoleId()});
        this.addOrganizationResources(userId, organization);
        if (serviceContext != null) {
            this.updateAsset(userId, organization, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
            indexer.reindex((Object)organization);
        }
        return organization;
    }

    public void addOrganizationResources(long userId, Organization organization) throws PortalException {
        this._resourceLocalService.addResources(organization.getCompanyId(), 0L, userId, Organization.class.getName(), organization.getOrganizationId(), false, false, false);
    }

    public User addOrganizationUserByEmailAddress(String emailAddress, long organizationId, ServiceContext serviceContext) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        User user = this._userLocalService.fetchUserByEmailAddress(serviceContext.getCompanyId(), emailAddress);
        if (user == null) {
            Group group = organization.getGroup();
            long[] groupIds = new long[]{group.getGroupId()};
            if (serviceContext.getScopeGroupId() > 0L) {
                groupIds = ArrayUtil.append((long[])groupIds, (long)serviceContext.getScopeGroupId());
            }
            user = this._userLocalService.addUserWithWorkflow(serviceContext.getUserId(), serviceContext.getCompanyId(), true, "", "", true, "", emailAddress, 0L, "", serviceContext.getLocale(), emailAddress, "", emailAddress, 0L, 0L, true, 1, 1, 1970, "", groupIds, null, null, null, true, serviceContext);
        }
        this.addUserOrganization(user.getUserId(), organizationId);
        return user;
    }

    public Organization addOrUpdateOrganization(String externalReferenceCode, long userId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean hasLogo, byte[] logoBytes, boolean site, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Organization organization = this.organizationPersistence.fetchByC_ERC(user.getCompanyId(), externalReferenceCode);
        if (organization == null) {
            organization = this.addOrganization(userId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
            organization.setExternalReferenceCode(externalReferenceCode);
            PortalUtil.updateImageId((BaseModel)organization, (boolean)hasLogo, (byte[])logoBytes, (String)"logoId", (long)_userFileUploadsSettings.getImageMaxSize(), (int)_userFileUploadsSettings.getImageMaxHeight(), (int)_userFileUploadsSettings.getImageMaxWidth());
            organization = (Organization)this.organizationPersistence.update((BaseModel)organization);
        } else {
            organization = this.updateOrganization(user.getCompanyId(), organization.getOrganizationId(), parentOrganizationId, name, type, regionId, countryId, statusId, comments, hasLogo, logoBytes, site, serviceContext);
        }
        return organization;
    }

    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) {
        this._passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    public void addUserOrganizationByEmailAddress(String emailAddress, long organizationId) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        User user = this._userPersistence.findByC_EA(organization.getCompanyId(), emailAddress);
        this._userLocalService.addOrganizationUser(organizationId, user);
    }

    public void deleteLogo(long organizationId) throws PortalException {
        PortalUtil.updateImageId((BaseModel)this.getOrganization(organizationId), (boolean)false, null, (String)"logoId", (long)0L, (int)0, (int)0);
    }

    @Override
    public Organization deleteOrganization(long organizationId) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        return this.organizationLocalService.deleteOrganization(organization);
    }

    @Override
    @SystemEvent(type=1)
    public Organization deleteOrganization(Organization organization) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            int count1 = this.organizationPersistence.countByC_P(organization.getCompanyId(), organization.getOrganizationId());
            int count2 = this._userFinder.countByKeywords(organization.getCompanyId(), null, 0, LinkedHashMapBuilder.put((Object)"usersOrgs", (Object)organization.getOrganizationId()).build());
            if (count1 > 0 || count2 > 0) {
                throw new RequiredOrganizationException();
            }
        }
        this._assetEntryLocalService.deleteEntry(Organization.class.getName(), organization.getOrganizationId());
        this._addressLocalService.deleteAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this._emailAddressLocalService.deleteEmailAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this._expandoRowLocalService.deleteRows(organization.getOrganizationId());
        this._passwordPolicyRelLocalService.deletePasswordPolicyRel(Organization.class.getName(), organization.getOrganizationId());
        this._phoneLocalService.deletePhones(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this._websiteLocalService.deleteWebsites(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        Group group = organization.getGroup();
        if (group.isSite()) {
            group.setSite(false);
            group = (Group)this._groupPersistence.update((BaseModel)group);
        }
        this._groupLocalService.deleteGroup(group);
        this._resourceLocalService.deleteResource(organization.getCompanyId(), Organization.class.getName(), 4, organization.getOrganizationId());
        this.organizationPersistence.remove((BaseModel)organization);
        return organization;
    }

    public void deleteUserOrganizationByEmailAddress(String emailAddress, long organizationId) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        User user = this._userPersistence.findByC_EA(organization.getCompanyId(), emailAddress);
        this._userLocalService.unsetOrganizationUsers(organizationId, new long[]{user.getUserId()});
    }

    public Organization fetchOrganization(long companyId, String name) {
        return this.organizationPersistence.fetchByC_N(companyId, name);
    }

    public String[] getChildrenTypes(String type) {
        return _organizationTypesSettings.getChildrenTypes(type);
    }

    public List<Organization> getGroupUserOrganizations(long groupId, long userId) throws PortalException {
        long[] groupOrganizationIds = this._groupPersistence.getOrganizationPrimaryKeys(groupId);
        if (groupOrganizationIds.length == 0) {
            return Collections.emptyList();
        }
        long[] userOrganizationIds = this._userPersistence.getOrganizationPrimaryKeys(userId);
        if (userOrganizationIds.length == 0) {
            return Collections.emptyList();
        }
        Set organizationIds = SetUtil.intersect((long[])groupOrganizationIds, (long[])userOrganizationIds);
        if (organizationIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Organization> organizations = new ArrayList<Organization>(organizationIds.size());
        for (Long organizationId : organizationIds) {
            organizations.add((Organization)this.organizationPersistence.findByPrimaryKey((Serializable)organizationId));
        }
        return organizations;
    }

    public List<Organization> getNoAssetOrganizations() {
        return this.organizationFinder.findO_ByNoAssets();
    }

    public Organization getOrganization(long companyId, String name) throws PortalException {
        return this.organizationPersistence.findByC_N(companyId, name);
    }

    public long getOrganizationId(long companyId, String name) {
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null) {
            return organization.getOrganizationId();
        }
        return 0L;
    }

    public List<Organization> getOrganizations(long userId, int start, int end, OrderByComparator<Organization> orderByComparator) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        List organizations = ListUtil.copy((List)this._userPersistence.getOrganizations(userId));
        Iterator iterator = organizations.iterator();
        while (iterator.hasNext()) {
            Organization organization = (Organization)iterator.next();
            if (organization.getCompanyId() == user.getCompanyId()) continue;
            iterator.remove();
        }
        if (organizations.isEmpty()) {
            return organizations;
        }
        if (orderByComparator == null) {
            orderByComparator = new OrganizationNameComparator(true);
        }
        Collections.sort(organizations, orderByComparator);
        return ListUtil.subList((List)organizations, (int)start, (int)end);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId) {
        return this.getOrganizations(companyId, parentOrganizationId, -1, -1);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.findByCompanyId(companyId, start, end);
        }
        return this.organizationPersistence.findByC_P(companyId, parentOrganizationId, start, end);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end) {
        if (Validator.isNull((String)name)) {
            return this.organizationPersistence.findByC_P(companyId, parentOrganizationId, start, end);
        }
        return this.organizationPersistence.findByC_P_LikeN(companyId, parentOrganizationId, name, start, end);
    }

    public List<Organization> getOrganizations(long companyId, String treePath) {
        return this.organizationPersistence.findByC_LikeT(companyId, treePath);
    }

    public List<Organization> getOrganizations(long[] organizationIds) throws PortalException {
        ArrayList<Organization> organizations = new ArrayList<Organization>(organizationIds.length);
        for (long organizationId : organizationIds) {
            organizations.add(this.getOrganization(organizationId));
        }
        return organizations;
    }

    public List<Object> getOrganizationsAndUsers(long companyId, long parentOrganizationId, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0L, false, start, end, orderByComparator);
        return this.organizationFinder.findO_U_ByC_P(companyId, parentOrganizationId, queryDefinition);
    }

    public int getOrganizationsAndUsersCount(long companyId, long parentOrganizationId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0L, false, -1, -1, null);
        return this.organizationFinder.countO_U_ByC_P(companyId, parentOrganizationId, queryDefinition);
    }

    public int getOrganizationsCount(long companyId, long parentOrganizationId) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.countByCompanyId(companyId);
        }
        return this.organizationPersistence.countByC_P(companyId, parentOrganizationId);
    }

    public int getOrganizationsCount(long companyId, long parentOrganizationId, String name) {
        if (Validator.isNull((String)name)) {
            return this.organizationPersistence.countByC_P(companyId, parentOrganizationId);
        }
        return this.organizationPersistence.countByC_P_LikeN(companyId, parentOrganizationId, name);
    }

    public List<Organization> getParentOrganizations(long organizationId) throws PortalException {
        if (organizationId == 0L) {
            return new ArrayList<Organization>();
        }
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        return organization.getAncestors();
    }

    public List<Organization> getSuborganizations(List<Organization> organizations) {
        ArrayList<Organization> allSuborganizations = new ArrayList<Organization>();
        for (Organization organization : organizations) {
            List suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
        }
        return allSuborganizations;
    }

    public List<Organization> getSuborganizations(long companyId, long organizationId) {
        return this.organizationPersistence.findByC_P(companyId, organizationId);
    }

    public int getSuborganizationsCount(long companyId, long organizationId) {
        return this.organizationPersistence.countByC_P(companyId, organizationId);
    }

    public List<Organization> getSubsetOrganizations(List<Organization> allOrganizations, List<Organization> availableOrganizations) {
        ArrayList<Organization> subsetOrganizations = new ArrayList<Organization>();
        for (Organization organization : allOrganizations) {
            if (!availableOrganizations.contains(organization)) continue;
            subsetOrganizations.add(organization);
        }
        return subsetOrganizations;
    }

    public String[] getTypes() {
        return _organizationTypesSettings.getTypes();
    }

    public long[] getUserOrganizationIds(long userId, boolean includeAdministrative) throws PortalException {
        if (!includeAdministrative) {
            return this._userPersistence.getOrganizationPrimaryKeys(userId);
        }
        Set organizationIds = SetUtil.fromArray((long[])this._userPersistence.getOrganizationPrimaryKeys(userId));
        List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner")) continue;
            Group group = userGroupRole.getGroup();
            organizationIds.add(group.getOrganizationId());
        }
        return ArrayUtil.toLongArray((Collection)organizationIds);
    }

    public List<Organization> getUserOrganizations(long userId, boolean includeAdministrative) throws PortalException {
        if (!includeAdministrative) {
            return this.getUserOrganizations(userId);
        }
        HashSet<Organization> organizations = new HashSet<Organization>(this.getUserOrganizations(userId));
        List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner")) continue;
            Group group = userGroupRole.getGroup();
            Organization organization = this.organizationPersistence.findByPrimaryKey(group.getOrganizationId());
            organizations.add(organization);
        }
        return new ArrayList<Organization>(organizations);
    }

    public boolean hasPasswordPolicyOrganization(long passwordPolicyId, long organizationId) {
        return this._passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, Organization.class.getName(), organizationId);
    }

    public boolean hasUserOrganization(long userId, long organizationId, boolean inheritSuborganizations, boolean includeSpecifiedOrganization) throws PortalException {
        int count;
        if (!inheritSuborganizations) {
            return this._userPersistence.containsOrganization(userId, organizationId);
        }
        ArrayList<Organization> organizationsTree = new ArrayList<Organization>();
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        if (includeSpecifiedOrganization) {
            organizationsTree.add(organization);
        } else {
            organizationsTree.addAll(organization.getSuborganizations());
        }
        return !ListUtil.isEmpty(organizationsTree) && (count = this._userFinder.countByUser(userId, LinkedHashMapBuilder.put((Object)"usersOrgsTree", organizationsTree).build())) > 0;
    }

    public boolean isCountryEnabled(String type) {
        return _organizationTypesSettings.isCountryEnabled(type);
    }

    public boolean isCountryRequired(String type) {
        return _organizationTypesSettings.isCountryRequired(type);
    }

    public boolean isRootable(String type) {
        return _organizationTypesSettings.isRootable(type);
    }

    public void rebuildTree(long companyId) throws PortalException {
        TreePathUtil.rebuildTree((long)companyId, (long)0L, (String)"/", (TreeModelTasks)new TreeModelTasksAdapter<Organization>(){

            public List<Organization> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return OrganizationLocalServiceImpl.this.organizationPersistence.findByGtO_C_P(previousId, companyId, parentPrimaryKey, -1, size, (OrderByComparator)new OrganizationIdComparator(true));
            }
        });
    }

    public Hits search(long companyId, long parentOrganizationId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String name = null;
        String type = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            name = keywords;
            type = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andOperator, start, end, sort);
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, parentOrganizationId, keywords, type, regionId, countryId, params, start, end, (OrderByComparator<Organization>)new OrganizationNameComparator(true));
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Organization> orderByComparator) {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findO_ByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params, start, end, orderByComparator);
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, (OrderByComparator<Organization>)new OrganizationNameComparator(true));
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Organization> orderByComparator) {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, orderByComparator);
    }

    public Hits search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, String region, String country, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
            SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.ORGANIZATIONS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            String parentOrganizationIdComparator = "=";
            if (parentOrganizationId == -1L) {
                parentOrganizationIdComparator = "!=";
            }
            return this.organizationFinder.countO_ByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params);
        }
        try {
            String name = null;
            String street = null;
            String city = null;
            String zip = null;
            boolean andOperator = false;
            if (Validator.isNotNull((String)keywords)) {
                name = keywords;
                street = keywords;
                city = keywords;
                zip = keywords;
            } else {
                andOperator = true;
            }
            if (params != null) {
                params.put("keywords", keywords);
            }
            SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.ORGANIZATIONS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            String parentOrganizationIdComparator = "=";
            if (parentOrganizationId == -1L) {
                parentOrganizationIdComparator = "!=";
            }
            return this.organizationFinder.countO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator);
        }
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public BaseModelSearchResult<Organization> searchOrganizations(long companyId, long parentOrganizationId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String name = null;
        String type = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            name = keywords;
            type = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchOrganizations(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andOperator, start, end, sort);
    }

    public BaseModelSearchResult<Organization> searchOrganizations(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, String region, String country, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andSearch, start, end, sort);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List organizations = UsersAdminUtil.getOrganizations((Hits)hits);
            if (organizations == null) continue;
            return new BaseModelSearchResult(organizations, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public Hits searchOrganizationsAndUsers(long companyId, long parentOrganizationId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) throws PortalException {
        Indexer<?> indexer = OrganizationUsersSearcher.getInstance();
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, keywords, status, params, start, end, sorts);
        return indexer.search(searchContext);
    }

    public int searchOrganizationsAndUsersCount(long companyId, long parentOrganizationId, String keywords, int status, LinkedHashMap<String, Object> params) throws PortalException {
        Indexer<?> indexer = OrganizationUsersSearcher.getInstance();
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, keywords, status, params, -1, -1, null);
        Hits hits = indexer.search(searchContext);
        return hits.getLength();
    }

    public void unsetGroupOrganizations(long groupId, long[] organizationIds) {
        this._groupPersistence.removeOrganizations(groupId, organizationIds);
        try {
            this.reindexUsers(organizationIds);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) {
        this._passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    public void updateAsset(long userId, Organization organization, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        Company company = this._companyPersistence.findByPrimaryKey(user.getCompanyId());
        Group companyGroup = company.getGroup();
        this._assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), null, null, Organization.class.getName(), organization.getOrganizationId(), organization.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, null, organization.getName(), "", null, null, null, 0, 0, null);
    }

    public Organization updateOrganization(long companyId, long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusId, String comments, boolean hasLogo, byte[] logoBytes, boolean site, ServiceContext serviceContext) throws PortalException {
        parentOrganizationId = this.getParentOrganizationId(companyId, parentOrganizationId);
        this.validate(companyId, organizationId, parentOrganizationId, name, type, countryId, statusId);
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        long oldParentOrganizationId = organization.getParentOrganizationId();
        String oldName = organization.getName();
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setTreePath(organization.buildTreePath());
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(true);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        PortalUtil.updateImageId((BaseModel)organization, (boolean)hasLogo, (byte[])logoBytes, (String)"logoId", (long)_userFileUploadsSettings.getImageMaxSize(), (int)_userFileUploadsSettings.getImageMaxHeight(), (int)_userFileUploadsSettings.getImageMaxWidth());
        organization.setExpandoBridgeAttributes(serviceContext);
        organization = (Organization)this.organizationPersistence.update((BaseModel)organization);
        Group group = organization.getGroup();
        long parentGroupId = group.getParentGroupId();
        boolean createSite = false;
        if (!group.isSite() && site) {
            createSite = true;
        }
        boolean organizationGroup = this.isOrganizationGroup(oldParentOrganizationId, group.getParentGroupId());
        if (createSite || organizationGroup) {
            if (parentOrganizationId != 0L) {
                Organization parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId);
                Group parentGroup = parentOrganization.getGroup();
                parentGroupId = site && parentGroup.isSite() ? parentOrganization.getGroupId() : 0L;
            } else {
                parentGroupId = 0L;
            }
        }
        if (createSite || !oldName.equals(name) || organizationGroup) {
            this._groupLocalService.updateGroup(group.getGroupId(), parentGroupId, this.getLocalizationMap(name), group.getDescriptionMap(), group.getType(), group.isManualMembership(), group.getMembershipRestriction(), group.getFriendlyURL(), group.isInheritContent(), group.isActive(), null);
        }
        if (group.isSite() != site) {
            this._groupLocalService.updateSite(group.getGroupId(), site);
            this.reindexUsers(organizationId);
        }
        if (createSite) {
            List childOrganizations = this.organizationLocalService.getOrganizations(companyId, organizationId);
            for (Organization childOrganization : childOrganizations) {
                Group childGroup = childOrganization.getGroup();
                if (!childGroup.isSite() || childGroup.getParentGroupId() != 0L) continue;
                childGroup.setParentGroupId(group.getGroupId());
                this._groupLocalService.updateGroup(childGroup);
            }
        }
        if (serviceContext != null) {
            this.updateAsset(serviceContext.getUserId(), organization, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        if (!oldName.equals(name) || oldParentOrganizationId != parentOrganizationId) {
            long[] reindexOrganizationIds = this.getReindexOrganizationIds(organization);
            ArrayList<Organization> reindexOrganizations = new ArrayList<Organization>(reindexOrganizationIds.length);
            for (long reindexOrganizationId : reindexOrganizationIds) {
                Organization reindexOrganization = this.fetchOrganization(reindexOrganizationId);
                reindexOrganizations.add(reindexOrganization);
            }
            indexer.reindex(reindexOrganizations);
        } else {
            indexer.reindex((Object)organization);
        }
        return organization;
    }

    protected void addSuborganizations(List<Organization> allSuborganizations, List<Organization> organizations) {
        for (Organization organization : organizations) {
            if (allSuborganizations.contains(organization)) continue;
            allSuborganizations.add(organization);
            List suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
        }
    }

    protected SearchContext buildSearchContext(long companyId, long parentOrganizationId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) {
        String city = null;
        String country = null;
        String firstName = null;
        String fullName = null;
        String lastName = null;
        String middleName = null;
        String name = null;
        String region = null;
        String screenName = null;
        String street = null;
        String type = null;
        String zip = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            city = keywords;
            country = keywords;
            firstName = keywords;
            fullName = keywords;
            lastName = keywords;
            middleName = keywords;
            name = keywords;
            region = keywords;
            screenName = keywords;
            street = keywords;
            type = keywords;
            zip = keywords;
        } else {
            andOperator = true;
        }
        if (params == null) {
            params = new LinkedHashMap();
        }
        params.put("keywords", keywords);
        params.put("usersOrgs", parentOrganizationId);
        SearchContext searchContext = this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andOperator, start, end, null);
        Map attributes = searchContext.getAttributes();
        attributes.put("firstName", firstName);
        attributes.put("fullName", fullName);
        attributes.put("lastName", lastName);
        attributes.put("middleName", middleName);
        attributes.put("screenName", screenName);
        attributes.put("status", status);
        searchContext.setAttributes(attributes);
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        String regionCode = null;
        if (regionId != null) {
            Region region = (Region)this._regionPersistence.fetchByPrimaryKey((Serializable)regionId);
            regionCode = region.getRegionCode();
        }
        String countryName = null;
        if (countryId != null) {
            Country country = (Country)this._countryPersistence.fetchByPrimaryKey((Serializable)countryId);
            countryName = country.getName();
        }
        return this.buildSearchContext(companyId, parentOrganizationId, name, type, street, city, zip, regionCode, countryName, params, andSearch, start, end, sort);
    }

    protected SearchContext buildSearchContext(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, String region, String country, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        String keywords;
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("city", city);
        attributes.put("country", country);
        attributes.put("name", name);
        attributes.put("params", params);
        attributes.put("parentOrganizationId", String.valueOf(parentOrganizationId));
        attributes.put("region", region);
        attributes.put("street", street);
        attributes.put("type", type);
        attributes.put("zip", zip);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(this._getSorts(sort));
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected long getParentOrganizationId(long companyId, long parentOrganizationId) {
        Organization parentOrganization;
        if (parentOrganizationId != 0L && ((parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId)) == null || companyId != parentOrganization.getCompanyId())) {
            parentOrganizationId = 0L;
        }
        return parentOrganizationId;
    }

    protected long[] getReindexOrganizationIds(Organization organization) throws PortalException {
        List organizations = this.organizationPersistence.findByC_LikeT(organization.getCompanyId(), CustomSQLUtil.keywords((String)StringBundler.concat((Object[])new Object[]{"/", organization.getOrganizationId(), "/"}))[0], -1, -1, (OrderByComparator)new OrganizationNameComparator(true));
        long[] organizationIds = new long[organizations.size()];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization curOrganization = (Organization)organizations.get(i);
            curOrganization.setTreePath(curOrganization.buildTreePath());
            curOrganization = (Organization)this.organizationPersistence.update((BaseModel)curOrganization);
            organizationIds[i] = curOrganization.getOrganizationId();
        }
        if (!ArrayUtil.contains((long[])organizationIds, (long)organization.getOrganizationId())) {
            organizationIds = ArrayUtil.append((long[])organizationIds, (long)organization.getOrganizationId());
        }
        return organizationIds;
    }

    protected boolean isOrganizationGroup(long organizationId, long groupId) {
        Organization organization;
        if (organizationId == 0L && groupId == 0L) {
            return true;
        }
        return organizationId != 0L && (organization = this.organizationPersistence.fetchByPrimaryKey(organizationId)).getGroupId() == groupId;
    }

    protected boolean isParentOrganization(long parentOrganizationId, long organizationId) throws PortalException {
        if (organizationId == 0L) {
            return false;
        }
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        String treePath = organization.getTreePath();
        return treePath.contains("/" + parentOrganizationId + "/");
    }

    protected boolean isUseCustomSQL(LinkedHashMap<String, Object> params) {
        return !MapUtil.isEmpty(params);
    }

    protected void reindex(long companyId, long[] userIds) throws PortalException {
        _reindexerBridge.reindex(companyId, User.class.getName(), userIds);
    }

    protected void reindexUsers(List<Organization> organizations) throws PortalException {
        for (Organization organization : organizations) {
            this.reindexUsers(organization);
        }
    }

    protected void reindexUsers(long organizationId) throws PortalException {
        this.reindexUsers(this.getOrganization(organizationId));
    }

    protected void reindexUsers(long[] organizationIds) throws PortalException {
        for (long organizationId : organizationIds) {
            this.reindexUsers(organizationId);
        }
    }

    protected void reindexUsers(Organization organization) throws PortalException {
        long[] userIds = this.getUserPrimaryKeys(organization.getOrganizationId());
        if (ArrayUtil.isNotEmpty((long[])userIds)) {
            long companyId = organization.getCompanyId();
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this.reindex(companyId, userIds);
                return null;
            });
        }
    }

    protected void validate(long companyId, long organizationId, long parentOrganizationId, String name, String type, long countryId, long statusId) throws PortalException {
        if (!ArrayUtil.contains((Object[])this.getTypes(), (Object)type)) {
            throw new OrganizationTypeException("Invalid organization type " + type);
        }
        if (parentOrganizationId == 0L) {
            if (!this.isRootable(type)) {
                throw new OrganizationParentException.MustBeRootable(type);
            }
        } else {
            Organization parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId);
            if (parentOrganization == null) {
                throw new OrganizationParentException("Organization " + parentOrganizationId + " does not exist");
            }
            Object[] childrenTypes = this.getChildrenTypes(parentOrganization.getType());
            if (childrenTypes.length == 0) {
                throw new OrganizationParentException.MustNotHaveChildren(type);
            }
            if (companyId != parentOrganization.getCompanyId() || parentOrganizationId == organizationId) {
                throw new OrganizationParentException();
            }
            if (!ArrayUtil.contains((Object[])childrenTypes, (Object)type)) {
                throw new OrganizationParentException.MustHaveValidChildType(type, parentOrganization.getType());
            }
        }
        if (organizationId > 0L && parentOrganizationId != 0L && this.isParentOrganization(organizationId, parentOrganizationId)) {
            throw new OrganizationParentException();
        }
        if (Validator.isNull((String)name)) {
            throw new OrganizationNameException();
        }
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null && StringUtil.equalsIgnoreCase((String)organization.getName(), (String)name) && (organizationId <= 0L || organization.getOrganizationId() != organizationId)) {
            throw new DuplicateOrganizationException("There is another organization named " + name);
        }
        boolean countryRequired = _organizationTypesSettings.isCountryRequired(type);
        if (countryRequired || countryId > 0L) {
            this._countryPersistence.findByPrimaryKey(countryId);
        }
        this._listTypeLocalService.validate(statusId, ListTypeConstants.ORGANIZATION_STATUS);
    }

    protected void validate(long companyId, long parentOrganizationId, String name, String type, long countryId, long statusId) throws PortalException {
        this.validate(companyId, 0L, parentOrganizationId, name, type, countryId, statusId);
    }

    private Sort[] _getSorts(Sort sort) {
        Object[] sorts = new Sort[]{sort};
        if (Objects.equals(_TYPE_FIELD_NAME, sort.getFieldName())) {
            sorts = (Sort[])ArrayUtil.append((Object[])sorts, (Object)SortFactoryUtil.getSort(Organization.class, (String)"name", (String)(sort.isReverse() ? "desc" : "asc")));
        }
        return sorts;
    }
}

