/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.AsyncPortletServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class I18nServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(I18nServlet.class);
    private static Map<String, String> _languageIds;

    public static Set<String> getLanguageIds() {
        return new HashSet<String>(_languageIds.values());
    }

    public static Map<String, String> getLanguageIdsMap() {
        return _languageIds;
    }

    public static void setLanguageIds(Element root) {
        HashMap<String, String> languageIds = new HashMap<String, String>();
        List rootElements = root.elements("servlet-mapping");
        for (Element element : rootElements) {
            String servletName = element.elementText("servlet-name");
            if (!servletName.equals("I18n Servlet")) continue;
            String urlPattern = element.elementText("url-pattern");
            String languageId = urlPattern.substring(0, urlPattern.lastIndexOf(47));
            languageIds.put(StringUtil.toLowerCase((String)languageId), languageId);
        }
        _languageIds = Collections.unmodifiableMap(languageIds);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            I18nData i18nData = this.getI18nData(httpServletRequest);
            if (i18nData == null || !PortalUtil.isValidResourceId((String)i18nData.getPath())) {
                PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException()), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
                return;
            }
            String i18nLanguageId = httpServletRequest.getServletPath();
            if (i18nLanguageId.contains("_")) {
                this.sendRedirect(httpServletRequest, httpServletResponse, i18nData);
            } else {
                this._processI18nData(httpServletRequest, httpServletResponse, i18nData);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            PortalUtil.sendError((int)500, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected I18nData getI18nData(HttpServletRequest httpServletRequest) throws PortalException {
        String i18nLanguageId = httpServletRequest.getServletPath();
        int pos = i18nLanguageId.lastIndexOf(47);
        i18nLanguageId = StringUtil.replaceFirst((String)i18nLanguageId.substring(pos + 1), (char)'-', (char)'_');
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Language ID " + i18nLanguageId));
        }
        if (Validator.isNull((String)i18nLanguageId)) {
            return null;
        }
        pos = i18nLanguageId.indexOf(95);
        String i18nLanguageCode = i18nLanguageId;
        if (pos > 0) {
            i18nLanguageCode = i18nLanguageId.substring(0, pos);
        }
        Locale siteDefaultLocale = LanguageUtil.getLocale((String)i18nLanguageCode);
        Group siteGroup = null;
        String path = GetterUtil.getString((String)httpServletRequest.getPathInfo());
        Locale i18nLocale = LocaleUtil.fromLanguageId((String)i18nLanguageId);
        String i18nPath = "/" + i18nLocale.toLanguageTag();
        if (Validator.isNull((String)path)) {
            path = "/";
        } else {
            int[] friendlyURLIndices = PortalUtil.getGroupFriendlyURLIndex((String)path);
            if (friendlyURLIndices != null) {
                String friendlyURL = path.substring(friendlyURLIndices[0], friendlyURLIndices[1]);
                siteGroup = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)PortalInstances.getCompanyId(httpServletRequest), (String)friendlyURL);
                if (siteGroup == null) {
                    httpServletRequest.setAttribute("I18N_ERROR_PATH", (Object)i18nPath);
                    return null;
                }
                siteDefaultLocale = LanguageUtil.getLocale((long)siteGroup.getGroupId(), (String)i18nLanguageCode);
            }
        }
        if (siteDefaultLocale == null) {
            if (!PropsValues.LOCALE_USE_DEFAULT_IF_NOT_AVAILABLE) return null;
            siteDefaultLocale = PortalUtil.getSiteDefaultLocale(siteGroup);
            i18nLanguageCode = siteDefaultLocale.getLanguage();
            i18nPath = "/" + i18nLanguageCode;
            i18nLanguageId = LocaleUtil.toLanguageId((Locale)siteDefaultLocale);
        } else {
            String siteDefaultLanguageId = LocaleUtil.toLanguageId((Locale)siteDefaultLocale);
            if (siteDefaultLanguageId.startsWith(i18nLanguageId)) {
                i18nPath = "/" + i18nLanguageCode;
                i18nLanguageId = siteDefaultLanguageId;
            }
        }
        String redirect = path;
        if (path.equals(HttpComponentsUtil.decodePath((String)path))) {
            redirect = HttpComponentsUtil.encodePath((String)path);
        }
        if (!_log.isDebugEnabled()) return new I18nData(i18nPath, i18nLanguageCode, i18nLanguageId, redirect);
        _log.debug((Object)("Redirect " + redirect));
        return new I18nData(i18nPath, i18nLanguageCode, i18nLanguageId, redirect);
    }

    protected I18nData getI18nData(Locale locale) throws PortalException {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        String i18nPath = "/" + locale.toLanguageTag();
        Locale defaultLocale = LanguageUtil.getLocale((String)locale.getLanguage());
        if (LocaleUtil.equals((Locale)defaultLocale, (Locale)locale)) {
            i18nPath = "/" + defaultLocale.getLanguage();
        }
        return new I18nData(i18nPath, locale.getLanguage(), languageId, "/");
    }

    protected void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, I18nData i18nData) {
        this._setRequestAttributes(httpServletRequest, httpServletResponse, i18nData);
        String languageId = LocaleUtil.toW3cLanguageId((String)i18nData.getLanguageId());
        httpServletResponse.setStatus(301);
        ServletContext servletContext = this.getServletContext();
        httpServletResponse.setHeader("Location", StringBundler.concat((String[])new String[]{servletContext.getContextPath(), "/", languageId, i18nData.getPath()}));
    }

    private void _processI18nData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, I18nData i18nData) throws Exception {
        AsyncPortletServletRequest asyncPortletServletRequest;
        this._setRequestAttributes(httpServletRequest, httpServletResponse, i18nData);
        ServletContext servletContext = this.getServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(i18nData.getPath());
        if (httpServletRequest.isAsyncSupported() && (asyncPortletServletRequest = AsyncPortletServletRequest.getAsyncPortletServletRequest(httpServletRequest)) != null) {
            asyncPortletServletRequest.update(servletContext.getContextPath(), i18nData.getPath());
        }
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void _setRequestAttributes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, I18nData i18nData) {
        httpServletRequest.setAttribute("I18N_LANGUAGE_CODE", (Object)i18nData.getLanguageCode());
        httpServletRequest.setAttribute("I18N_LANGUAGE_ID", (Object)i18nData.getLanguageId());
        httpServletRequest.setAttribute("I18N_PATH", (Object)i18nData.getI18nPath());
        Locale locale = LocaleUtil.fromLanguageId((String)i18nData.getLanguageId(), (boolean)false, (boolean)false);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("LOCALE", (Object)locale);
        LanguageUtil.updateCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Locale)locale);
    }

    protected class I18nData {
        private final String _i18nPath;
        private final String _languageCode;
        private final String _languageId;
        private final String _path;

        public I18nData(String i18nPath, String languageCode, String languageId, String path) {
            this._i18nPath = i18nPath;
            this._languageCode = languageCode;
            this._languageId = languageId;
            this._path = path;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof I18nData)) {
                return false;
            }
            I18nData i18nData = (I18nData)object;
            return Objects.equals(this.getI18nPath(), i18nData.getI18nPath()) && Objects.equals(this.getLanguageCode(), i18nData.getLanguageCode()) && Objects.equals(this.getLanguageId(), i18nData.getLanguageId()) && Objects.equals(this.getPath(), i18nData.getPath());
        }

        public String getI18nPath() {
            return this._i18nPath;
        }

        public String getLanguageCode() {
            return this._languageCode;
        }

        public String getLanguageId() {
            return this._languageId;
        }

        public String getPath() {
            return this._path;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)this.getI18nPath());
            hash = HashUtil.hash((int)hash, (Object)this.getLanguageCode());
            hash = HashUtil.hash((int)hash, (Object)this.getLanguageId());
            return HashUtil.hash((int)hash, (Object)this.getPath());
        }
    }
}

