/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.websphere;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;

public class WebSphereAsyncServletRequestFilter
extends BasePortalFilter {
    private Method _setAsyncSupportedMethod;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        super.doFilter(servletRequest, servletResponse, filterChain);
        while (servletRequest instanceof ServletRequestWrapper) {
            ServletRequestWrapper servletRequestWrapper = (ServletRequestWrapper)servletRequest;
            servletRequest = servletRequestWrapper.getRequest();
        }
        Class<?> clazz = servletRequest.getClass();
        if (Objects.equals(clazz.getName(), "com.ibm.ws.webcontainer.srt.SRTServletRequest")) {
            try {
                if (this._setAsyncSupportedMethod == null) {
                    this._setAsyncSupportedMethod = clazz.getMethod("setAsyncSupported", Boolean.TYPE);
                }
                this._setAsyncSupportedMethod.invoke((Object)servletRequest, true);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Log log = this.getLog();
                log.error((Object)reflectiveOperationException, (Throwable)reflectiveOperationException);
            }
        }
    }

    @Override
    public boolean isFilterEnabled() {
        if (!ServerDetector.isWebSphere()) {
            return false;
        }
        return super.isFilterEnabled();
    }
}

