/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.internal.change.tracking.hibernate.CTSQLInterceptor;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.CTModelIntegrator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.spring.hibernate.GlobalEventListenerIntegrator;
import com.liferay.portal.spring.hibernate.MVCCEventListenerIntegrator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.ServiceRegistry;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.orm.hibernate5.LocalSessionFactoryBuilder;

public class PortalHibernateConfiguration
extends LocalSessionFactoryBean {
    private static final String[] _PRELOAD_CLASS_NAMES = PropsValues.SPRING_HIBERNATE_CONFIGURATION_PROXY_FACTORY_PRELOAD_CLASSLOADER_CLASSES;
    private static final Log _log = LogFactoryUtil.getLog(PortalHibernateConfiguration.class);
    private DataSource _dataSource;
    private boolean _mvccEnabled = true;

    public void afterPropertiesSet() throws IOException {
        Dialect dialect = DialectDetector.getDialect(this._dataSource);
        if (DBManagerUtil.getDBType((Object)dialect) == DBType.ORACLE) {
            System.setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        }
        Properties properties = PropsUtil.getProperties();
        if (DBManagerUtil.getDBType((Object)dialect) == DBType.SYBASE) {
            properties.setProperty("hibernate.jdbc.batch_size", "0");
        }
        properties.put("javax.persistence.validation.mode", "none");
        if (Validator.isNull((String)PropsValues.HIBERNATE_DIALECT)) {
            Class<?> clazz = dialect.getClass();
            properties.setProperty("hibernate.dialect", clazz.getName());
        }
        properties.setProperty("hibernate.cache.use_query_cache", "false");
        properties.setProperty("hibernate.cache.use_second_level_cache", "false");
        properties.remove("hibernate.cache.region.factory_class");
        properties.setProperty("hibernate.query.sql.jdbc_style_params_base", "true");
        properties.setProperty("hibernate.allow_update_outside_transaction", "true");
        this.setHibernateProperties(properties);
        BootstrapServiceRegistryBuilder bootstrapServiceRegistryBuilder = new BootstrapServiceRegistryBuilder();
        bootstrapServiceRegistryBuilder.applyClassLoader(this.getConfigurationClassLoader());
        bootstrapServiceRegistryBuilder.applyIntegrator((Integrator)GlobalEventListenerIntegrator.INSTANCE);
        if (this._mvccEnabled) {
            bootstrapServiceRegistryBuilder.applyIntegrator((Integrator)new CTModelIntegrator());
            bootstrapServiceRegistryBuilder.applyIntegrator((Integrator)MVCCEventListenerIntegrator.INSTANCE);
            this.setEntityInterceptor((Interceptor)new CTSQLInterceptor());
        }
        this.setMetadataSources(new MetadataSources((ServiceRegistry)bootstrapServiceRegistryBuilder.build()));
        super.afterPropertiesSet();
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this._dataSource = dataSource;
    }

    public void setMvccEnabled(boolean mvccEnabled) {
        this._mvccEnabled = mvccEnabled;
    }

    protected static Map<String, Class<?>> getPreloadClassLoaderClasses() {
        try {
            HashMap classes = new HashMap();
            for (String className : _PRELOAD_CLASS_NAMES) {
                ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
                Class<?> clazz = portalClassLoader.loadClass(className);
                classes.put(className, clazz);
            }
            return classes;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder localSessionFactoryBuilder) throws HibernateException {
        try {
            String[] resources;
            for (String resource : resources = this.getConfigurationResources()) {
                try {
                    this.readResource((Configuration)localSessionFactoryBuilder, resource);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return super.buildSessionFactory(localSessionFactoryBuilder);
    }

    protected ClassLoader getConfigurationClassLoader() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getClassLoader();
    }

    protected String[] getConfigurationResources() {
        return PropsUtil.getArray("hibernate.configs");
    }

    protected void readResource(Configuration configuration, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return;
        }
        configuration.addInputStream(inputStream);
        inputStream.close();
    }

    protected void readResource(Configuration configuration, String resource) throws Exception {
        ClassLoader classLoader = this.getConfigurationClassLoader();
        if (resource.startsWith("classpath*:")) {
            String name = resource.substring("classpath*:".length());
            Enumeration<URL> enumeration = classLoader.getResources(name);
            if (_log.isDebugEnabled() && !enumeration.hasMoreElements()) {
                _log.debug((Object)("No resources found for " + name));
            }
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream inputStream = url.openStream();
                this.readResource(configuration, inputStream);
            }
        } else {
            InputStream inputStream = classLoader.getResourceAsStream(resource);
            this.readResource(configuration, inputStream);
        }
    }
}

