/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.portal.kernel.upgrade.MVCCVersionUpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.InputStream;
import java.sql.DatabaseMetaData;
import java.util.List;

public class PortalMVCCVersionUpgradeProcess
extends MVCCVersionUpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeClassElementMVCCVersions();
        super.doUpgrade();
    }

    protected List<Element> getClassElements() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/portal-hbm.xml");
        Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream);
        Element rootElement = document.getRootElement();
        return rootElement.elements("class");
    }

    protected void upgradeClassElementMVCCVersions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            List<Element> classElements = this.getClassElements();
            for (Element classElement : classElements) {
                if (classElement.element("version") == null) continue;
                this.upgradeMVCCVersion(databaseMetaData, classElement);
            }
        }
    }
}

