/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;

public class UpgradeWorkflow
extends UpgradeProcess {
    private static final String _CLASS_NAME_ID = String.valueOf(PortalUtil.getClassNameId((String)"com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess"));
    private static final String[][] _ORPHANED_ATTACHED_MODELS = new String[][]{{"KaleoInstance", "className", "'com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess'", "DDLRecord", "recordId"}, {"KaleoInstanceToken", "className", "'com.liferay.portal.workflow.kaleo.forms.model.KaleoProcess'", "DDLRecord", "recordId"}, {"WorkflowDefinitionLink", "classNameId", _CLASS_NAME_ID, "KaleoProcess", "kaleoProcessId"}, {"WorkflowInstanceLink", "classNameId", _CLASS_NAME_ID, "DDLRecord", "recordId"}};

    protected void deleteOrphaned() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (String[] orphanedAttachedModel : this.getOrphanedAttachedModels()) {
                String tableName = orphanedAttachedModel[0];
                String columnName = orphanedAttachedModel[1];
                if (!this.hasTable(tableName) || !this.hasColumn(tableName, columnName)) continue;
                String orphanedTableName = orphanedAttachedModel[3];
                String orphanedColumnName = orphanedAttachedModel[4];
                if (!this.hasTable(orphanedTableName) || !this.hasColumn(orphanedTableName, orphanedColumnName)) continue;
                String columnValue = orphanedAttachedModel[2];
                this.deleteOrphaned(tableName, columnName, columnValue, orphanedTableName, orphanedColumnName);
            }
        }
    }

    protected void deleteOrphaned(String tableName, String columnName, String columnValue, String orphanedTableName, String orphanedColumnName) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"delete from ", tableName, " where ", columnName, " = ", columnValue, " and classPK not in (select ", orphanedColumnName, " from ", orphanedTableName, ")"}));
    }

    protected void doUpgrade() throws Exception {
        this.deleteOrphaned();
    }

    protected String[][] getOrphanedAttachedModels() {
        return _ORPHANED_ATTACHED_MODELS;
    }
}

