/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.upload.UploadServletRequestConfigurationHelperUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upload.LiferayFileItem;
import com.liferay.portal.upload.LiferayFileItemFactory;
import com.liferay.portal.upload.LiferayServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadServletRequestImpl
extends HttpServletRequestWrapper
implements UploadServletRequest {
    private static final Log _log = LogFactoryUtil.getLog(UploadServletRequestImpl.class);
    private static File _tempDir;
    private final Map<String, com.liferay.portal.kernel.upload.FileItem[]> _fileParameters;
    private final LiferayServletRequest _liferayServletRequest;
    private final Map<String, List<String>> _regularParameters;

    public static File getTempDir() {
        return UploadServletRequestImpl._getTempDir(null);
    }

    public static void setTempDir(File tempDir) {
        _tempDir = tempDir;
    }

    public UploadServletRequestImpl(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, 0, null, 0L, 0L);
    }

    public UploadServletRequestImpl(HttpServletRequest httpServletRequest, int fileSizeThreshold, String location, long maxRequestSize, long maxFileSize) {
        LiferayServletRequest liferayServletRequest;
        block19: {
            super(httpServletRequest);
            this._fileParameters = new LinkedHashMap<String, com.liferay.portal.kernel.upload.FileItem[]>();
            this._regularParameters = new LinkedHashMap<String, List<String>>();
            liferayServletRequest = null;
            try {
                HttpSession httpSession = httpServletRequest.getSession();
                httpSession.removeAttribute(ProgressTracker.PERCENT);
                ServletFileUpload servletFileUpload = fileSizeThreshold > 0 ? new ServletFileUpload((FileItemFactory)new LiferayFileItemFactory(UploadServletRequestImpl._getTempDir(location), fileSizeThreshold)) : new ServletFileUpload((FileItemFactory)new LiferayFileItemFactory(UploadServletRequestImpl.getTempDir()));
                long uploadServletRequestImplMaxSize = UploadServletRequestConfigurationHelperUtil.getMaxSize();
                if (maxRequestSize > 0L) {
                    servletFileUpload.setSizeMax(maxRequestSize);
                } else {
                    servletFileUpload.setSizeMax(uploadServletRequestImplMaxSize);
                }
                if (maxFileSize > 0L) {
                    servletFileUpload.setFileSizeMax(maxFileSize);
                } else {
                    servletFileUpload.setFileSizeMax(uploadServletRequestImplMaxSize);
                }
                liferayServletRequest = new LiferayServletRequest(httpServletRequest);
                List<FileItem> fileItems = servletFileUpload.parseRequest((HttpServletRequest)liferayServletRequest);
                liferayServletRequest.setFinishedReadingOriginalStream(true);
                long uploadServletRequestImplSize = 0L;
                int contentLength = httpServletRequest.getContentLength();
                if (uploadServletRequestImplMaxSize > 0L && (contentLength == -1 || (long)contentLength > uploadServletRequestImplMaxSize)) {
                    fileItems = this.sort(fileItems);
                }
                for (FileItem fileItem : fileItems) {
                    UploadException uploadException;
                    LiferayFileItem liferayFileItem = (LiferayFileItem)fileItem;
                    if (uploadServletRequestImplMaxSize > 0L) {
                        long itemSize = liferayFileItem.getSize();
                        if (uploadServletRequestImplSize + itemSize > uploadServletRequestImplMaxSize) {
                            uploadException = new UploadException(StringBundler.concat((Object[])new Object[]{"Request reached the maximum permitted size ", "of ", uploadServletRequestImplMaxSize, " bytes"}));
                            uploadException.setExceededUploadRequestSizeLimit(true);
                            httpServletRequest.setAttribute("UPLOAD_EXCEPTION", (Object)uploadException);
                            continue;
                        }
                        uploadServletRequestImplSize += itemSize;
                    }
                    if (liferayFileItem.isFormField()) {
                        liferayFileItem.setString(httpServletRequest.getCharacterEncoding());
                        String fieldName = liferayFileItem.getFieldName();
                        if (!this._regularParameters.containsKey(fieldName)) {
                            this._regularParameters.put(fieldName, new ArrayList());
                        }
                        List<String> values = this._regularParameters.get(fieldName);
                        if (liferayFileItem.getSize() > LiferayFileItem.THRESHOLD_SIZE) {
                            uploadException = new UploadException(StringBundler.concat((Object[])new Object[]{"The field ", fieldName, " exceeds its maximum permitted size of ", LiferayFileItem.THRESHOLD_SIZE, " bytes"}));
                            uploadException.setExceededLiferayFileItemSizeLimit(true);
                            httpServletRequest.setAttribute("UPLOAD_EXCEPTION", (Object)uploadException);
                        }
                        values.add(liferayFileItem.getEncodedString());
                        continue;
                    }
                    com.liferay.portal.kernel.upload.FileItem[] liferayFileItems = this._fileParameters.get(liferayFileItem.getFieldName());
                    if (liferayFileItems == null) {
                        liferayFileItems = new LiferayFileItem[]{liferayFileItem};
                    } else {
                        LiferayFileItem[] newLiferayFileItems = new LiferayFileItem[liferayFileItems.length + 1];
                        System.arraycopy(liferayFileItems, 0, newLiferayFileItems, 0, liferayFileItems.length);
                        newLiferayFileItems[newLiferayFileItems.length - 1] = liferayFileItem;
                        liferayFileItems = newLiferayFileItems;
                    }
                    this._fileParameters.put(liferayFileItem.getFieldName(), liferayFileItems);
                }
            }
            catch (Exception exception) {
                UploadException uploadException = new UploadException((Throwable)exception);
                if (exception instanceof FileUploadBase.FileSizeLimitExceededException) {
                    uploadException.setExceededFileSizeLimit(true);
                } else if (exception instanceof FileUploadBase.SizeLimitExceededException) {
                    uploadException.setExceededUploadRequestSizeLimit(true);
                }
                httpServletRequest.setAttribute("UPLOAD_EXCEPTION", (Object)uploadException);
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                if (!_log.isWarnEnabled()) break block19;
                _log.warn((Object)("Unable to parse upload request: " + exception.getMessage()));
            }
        }
        this._liferayServletRequest = liferayServletRequest;
    }

    public UploadServletRequestImpl(HttpServletRequest httpServletRequest, Map<String, com.liferay.portal.kernel.upload.FileItem[]> fileParameters, Map<String, List<String>> regularParameters) {
        super(httpServletRequest);
        this._fileParameters = new LinkedHashMap<String, com.liferay.portal.kernel.upload.FileItem[]>();
        this._regularParameters = new LinkedHashMap<String, List<String>>();
        if (fileParameters != null) {
            this._fileParameters.putAll(fileParameters);
        }
        if (regularParameters != null) {
            this._regularParameters.putAll(regularParameters);
        }
        this._liferayServletRequest = null;
    }

    public void cleanUp() {
        if (this._fileParameters != null && !this._fileParameters.isEmpty()) {
            for (com.liferay.portal.kernel.upload.FileItem[] liferayFileItems : this._fileParameters.values()) {
                for (com.liferay.portal.kernel.upload.FileItem liferayFileItem : liferayFileItems) {
                    liferayFileItem.delete();
                }
            }
        }
        if (this._liferayServletRequest != null) {
            this._liferayServletRequest.cleanUp();
        }
    }

    public String getContentType(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getContentType();
        }
        return null;
    }

    public File getFile(String name) {
        return this.getFile(name, false);
    }

    public File getFile(String name, boolean forceCreate) {
        File file;
        block6: {
            if (this.getFileName(name) == null) {
                return null;
            }
            Object[] liferayFileItems = this._fileParameters.get(name);
            if (ArrayUtil.isEmpty((Object[])liferayFileItems)) {
                return null;
            }
            Object liferayFileItem = liferayFileItems[0];
            long size = liferayFileItem.getSize();
            if (size > 0L && size <= (long)liferayFileItem.getSizeThreshold()) {
                forceCreate = true;
            }
            file = liferayFileItem.getStoreLocation();
            if (liferayFileItem.isInMemory() && forceCreate) {
                try {
                    FileUtil.write((File)file, (InputStream)liferayFileItem.getInputStream());
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)("Unable to write temporary file " + file.getAbsolutePath()), (Throwable)ioException);
                }
            }
        }
        return file;
    }

    public InputStream getFileAsStream(String name) throws IOException {
        return this.getFileAsStream(name, true);
    }

    public InputStream getFileAsStream(String name, boolean deleteOnClose) throws IOException {
        if (this.getFileName(name) == null) {
            return null;
        }
        InputStream inputStream = null;
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            inputStream = this.getInputStream((com.liferay.portal.kernel.upload.FileItem)liferayFileItem, deleteOnClose);
        }
        return inputStream;
    }

    public String getFileName(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getFileName();
        }
        return null;
    }

    public String[] getFileNames(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            String[] fileNames = new String[liferayFileItems.length];
            for (int i = 0; i < liferayFileItems.length; ++i) {
                Object liferayFileItem = liferayFileItems[i];
                fileNames[i] = liferayFileItem.getFileName();
            }
            return fileNames;
        }
        return null;
    }

    public File[] getFiles(String name) {
        String[] fileNames = this.getFileNames(name);
        if (fileNames == null) {
            return null;
        }
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            File[] files = new File[liferayFileItems.length];
            for (int i = 0; i < liferayFileItems.length; ++i) {
                Object liferayFileItem = liferayFileItems[i];
                if (!Validator.isNotNull((String)liferayFileItem.getFileName())) continue;
                files[i] = liferayFileItem.getStoreLocation();
            }
            return files;
        }
        return null;
    }

    public InputStream[] getFilesAsStream(String name) throws IOException {
        return this.getFilesAsStream(name, true);
    }

    public InputStream[] getFilesAsStream(String name, boolean deleteOnClose) throws IOException {
        String[] fileNames = this.getFileNames(name);
        if (fileNames == null) {
            return null;
        }
        InputStream[] inputStreams = null;
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            inputStreams = new InputStream[liferayFileItems.length];
            for (int i = 0; i < liferayFileItems.length; ++i) {
                Object liferayFileItem = liferayFileItems[i];
                if (!Validator.isNotNull((String)liferayFileItem.getFileName())) continue;
                inputStreams[i] = this.getInputStream((com.liferay.portal.kernel.upload.FileItem)liferayFileItem, deleteOnClose);
            }
        }
        return inputStreams;
    }

    public String getFullFileName(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getFullFileName();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._liferayServletRequest != null) {
            return this._liferayServletRequest.getInputStream();
        }
        return super.getInputStream();
    }

    public Map<String, com.liferay.portal.kernel.upload.FileItem[]> getMultipartParameterMap() {
        return this._fileParameters;
    }

    public String getParameter(String name) {
        List<String> values = this._regularParameters.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            String[] values = this.getParameterValues(name);
            if (values == null) continue;
            map.put(name, values);
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet parameterNames = new LinkedHashSet();
        Enumeration enumeration = super.getParameterNames();
        while (enumeration.hasMoreElements()) {
            parameterNames.add(enumeration.nextElement());
        }
        parameterNames.addAll(this._regularParameters.keySet());
        parameterNames.addAll(this._fileParameters.keySet());
        return Collections.enumeration(parameterNames);
    }

    public String[] getParameterValues(String name) {
        Object[] parameterValues = null;
        List<String> values = this._regularParameters.get(name);
        if (values != null) {
            parameterValues = values.toArray(new String[0]);
        }
        Object[] parentParameterValues = super.getParameterValues(name);
        if (parameterValues == null) {
            return parentParameterValues;
        }
        if (parentParameterValues == null) {
            return parameterValues;
        }
        return (String[])ArrayUtil.append((Object[])parameterValues, (Object[])parentParameterValues);
    }

    public Map<String, List<String>> getRegularParameterMap() {
        return this._regularParameters;
    }

    public Long getSize(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getSize();
        }
        return null;
    }

    public Boolean isFormField(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.isFormField();
        }
        return null;
    }

    protected InputStream getInputStream(com.liferay.portal.kernel.upload.FileItem liferayFileItem, boolean deleteOnClose) throws IOException {
        InputStream inputStream = null;
        if (liferayFileItem.isInMemory() && liferayFileItem.getSize() > 0L) {
            inputStream = liferayFileItem.getInputStream();
        } else if (!liferayFileItem.isInMemory()) {
            inputStream = new ByteArrayFileInputStream(liferayFileItem.getStoreLocation(), liferayFileItem.getSizeThreshold(), deleteOnClose);
        }
        return inputStream;
    }

    protected List<FileItem> sort(List<FileItem> fileItems) {
        HashMap<String, GroupedFileItems> groupedFileItemsMap = new HashMap<String, GroupedFileItems>();
        for (FileItem fileItem : fileItems) {
            String fieldName = fileItem.getFieldName();
            GroupedFileItems groupedFileItems = (GroupedFileItems)groupedFileItemsMap.get(fieldName);
            if (groupedFileItems == null) {
                groupedFileItems = new GroupedFileItems(fieldName);
                groupedFileItemsMap.put(fieldName, groupedFileItems);
            }
            groupedFileItems.addFileItem(fileItem);
        }
        TreeSet groupedFileItemsList = new TreeSet(groupedFileItemsMap.values());
        ArrayList<FileItem> sortedFileItems = new ArrayList<FileItem>();
        for (GroupedFileItems groupedFileItems : groupedFileItemsList) {
            sortedFileItems.addAll(groupedFileItems.getFileItems());
        }
        return sortedFileItems;
    }

    private static File _getTempDir(String configuredTempDir) {
        if (Validator.isNotNull((String)configuredTempDir)) {
            return new File(configuredTempDir);
        }
        if (_tempDir == null) {
            _tempDir = new File(UploadServletRequestConfigurationHelperUtil.getTempDir());
        }
        return _tempDir;
    }

    private static class GroupedFileItems
    implements Comparable<GroupedFileItems> {
        private final List<FileItem> _fileItems = new ArrayList<FileItem>();
        private int _fileItemsSize;
        private final String _key;

        public GroupedFileItems(String key) {
            this._key = key;
        }

        public void addFileItem(FileItem fileItem) {
            this._fileItems.add(fileItem);
            this._fileItemsSize = (int)((long)this._fileItemsSize + fileItem.getSize());
        }

        @Override
        public int compareTo(GroupedFileItems groupedFileItems) {
            if (groupedFileItems == null) {
                return 1;
            }
            if (this.equals(groupedFileItems)) {
                return 0;
            }
            if (this._key.equals(groupedFileItems._key) || this.getFileItemsSize() >= groupedFileItems.getFileItemsSize()) {
                return 1;
            }
            return -1;
        }

        public List<FileItem> getFileItems() {
            return this._fileItems;
        }

        public int getFileItemsSize() {
            return this._fileItemsSize;
        }
    }
}

