/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.content.ContentUtil;
import com.liferay.petra.io.unsync.UnsyncStringReader;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsUtil;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections.map.ReferenceMap;

public class LocalizationImpl
implements Localization {
    private static final String _AVAILABLE_LOCALES = "available-locales";
    private static final String _DEFAULT_LOCALE = "default-locale";
    private static final String _EMPTY_ROOT_NODE = "<root />";
    private static final String _LANGUAGE_ID = "language-id";
    private static final String _ROOT = "root";
    private static final Log _log = LogFactoryUtil.getLog(LocalizationImpl.class);
    private final Map<String, Map<Tuple, String>> _cache = new ReferenceMap(1, 0);

    public Object deserialize(JSONObject jsonObject) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = jsonObject.getString(languageId);
            if (!Validator.isNotNull((String)value)) continue;
            map.put(locale, value);
        }
        return map;
    }

    public String[] getAvailableLanguageIds(Document document) {
        if (document == null) {
            return new String[0];
        }
        String attributeValue = this._getRootAttributeValue(document, _AVAILABLE_LOCALES, "");
        return StringUtil.split((String)attributeValue);
    }

    public String[] getAvailableLanguageIds(String xml) {
        String attributeValue = this._getRootAttributeValue(xml, _AVAILABLE_LOCALES, "");
        return StringUtil.split((String)attributeValue);
    }

    public Locale getDefaultImportLocale(String className, long classPK, Locale contentDefaultLocale, Locale[] contentAvailableLocales) {
        return this.getDefaultImportLocale(className, Long.valueOf(classPK), contentDefaultLocale, contentAvailableLocales);
    }

    public Locale getDefaultImportLocale(String className, Serializable primaryKey, Locale contentDefaultLocale, Locale[] contentAvailableLocales) {
        if (LanguageUtil.isAvailableLocale((Locale)contentDefaultLocale)) {
            return contentDefaultLocale;
        }
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        if (ArrayUtil.contains((Object[])contentAvailableLocales, (Object)defaultLocale)) {
            return defaultLocale;
        }
        for (Locale contentAvailableLocale : contentAvailableLocales) {
            if (!LanguageUtil.isAvailableLocale((Locale)contentAvailableLocale)) continue;
            return contentAvailableLocale;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Language ", LocaleUtil.toLanguageId((Locale)contentDefaultLocale), " is missing for ", className, " with primary key ", primaryKey, ". Setting default language to ", LocaleUtil.toLanguageId((Locale)defaultLocale), "."}));
        }
        return defaultLocale;
    }

    public String getDefaultLanguageId(Document document) {
        return this.getDefaultLanguageId(document, LocaleUtil.getSiteDefault());
    }

    public String getDefaultLanguageId(Document document, Locale defaultLocale) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        return this._getRootAttributeValue(document, _DEFAULT_LOCALE, defaultLanguageId);
    }

    public String getDefaultLanguageId(String xml) {
        return this.getDefaultLanguageId(xml, LocaleUtil.getSiteDefault());
    }

    public String getDefaultLanguageId(String xml, Locale defaultLocale) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        return this._getRootAttributeValue(xml, _DEFAULT_LOCALE, defaultLanguageId);
    }

    public String getLocalization(Function<String, String> localizationFunction, String requestedLanguageId, String defaultLanguageId) {
        String value = localizationFunction.apply(requestedLanguageId);
        if (!Validator.isBlank((String)value)) {
            return value;
        }
        if (!Validator.isBlank((String)defaultLanguageId)) {
            return localizationFunction.apply(defaultLanguageId);
        }
        return "";
    }

    public String getLocalization(String xml, String requestedLanguageId) {
        return this.getLocalization(xml, requestedLanguageId, true);
    }

    public String getLocalization(String xml, String requestedLanguageId, boolean useDefault) {
        return this.getLocalization(xml, requestedLanguageId, useDefault, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalization(String xml, String requestedLanguageId, boolean useDefault, String defaultValue) {
        if (!Validator.isXml((String)xml)) {
            if (useDefault || requestedLanguageId.equals(LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()))) {
                return xml;
            }
            return defaultValue;
        }
        String value = this._getCachedValue(xml, requestedLanguageId, useDefault);
        if (value != null) {
            return value;
        }
        String priorityLanguageId = null;
        Locale requestedLocale = LocaleUtil.fromLanguageId((String)requestedLanguageId);
        if (useDefault && LanguageUtil.isDuplicateLanguageCode((String)requestedLocale.getLanguage()) && !requestedLanguageId.equals(priorityLanguageId)) {
            Locale priorityLocale = LanguageUtil.getLocale((String)requestedLocale.getLanguage());
            priorityLanguageId = LocaleUtil.toLanguageId((Locale)priorityLocale);
        }
        XMLStreamReader xmlStreamReader = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            XMLInputFactory xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            String defaultLanguageId = "";
            if (xmlStreamReader.hasNext()) {
                xmlStreamReader.nextTag();
                defaultLanguageId = xmlStreamReader.getAttributeValue(null, _DEFAULT_LOCALE);
                if (Validator.isNull((String)defaultLanguageId)) {
                    defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
                }
            }
            String priorityValue = null;
            String defaultLocalizationValue = null;
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                if (event == 1) {
                    String languageId = xmlStreamReader.getAttributeValue(null, _LANGUAGE_ID);
                    if (Validator.isNull((String)languageId)) {
                        languageId = defaultLanguageId;
                    }
                    if (!languageId.equals(defaultLanguageId) && !languageId.equals(priorityLanguageId) && !languageId.equals(requestedLanguageId)) continue;
                    String text = xmlStreamReader.getElementText();
                    if (languageId.equals(defaultLanguageId)) {
                        defaultLocalizationValue = text;
                    }
                    if (languageId.equals(priorityLanguageId)) {
                        priorityValue = text;
                    }
                    if (languageId.equals(requestedLanguageId)) {
                        value = text;
                    }
                    if (!Validator.isNotNull((String)value)) continue;
                    break;
                }
                if (event != 8) continue;
                break;
            }
            if (useDefault && Validator.isNotNull((String)priorityLanguageId) && Validator.isNull((String)value) && Validator.isNotNull(priorityValue)) {
                value = priorityValue;
            }
            if (useDefault && Validator.isNull((String)value)) {
                value = defaultLocalizationValue;
            }
            if (Validator.isNull((String)value)) {
                value = defaultValue;
            }
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
        }
        finally {
            block31: {
                if (contextClassLoader != portalClassLoader) {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block31;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
        this._setCachedValue(xml, requestedLanguageId, useDefault, value);
        return value;
    }

    public Map<Locale, String> getLocalizationMap(Collection<Locale> locales, Locale defaultLocale, String key) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        String defaultValue = LanguageUtil.get((Locale)defaultLocale, (String)key);
        for (Locale locale : locales) {
            String value = LanguageUtil.get((Locale)locale, (String)key);
            if (!locale.equals(defaultLocale) && value.equals(defaultValue)) continue;
            map.put(locale, value);
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(HttpServletRequest httpServletRequest, String parameter) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String localizedParameter = this.getLocalizedName(parameter, LocaleUtil.toLanguageId((Locale)locale));
            map.put(locale, ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)localizedParameter));
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String preferenceName) {
        return this.getLocalizationMap(preferences, preferenceName, null);
    }

    public Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String preferenceName, String propertyName) {
        String defaultPropertyValue = null;
        if (propertyName != null) {
            defaultPropertyValue = PropsUtil.get(propertyName);
        }
        Class<?> clazz = this.getClass();
        return this.getLocalizationMap(preferences, preferenceName, propertyName, defaultPropertyValue, clazz.getClassLoader());
    }

    public Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String preferenceName, String propertyName, String defaultPropertyValue, ClassLoader classLoader) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String localizedPreference = this.getLocalizedName(preferenceName, LocaleUtil.toLanguageId((Locale)locale));
            map.put(locale, preferences.getValue(localizedPreference, ""));
        }
        if (Validator.isNull((String)propertyName)) {
            return map;
        }
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultValue = (String)map.get(defaultLocale);
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((ClassLoader)classLoader, (String)defaultPropertyValue));
        return map;
    }

    public Map<Locale, String> getLocalizationMap(PortletRequest portletRequest, String parameter) {
        return this.getLocalizationMap(portletRequest, parameter, new HashMap<Locale, String>());
    }

    public Map<Locale, String> getLocalizationMap(PortletRequest portletRequest, String parameter, Map<Locale, String> defaultValues) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String localizedParameter = this.getLocalizedName(parameter, LocaleUtil.toLanguageId((Locale)locale));
            map.put(locale, ParamUtil.getString((PortletRequest)portletRequest, (String)localizedParameter, (String)defaultValues.get(locale)));
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(String xml) {
        return this.getLocalizationMap(xml, false);
    }

    public Map<Locale, String> getLocalizationMap(String xml, boolean useDefault) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = this.getLocalization(xml, languageId, useDefault);
            if (!Validator.isNotNull((String)value)) continue;
            map.put(locale, value);
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(String bundleName, ClassLoader classLoader, String key, boolean includeBetaLocales) {
        if (key == null) {
            return null;
        }
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultValue = this._getLocalization(bundleName, defaultLocale, classLoader, key, key);
        HashMap map = HashMapBuilder.put((Object)defaultLocale, (Object)defaultValue).build();
        Set locales = null;
        locales = includeBetaLocales ? LanguageUtil.getAvailableLocales() : LanguageUtil.getSupportedLocales();
        for (Locale locale : locales) {
            String value;
            if (locale.equals(defaultLocale) || !Validator.isNotNull((String)(value = this._getLocalization(bundleName, locale, classLoader, key, null))) || value.equals(defaultValue)) continue;
            map.put(locale, value);
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(String[] languageIds, String[] values) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (int i = 0; i < values.length; ++i) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageIds[i]);
            map.put(locale, values[i]);
        }
        return map;
    }

    public String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter) {
        return this.getLocalizationXmlFromPreferences(preferences, portletRequest, parameter, null, null);
    }

    public String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter, String defaultValue) {
        return this.getLocalizationXmlFromPreferences(preferences, portletRequest, parameter, null, defaultValue);
    }

    public String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter, String prefix, String defaultValue) {
        String oldValue;
        String xml = null;
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String value;
            String localizedKey;
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String prefixedLocalizedKey = localizedKey = this.getLocalizedName(parameter, languageId);
            if (Validator.isNotNull((String)prefix)) {
                prefixedLocalizedKey = StringBundler.concat((String[])new String[]{prefix, "--", localizedKey, "--"});
            }
            if ((value = ParamUtil.getString((PortletRequest)portletRequest, (String)prefixedLocalizedKey, (String)preferences.getValue(localizedKey, null))) == null) continue;
            xml = this.updateLocalization(xml, parameter, value, languageId);
        }
        if (this.getLocalization(xml, defaultLanguageId, true, null) == null && Validator.isNotNull((String)(oldValue = PrefsParamUtil.getString((PortletPreferences)preferences, (PortletRequest)portletRequest, (String)parameter, (String)defaultValue)))) {
            xml = this.updateLocalization(xml, parameter, oldValue);
        }
        return xml;
    }

    public String getLocalizedName(String name, String languageId) {
        return StringBundler.concat((String[])new String[]{name, "_", languageId});
    }

    public Map<Locale, String> getMap(LocalizedValuesMap localizedValuesMap) {
        Locale locale;
        Map map = localizedValuesMap.getValues();
        if (map.get(locale = LocaleUtil.getDefault()) == null) {
            map.put(locale, localizedValuesMap.getDefaultValue());
        }
        return map;
    }

    public String getPreferencesValue(PortletPreferences preferences, String key, String languageId) {
        return this.getPreferencesValue(preferences, key, languageId, true);
    }

    public String getPreferencesValue(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getLocalizedName(key, languageId);
        String value = preferences.getValue(localizedKey, "");
        if (useDefault && Validator.isNull((String)value) && Validator.isNull((String)(value = preferences.getValue(this._getDefaultLocalizedName(key), "")))) {
            value = preferences.getValue(key, "");
        }
        return value;
    }

    public String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId) {
        return this.getPreferencesValues(preferences, key, languageId, true);
    }

    public String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getLocalizedName(key, languageId);
        Object[] values = preferences.getValues(localizedKey, new String[0]);
        if (useDefault && ArrayUtil.isEmpty((Object[])values) && ArrayUtil.isEmpty((Object[])(values = preferences.getValues(this._getDefaultLocalizedName(key), new String[0])))) {
            values = preferences.getValues(key, new String[0]);
        }
        return values;
    }

    public String getSettingsValue(Settings settings, String key, String languageId) {
        return this.getSettingsValue(settings, key, languageId, true);
    }

    public String getSettingsValue(Settings settings, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getLocalizedName(key, languageId);
        String value = settings.getValue(localizedKey, "");
        if (useDefault && Validator.isNull((String)value) && Validator.isNull((String)(value = settings.getValue(this._getDefaultLocalizedName(key), "")))) {
            value = settings.getValue(key, "");
        }
        return value;
    }

    public String[] getSettingsValues(Settings settings, String key, String languageId) {
        return this.getSettingsValues(settings, key, languageId, true);
    }

    public String[] getSettingsValues(Settings settings, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getLocalizedName(key, languageId);
        Object[] values = settings.getValues(localizedKey, new String[0]);
        if (useDefault && ArrayUtil.isEmpty((Object[])values) && ArrayUtil.isEmpty((Object[])(values = settings.getValues(this._getDefaultLocalizedName(key), new String[0])))) {
            values = settings.getValues(key, new String[0]);
        }
        return values;
    }

    public String getXml(LocalizedValuesMap localizedValuesMap, String key) {
        XMLStreamWriter xmlStreamWriter = null;
        try {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement(_ROOT);
            Set availableLocales = LanguageUtil.getAvailableLocales();
            xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, StringUtil.merge((Collection)availableLocales));
            Locale defaultLocale = LocaleUtil.getSiteDefault();
            xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLocale.toString());
            for (Locale locale : availableLocales) {
                String value = localizedValuesMap.get(locale);
                if (value == null) continue;
                xmlStreamWriter.writeStartElement(key);
                xmlStreamWriter.writeAttribute(_LANGUAGE_ID, locale.toString());
                xmlStreamWriter.writeCharacters(value);
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            String string = unsyncStringWriter.toString();
            this._close(xmlStreamWriter);
            return string;
        }
        catch (XMLStreamException xmlStreamException) {
            try {
                throw new RuntimeException(xmlStreamException);
            }
            catch (Throwable throwable) {
                this._close(xmlStreamWriter);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXml(Map<String, String> map, String defaultLanguageId, String key) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        XMLStreamWriter xmlStreamWriter = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement(_ROOT);
            StringBundler sb = new StringBundler(2 * map.size() - 1);
            sb.append(defaultLanguageId);
            for (String string : map.keySet()) {
                if (defaultLanguageId.equals(string)) continue;
                sb.append(",");
                sb.append(string);
            }
            xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, sb.toString());
            xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
            for (Map.Entry entry : map.entrySet()) {
                String languageId = (String)entry.getKey();
                xmlStreamWriter.writeStartElement(key);
                xmlStreamWriter.writeAttribute(_LANGUAGE_ID, languageId);
                xmlStreamWriter.writeCharacters(XMLUtil.stripInvalidChars((String)((String)entry.getValue())));
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            String string = unsyncStringWriter.toString();
            return string;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        finally {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (XMLStreamException xmlStreamException) {
                    _log.error((Throwable)xmlStreamException);
                }
            }
        }
        return "";
    }

    public Map<Locale, String> populateLocalizationMap(Map<Locale, String> localizationMap, String defaultLanguageId, long groupId) {
        String defaultValue = localizationMap.get(LocaleUtil.fromLanguageId((String)defaultLanguageId));
        for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)groupId)) {
            if (localizationMap.containsKey(availableLocale) && !Validator.isNull((String)localizationMap.get(availableLocale))) continue;
            localizationMap.put(availableLocale, defaultValue);
        }
        return localizationMap;
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId) {
        return this.removeLocalization(xml, key, requestedLanguageId, false);
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata) {
        return this.removeLocalization(xml, key, requestedLanguageId, cdata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata, boolean localized) {
        if (Validator.isNull((String)xml)) {
            return "";
        }
        if (!Validator.isXml((String)xml)) {
            return xml;
        }
        xml = this._sanitizeXML(xml);
        XMLStreamReader xmlStreamReader = null;
        XMLStreamWriter xmlStreamWriter = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            XMLInputFactory xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            String availableLocales = "";
            String defaultLanguageId = "";
            if (xmlStreamReader.hasNext()) {
                xmlStreamReader.nextTag();
                availableLocales = xmlStreamReader.getAttributeValue(null, _AVAILABLE_LOCALES);
                defaultLanguageId = xmlStreamReader.getAttributeValue(null, _DEFAULT_LOCALE);
                if (Validator.isNull((String)defaultLanguageId)) {
                    defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
                }
            }
            if (availableLocales != null && availableLocales.contains(requestedLanguageId)) {
                UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
                xmlStreamWriter.writeStartDocument();
                xmlStreamWriter.writeStartElement(_ROOT);
                if (localized) {
                    availableLocales = StringUtil.removeFromList((String)availableLocales, (String)requestedLanguageId);
                    xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
                    xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
                }
                this._copyNonexempt(xmlStreamReader, xmlStreamWriter, requestedLanguageId, defaultLanguageId, cdata);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndDocument();
                xmlStreamWriter.close();
                xmlStreamWriter = null;
                xml = unsyncStringWriter.toString();
            }
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
        }
        finally {
            block30: {
                block29: {
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {
                            if (!_log.isDebugEnabled()) break block29;
                            _log.debug((Throwable)exception);
                        }
                    }
                }
                if (xmlStreamWriter != null) {
                    try {
                        xmlStreamWriter.close();
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block30;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
        return xml;
    }

    public void setLocalizedPreferencesValues(PortletRequest portletRequest, PortletPreferences preferences, String parameter) throws Exception {
        Map<Locale, String> map = this.getLocalizationMap(portletRequest, parameter);
        for (Map.Entry<Locale, String> entry : map.entrySet()) {
            String languageId = LocaleUtil.toLanguageId((Locale)entry.getKey());
            this.setPreferencesValue(preferences, parameter, languageId, entry.getValue());
        }
    }

    public void setPreferencesValue(PortletPreferences preferences, String key, String languageId, String value) throws Exception {
        preferences.setValue(this.getLocalizedName(key, languageId), value);
    }

    public void setPreferencesValues(PortletPreferences preferences, String key, String languageId, String[] values) throws Exception {
        preferences.setValues(this.getLocalizedName(key, languageId), values);
    }

    public String updateLocalization(Map<Locale, String> localizationMap, String xml, String key, String defaultLanguageId) {
        Set availableLocales = LanguageUtil.getAvailableLocales();
        if (Validator.isBlank((String)xml)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Locale, String> entry : localizationMap.entrySet()) {
                Locale locale = entry.getKey();
                String value = entry.getValue();
                if (!availableLocales.contains(locale) || !Validator.isNotNull((String)value)) continue;
                map.put(LocaleUtil.toLanguageId((Locale)locale), value);
            }
            if (map.isEmpty()) {
                return "";
            }
            return this.getXml(map, defaultLanguageId, key);
        }
        for (Locale locale : availableLocales) {
            String value = localizationMap.get(locale);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            if (Validator.isNotNull((String)value)) {
                xml = this.updateLocalization(xml, key, value, languageId, defaultLanguageId);
                continue;
            }
            xml = this.removeLocalization(xml, key, languageId);
        }
        return xml;
    }

    public String updateLocalization(String xml, String key, String value) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.updateLocalization(xml, key, value, defaultLanguageId, defaultLanguageId);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId) {
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, false);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata) {
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, cdata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata, boolean localized) {
        xml = this._sanitizeXML(xml);
        XMLStreamReader xmlStreamReader = null;
        XMLStreamWriter xmlStreamWriter = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            XMLInputFactory xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            String availableLocales = "";
            if (xmlStreamReader.hasNext()) {
                xmlStreamReader.nextTag();
                availableLocales = xmlStreamReader.getAttributeValue(null, _AVAILABLE_LOCALES);
                if (Validator.isNull((String)availableLocales)) {
                    availableLocales = defaultLanguageId;
                }
                if (!availableLocales.contains(requestedLanguageId)) {
                    availableLocales = StringUtil.add((String)availableLocales, (String)requestedLanguageId, (String)",");
                }
            }
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement(_ROOT);
            if (localized) {
                xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
                xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
            }
            this._copyNonexempt(xmlStreamReader, xmlStreamWriter, requestedLanguageId, defaultLanguageId, cdata);
            xmlStreamWriter.writeStartElement(key);
            if (localized) {
                xmlStreamWriter.writeAttribute(_LANGUAGE_ID, requestedLanguageId);
            }
            String safeValue = XMLUtil.stripInvalidChars((String)value);
            if (cdata) {
                xmlStreamWriter.writeCData(safeValue);
            } else {
                xmlStreamWriter.writeCharacters(safeValue);
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.close();
            xmlStreamWriter = null;
            xml = unsyncStringWriter.toString();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
        }
        finally {
            block31: {
                block30: {
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {
                            if (!_log.isDebugEnabled()) break block30;
                            _log.debug((Throwable)exception);
                        }
                    }
                }
                if (xmlStreamWriter != null) {
                    try {
                        xmlStreamWriter.close();
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block31;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
        return xml;
    }

    private void _close(XMLStreamWriter xmlStreamWriter) {
        block3: {
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (XMLStreamException xmlStreamException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Throwable)xmlStreamException);
                }
            }
        }
    }

    private void _copyNonexempt(XMLStreamReader xmlStreamReader, XMLStreamWriter xmlStreamWriter, String exemptLanguageId, String defaultLanguageId, boolean cdata) throws XMLStreamException {
        while (xmlStreamReader.hasNext()) {
            int event = xmlStreamReader.next();
            if (event == 1) {
                String languageId = xmlStreamReader.getAttributeValue(null, _LANGUAGE_ID);
                if (Validator.isNull((String)languageId)) {
                    languageId = defaultLanguageId;
                }
                if (languageId.equals(exemptLanguageId)) continue;
                xmlStreamWriter.writeStartElement(xmlStreamReader.getLocalName());
                xmlStreamWriter.writeAttribute(_LANGUAGE_ID, languageId);
                String text = xmlStreamReader.getElementText();
                if (cdata) {
                    xmlStreamWriter.writeCData(text);
                } else {
                    xmlStreamWriter.writeCharacters(text);
                }
                xmlStreamWriter.writeEndElement();
                continue;
            }
            if (event != 8) continue;
            break;
        }
    }

    private String _getCachedValue(String xml, String requestedLanguageId, boolean useDefault) {
        String value = null;
        Map<Tuple, String> valueMap = this._cache.get(xml);
        if (valueMap != null) {
            Tuple subkey = new Tuple(new Object[]{useDefault, requestedLanguageId});
            value = valueMap.get(subkey);
        }
        return value;
    }

    private String _getDefaultLocalizedName(String name) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.getLocalizedName(name, defaultLanguageId);
    }

    private String _getLocalization(String bundleName, Locale locale, ClassLoader classLoader, String key, String defaultValue) {
        String value;
        block4: {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)bundleName, (Locale)locale, (ClassLoader)classLoader);
            value = null;
            if (resourceBundle.containsKey(key)) {
                try {
                    value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
                    value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)exception);
                }
            }
        }
        if (Validator.isNull(value)) {
            value = LanguageUtil.get((Locale)locale, (String)key, (String)defaultValue);
        }
        return value;
    }

    private String _getRootAttributeValue(Document document, String name, String defaultValue) {
        Element rootElement = document.getRootElement();
        return rootElement.attributeValue(name, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getRootAttributeValue(String xml, String name, String defaultValue) {
        if (!Validator.isXml((String)xml)) {
            return defaultValue;
        }
        String value = null;
        XMLStreamReader xmlStreamReader = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            XMLInputFactory xmlInputFactory;
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            if ((xmlStreamReader = (xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory()).createXMLStreamReader((Reader)new UnsyncStringReader(xml))).hasNext()) {
                xmlStreamReader.nextTag();
                value = xmlStreamReader.getAttributeValue(null, name);
            }
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
        }
        finally {
            block19: {
                if (contextClassLoader != portalClassLoader) {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block19;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
        if (Validator.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private String _sanitizeXML(String xml) {
        if (Validator.isNull((String)xml) || !xml.contains("<root")) {
            xml = _EMPTY_ROOT_NODE;
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setCachedValue(String xml, String requestedLanguageId, boolean useDefault, String value) {
        if (Validator.isNotNull((String)xml) && !xml.equals(_EMPTY_ROOT_NODE)) {
            Map<String, Map<Tuple, String>> map = this._cache;
            synchronized (map) {
                Map<Tuple, String> map2 = this._cache.get(xml);
                if (map2 == null) {
                    map2 = new HashMap<Tuple, String>();
                }
                Tuple subkey = new Tuple(new Object[]{useDefault, requestedLanguageId});
                map2.put(subkey, value);
                this._cache.put(xml, map2);
            }
        }
    }
}

