/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.servlet.ServletInputStreamAdapter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.portlet.PortletServletSession;
import com.liferay.portlet.internal.PortletRequestDispatcherImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.EventRequest;
import javax.portlet.PortletRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class PortletServletRequest
extends HttpServletRequestWrapper {
    private final HttpServletRequest _httpServletRequest;
    private final boolean _include;
    private final String _lifecycle;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final boolean _named;
    private final String _pathInfo;
    private final PortletRequest _portletRequest;
    private final String _queryString;
    private final String _requestURI;
    private final String _servletPath;

    public PortletServletRequest(HttpServletRequest httpServletRequest, PortletRequest portletRequest, String pathInfo, String queryString, String requestURI, String servletPath, boolean named, boolean include) {
        super(httpServletRequest);
        this._httpServletRequest = httpServletRequest;
        this._portletRequest = portletRequest;
        this._liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(this._portletRequest);
        this._pathInfo = pathInfo;
        this._queryString = queryString;
        this._requestURI = GetterUtil.getString((String)requestURI);
        this._servletPath = GetterUtil.getString((String)servletPath);
        this._named = named;
        this._include = include;
        this._lifecycle = this._liferayPortletRequest.getLifecycle();
        if (Validator.isNotNull((String)this._queryString)) {
            this._liferayPortletRequest.setPortletRequestDispatcherRequest(httpServletRequest);
        }
    }

    public Object getAttribute(String name) {
        if (this._include || name == null) {
            return this._httpServletRequest.getAttribute(name);
        }
        if (name.equals("javax.servlet.forward.context_path")) {
            if (this._named) {
                return null;
            }
            return this._portletRequest.getContextPath();
        }
        if (name.equals("javax.servlet.forward.path_info")) {
            if (this._named) {
                return null;
            }
            return this._pathInfo;
        }
        if (name.equals("javax.servlet.forward.query_string")) {
            if (this._named) {
                return null;
            }
            return this._queryString;
        }
        if (name.equals("javax.servlet.forward.request_uri")) {
            if (this._named) {
                return null;
            }
            return this._requestURI;
        }
        if (name.equals("javax.servlet.forward.servlet_path")) {
            if (this._named) {
                return null;
            }
            return this._servletPath;
        }
        return this._httpServletRequest.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this._portletRequest.getAttributeNames();
    }

    public String getAuthType() {
        return this._httpServletRequest.getAuthType();
    }

    public String getCharacterEncoding() {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._httpServletRequest.getCharacterEncoding();
        }
        return null;
    }

    public int getContentLength() {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._httpServletRequest.getContentLength();
        }
        return 0;
    }

    public String getContentType() {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._httpServletRequest.getContentType();
        }
        return null;
    }

    public String getContextPath() {
        return this._portletRequest.getContextPath();
    }

    public Cookie[] getCookies() {
        return this._httpServletRequest.getCookies();
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        return GetterUtil.getLongStrict((String)this.getHeader(name));
    }

    public String getHeader(String name) {
        return this._httpServletRequest.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this._httpServletRequest.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String name) {
        return this._httpServletRequest.getHeaders(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            ClientDataRequest clientDataRequest = this._getClientDataRequest();
            return new ServletInputStreamAdapter(clientDataRequest.getPortletInputStream());
        }
        return null;
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return GetterUtil.getIntegerStrict((String)header);
    }

    public String getLocalAddr() {
        return null;
    }

    public Locale getLocale() {
        return this._portletRequest.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this._portletRequest.getLocales();
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getMethod() {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            ClientDataRequest clientDataRequest = this._getClientDataRequest();
            return clientDataRequest.getMethod();
        }
        if (this._lifecycle.equals("HEADER_PHASE") || this._lifecycle.equals("RENDER_PHASE")) {
            return "GET";
        }
        EventRequest eventRequest = this._getEventRequest();
        return eventRequest.getMethod();
    }

    public String getParameter(String name) {
        return this._portletRequest.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this._portletRequest.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this._portletRequest.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this._portletRequest.getParameterValues(name);
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        ServletContext servletContext = this._httpServletRequest.getServletContext();
        if (this._pathInfo != null && servletContext != null) {
            return servletContext.getRealPath(this._pathInfo);
        }
        return null;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getQueryString() {
        return this._queryString;
    }

    public BufferedReader getReader() throws IOException {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            ClientDataRequest clientDataRequest = this._getClientDataRequest();
            return clientDataRequest.getReader();
        }
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getRemoteUser() {
        return this._portletRequest.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher requestDispatcher = this._httpServletRequest.getRequestDispatcher(path);
        if (requestDispatcher != null) {
            requestDispatcher = new PortletRequestDispatcherImpl(requestDispatcher, path);
        }
        return requestDispatcher;
    }

    public String getRequestedSessionId() {
        return this._portletRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getScheme() {
        return this._portletRequest.getScheme();
    }

    public String getServerName() {
        return this._portletRequest.getServerName();
    }

    public int getServerPort() {
        return this._portletRequest.getServerPort();
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession httpSession = this._httpServletRequest.getSession(create);
        if (httpSession == null) {
            return null;
        }
        return new PortletServletSession(httpSession, this._liferayPortletRequest);
    }

    public Principal getUserPrincipal() {
        return this._portletRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._httpServletRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._httpServletRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this._portletRequest.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this._portletRequest.isSecure();
    }

    public boolean isUserInRole(String role) {
        return this._portletRequest.isUserInRole(role);
    }

    public void removeAttribute(String name) {
        this._portletRequest.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this._portletRequest.setAttribute(name, object);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._lifecycle.equals("ACTION_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            ClientDataRequest clientDataRequest = this._getClientDataRequest();
            clientDataRequest.setCharacterEncoding(encoding);
        }
    }

    private ClientDataRequest _getClientDataRequest() {
        return (ClientDataRequest)this._portletRequest;
    }

    private EventRequest _getEventRequest() {
        return (EventRequest)this._portletRequest;
    }
}

