/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.model.impl.AssetVocabularyBaseImpl;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.List;
import java.util.Locale;

public class AssetVocabularyImpl
extends AssetVocabularyBaseImpl {
    private AssetVocabularySettingsHelper _vocabularySettingsHelper;

    public List<AssetCategory> getCategories() {
        return AssetCategoryLocalServiceUtil.getVocabularyCategories((long)this.getVocabularyId(), (int)-1, (int)-1, null);
    }

    public int getCategoriesCount() {
        return AssetCategoryLocalServiceUtil.getVocabularyCategoriesCount((long)this.getVocabularyId());
    }

    public long[] getRequiredClassNameIds() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getRequiredClassNameIds();
    }

    public long[] getSelectedClassNameIds() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getClassNameIds();
    }

    public long[] getSelectedClassTypePKs() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getClassTypePKs();
    }

    @Override
    public String getSettings() {
        if (this._vocabularySettingsHelper == null) {
            return super.getSettings();
        }
        return this._vocabularySettingsHelper.toString();
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull((String)value)) {
            value = this.getName();
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull((String)value)) {
            value = this.getName();
        }
        return value;
    }

    public String getUnambiguousTitle(List<AssetVocabulary> vocabularies, long groupId, Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getTitle(locale);
        }
        boolean hasAmbiguousTitle = ListUtil.exists(vocabularies, vocabulary -> {
            String title = vocabulary.getTitle(locale);
            return title.equals(this.getTitle(locale)) && vocabulary.getVocabularyId() != this.getVocabularyId();
        });
        if (hasAmbiguousTitle) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            return group.getUnambiguousName(this.getTitle(locale), locale);
        }
        return this.getTitle(locale);
    }

    public boolean hasMoreThanOneCategorySelected(long[] categoryIds) {
        int count = ListUtil.count(this.getCategories(), assetCategory -> ArrayUtil.contains((long[])categoryIds, (long)assetCategory.getCategoryId()));
        return count > 1;
    }

    public boolean isAssociatedToClassNameId(long classNameId) {
        return this.isAssociatedToClassNameIdAndClassTypePK(classNameId, -1L);
    }

    public boolean isAssociatedToClassNameIdAndClassTypePK(long classNameId, long classTypePK) {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.hasClassNameIdAndClassTypePK(classNameId, classTypePK);
    }

    public boolean isMissingRequiredCategory(long classNameId, long classTypePK, long[] categoryIds) {
        if (!this.isRequired(classNameId, classTypePK)) {
            return false;
        }
        return !ListUtil.exists(this.getCategories(), assetCategory -> ArrayUtil.contains((long[])categoryIds, (long)assetCategory.getCategoryId()));
    }

    public boolean isMultiValued() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.isMultiValued();
    }

    public boolean isRequired(long classNameId, long classTypePK) {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.isClassNameIdAndClassTypePKRequired(classNameId, classTypePK);
    }

    @Override
    public void setSettings(String settings) {
        this._vocabularySettingsHelper = null;
        super.setSettings(settings);
    }

    protected AssetVocabularySettingsHelper getVocabularySettingsHelper() {
        if (this._vocabularySettingsHelper == null) {
            this._vocabularySettingsHelper = new AssetVocabularySettingsHelper(super.getSettings());
        }
        return this._vocabularySettingsHelper;
    }
}

