/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert.documentlibrary;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.comparator.FileVersionVersionComparator;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.convert.BaseConvertProcess;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;

public class DocumentLibraryConvertProcess
extends BaseConvertProcess {
    private static final ServiceTrackerList<DLStoreConvertProcess> _dlStoreConvertProcesses = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), DLStoreConvertProcess.class);

    @Override
    public String getConfigurationErrorMessage() {
        return "there-are-no-stores-configured";
    }

    @Override
    public String getDescription() {
        return "migrate-documents-from-one-repository-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    @Override
    public String[] getParameterNames() {
        StoreFactory storeFactory = StoreFactory.getInstance();
        Store store = storeFactory.getStore();
        if (store == null) {
            return null;
        }
        String[] storeTypes = storeFactory.getStoreTypes();
        StringBundler sb = new StringBundler(storeTypes.length * 2 + 2);
        sb.append("dl.store.impl");
        sb.append("=");
        for (String storeType : storeTypes) {
            Class<?> clazz = store.getClass();
            if (storeType.equals(clazz.getName())) continue;
            sb.append(storeType);
            sb.append(";");
        }
        return new String[]{sb.toString(), "delete-files-from-previous-repository=checkbox"};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void validate() {
    }

    @Override
    protected void doConvert() throws Exception {
        StoreFactory storeFactory = StoreFactory.getInstance();
        String targetStoreClassName = this.getTargetStoreClassName();
        this.migrateDLStoreConvertProcesses(storeFactory.getStore(), storeFactory.getStore(targetStoreClassName));
        MaintenanceUtil.appendStatus(StringBundler.concat((String[])new String[]{"Please set ", "dl.store.impl", " in your portal-ext.properties to use ", targetStoreClassName}));
        PropsValues.DL_STORE_IMPL = targetStoreClassName;
    }

    protected List<FileVersion> getFileVersions(FileEntry fileEntry) {
        return ListUtil.sort((List)fileEntry.getFileVersions(-1), (Comparator)new FileVersionVersionComparator(true));
    }

    protected String getTargetStoreClassName() {
        String[] values = this.getParameterValues();
        return values[0];
    }

    protected boolean isDeleteFilesFromSourceStore() {
        String[] values = this.getParameterValues();
        return GetterUtil.getBoolean((String)values[1]);
    }

    protected void migrateDLStoreConvertProcesses(Store sourceStore, Store targetStore) throws PortalException {
        Collection<DLStoreConvertProcess> dlStoreConvertProcesses = this._getDLStoreConvertProcesses();
        for (DLStoreConvertProcess dlStoreConvertProcess : dlStoreConvertProcesses) {
            if (this.isDeleteFilesFromSourceStore()) {
                dlStoreConvertProcess.move(sourceStore, targetStore);
                continue;
            }
            dlStoreConvertProcess.copy(sourceStore, targetStore);
        }
    }

    private Collection<DLStoreConvertProcess> _getDLStoreConvertProcesses() {
        ArrayList<DLStoreConvertProcess> dlStoreConvertProcesses = new ArrayList<DLStoreConvertProcess>();
        _dlStoreConvertProcesses.forEach(dlStoreConvertProcesses::add);
        return dlStoreConvertProcesses;
    }
}

