/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;

public class JSONWebServiceNamingUtil {
    private static final String[] _EXCLUDED_PATHS = PropsUtil.getArray((String)"jsonws.web.service.paths.excludes");
    private static final String[] _EXCLUDED_TYPES_NAMES = new String[]{InputStream.class.getName(), OutputStream.class.getName(), "javax."};
    private static final String[] _INCLUDED_PATHS = PropsUtil.getArray((String)"jsonws.web.service.paths.includes");
    private static final Set<String> _excludedMethodNames = SetUtil.fromArray((Object[])PropsUtil.getArray((String)"json.service.invalid.method.names"));
    private static final Set<String> _invalidHttpMethods = SetUtil.fromArray((Object[])PropsUtil.getArray((String)"jsonws.web.service.invalid.http.methods"));
    private static final Set<String> _prefixes = SetUtil.fromArray((Object[])new String[]{"get", "has", "is"});

    public static String convertMethodToHttpMethod(Method method) {
        String methodName = method.getName();
        if (_prefixes.contains(JSONWebServiceNamingUtil._getMethodNamePrefix(methodName))) {
            return "GET";
        }
        return "POST";
    }

    public static String convertMethodToPath(Method method) {
        return CamelCaseUtil.fromCamelCase((String)method.getName());
    }

    public static String convertModelClassToImplClassName(Class<?> clazz) {
        ImplementationClassName implementationClassName = clazz.getAnnotation(ImplementationClassName.class);
        if (implementationClassName != null) {
            return implementationClassName.value();
        }
        String className = clazz.getName();
        className = StringUtil.replace((String)className, (String)".kernel.", (String)".");
        className = StringUtil.replace((String)className, (String)".model.", (String)".model.impl.") + "Impl";
        return className;
    }

    public static String convertServiceClassToPath(Class<?> clazz) {
        String className = JSONWebServiceNamingUtil.convertServiceClassToSimpleName(clazz);
        return StringUtil.toLowerCase((String)className);
    }

    public static String convertServiceClassToSimpleName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.endsWith("ServiceImpl")) {
            className = className.substring(0, className.length() - 11);
        } else if (className.endsWith("Service")) {
            className = className.substring(0, className.length() - 7);
        }
        return className;
    }

    public static boolean isIncludedMethod(Method method) {
        if (_excludedMethodNames != null && _excludedMethodNames.contains(method.getName())) {
            return false;
        }
        if (_EXCLUDED_TYPES_NAMES == null) {
            return true;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            returnType = returnType.getComponentType();
        }
        String returnTypeName = returnType.getName();
        for (String excludedTypesName : _EXCLUDED_TYPES_NAMES) {
            if (!excludedTypesName.startsWith(returnTypeName)) continue;
            return false;
        }
        Type[] types = method.getGenericParameterTypes();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = types[i];
            Class<?> parameterType = parameterTypes[i];
            if (parameterType.isArray()) {
                parameterType = parameterType.getComponentType();
            }
            String parameterTypeName = parameterType.getName();
            for (String excludedTypesName : _EXCLUDED_TYPES_NAMES) {
                if (parameterTypeName.startsWith(excludedTypesName)) {
                    return false;
                }
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                    String typeName = actualTypeArgument.getTypeName();
                    if (!typeName.startsWith(excludedTypesName)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isIncludedPath(String contextPath, String path) {
        String portalContextPath = PortalUtil.getPathContext();
        if (!contextPath.equals(portalContextPath)) {
            path = contextPath + "." + path.substring(1);
        }
        for (String excludedPath : _EXCLUDED_PATHS) {
            if (!StringUtil.wildcardMatches((String)path, (String)excludedPath, (char)'?', (char)'*', (char)'\\', (boolean)false)) continue;
            return false;
        }
        if (_INCLUDED_PATHS.length == 0) {
            return true;
        }
        for (String includedPath : _INCLUDED_PATHS) {
            if (!StringUtil.wildcardMatches((String)path, (String)includedPath, (char)'?', (char)'*', (char)'\\', (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidHttpMethod(String httpMethod) {
        return !_invalidHttpMethods.contains(httpMethod);
    }

    private static String _getMethodNamePrefix(String methodName) {
        int i;
        for (i = 0; i < methodName.length() && !Character.isUpperCase(methodName.charAt(i)); ++i) {
        }
        return methodName.substring(0, i);
    }
}

