/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.jsonwebservice.JSONWebServiceMappingResolverUtil;
import com.liferay.portal.jsonwebservice.JSONWebServiceNamingUtil;
import com.liferay.portal.jsonwebservice.JSONWebServiceScannerUtil;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class JSONWebServiceRegistratorUtil {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceRegistratorUtil.class);

    public static void processBean(String contextName, String contextPath, Object bean) {
        if (!PropsValues.JSON_WEB_SERVICE_ENABLED) {
            return;
        }
        JSONWebService jsonWebService = (JSONWebService)AnnotationLocator.locate(JSONWebServiceRegistratorUtil._getTargetClass(bean), JSONWebService.class);
        if (jsonWebService == null) {
            return;
        }
        try {
            JSONWebServiceRegistratorUtil._onJSONWebServiceBean(contextName, contextPath, bean, jsonWebService);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private static Class<?> _getTargetClass(Object service) {
        while (ProxyUtil.isProxyClass(service.getClass())) {
            InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)service);
            if (invocationHandler instanceof AopInvocationHandler) {
                AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)invocationHandler;
                service = aopInvocationHandler.getTarget();
                continue;
            }
            if (invocationHandler instanceof ClassLoaderBeanHandler) {
                ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
                Object bean = classLoaderBeanHandler.getBean();
                if (bean instanceof ServiceWrapper) {
                    ServiceWrapper serviceWrapper = (ServiceWrapper)bean;
                    service = serviceWrapper.getWrappedService();
                    continue;
                }
                service = bean;
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to handle proxy of type " + invocationHandler));
            }
            return null;
        }
        return service.getClass();
    }

    private static void _onJSONWebServiceBean(String contextName, String contextPath, Object serviceBean, JSONWebService jsonWebService) throws Exception {
        Method[] serviceMethods;
        JSONWebServiceMode jsonWebServiceMode = JSONWebServiceMode.MANUAL;
        if (jsonWebService != null) {
            jsonWebServiceMode = jsonWebService.mode();
        }
        for (Method method : serviceMethods = JSONWebServiceScannerUtil.scan(serviceBean)) {
            Class<?> serviceBeanClass;
            String path;
            JSONWebServiceMode methodJSONWebServiceMode;
            JSONWebService methodJSONWebService = method.getAnnotation(JSONWebService.class);
            if (methodJSONWebService != null ? (methodJSONWebServiceMode = methodJSONWebService.mode()).equals((Object)JSONWebServiceMode.IGNORE) : !jsonWebServiceMode.equals((Object)JSONWebServiceMode.AUTO)) continue;
            String httpMethod = JSONWebServiceMappingResolverUtil.resolveHttpMethod(method);
            if (!JSONWebServiceNamingUtil.isValidHttpMethod(httpMethod) || !JSONWebServiceNamingUtil.isIncludedPath(contextPath, path = JSONWebServiceMappingResolverUtil.resolvePath(serviceBeanClass = method.getDeclaringClass(), method)) || !JSONWebServiceNamingUtil.isIncludedMethod(method)) continue;
            JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)contextName, (String)contextPath, (Object)serviceBean, serviceBeanClass, (Method)method, (String)path, (String)httpMethod);
        }
    }
}

