/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelHints;
import com.liferay.portal.kernel.model.ModelHintsCallback;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class BaseModelHintsImpl
implements ModelHints {
    private static final String _ELEMENTS_SUFFIX = "_ELEMENTS";
    private static final String _HINTS_SUFFIX = "_HINTS";
    private static final String _LOCALIZATION_SUFFIX = "_LOCALIZATION";
    private static final String _SANITIZE_SUFFIX = "_SANITIZE_SUFFIX";
    private static final String _TYPE_SUFFIX = "_TYPE";
    private static final String _VALIDATORS_SUFFIX = "_VALIDATORS";
    private static final Log _log = LogFactoryUtil.getLog(BaseModelHintsImpl.class);
    private Map<String, Map<String, String>> _defaultHints;
    private Map<String, Map<String, String>> _hintCollections;
    private Map<String, Object> _modelFields;
    private Set<String> _models;

    public void afterPropertiesSet() {
        this._hintCollections = new HashMap<String, Map<String, String>>();
        this._defaultHints = new HashMap<String, Map<String, String>>();
        this._modelFields = new HashMap<String, Object>();
        this._models = new TreeSet<String>();
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            for (String config : this.getModelHintsConfigs()) {
                if (config.startsWith("classpath*:")) {
                    String name = config.substring("classpath*:".length());
                    Enumeration<URL> enumeration = classLoader.getResources(name);
                    if (_log.isDebugEnabled() && !enumeration.hasMoreElements()) {
                        _log.debug((Object)("No resources found for " + name));
                    }
                    while (enumeration.hasMoreElements()) {
                        URL url = enumeration.nextElement();
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Loading ", name, " from ", url}));
                        }
                        InputStream inputStream = url.openStream();
                        this.read(classLoader, url.toString(), inputStream);
                    }
                    continue;
                }
                InputStream inputStream = classLoader.getResourceAsStream(config);
                if (inputStream == null) {
                    File file = new File(config);
                    if (!file.exists()) continue;
                    inputStream = new FileInputStream(file);
                }
                try (InputStream curInputStream = inputStream;){
                    this.read(classLoader, config, curInputStream);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public String buildCustomValidatorName(String validatorName) {
        return StringBundler.concat((String[])new String[]{validatorName, "_", StringUtil.randomId()});
    }

    public Map<String, String> getDefaultHints(String model) {
        return this._defaultHints.get(model);
    }

    public Object getFieldsElement(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        Element fieldsEl = (Element)fields.get(field + _ELEMENTS_SUFFIX);
        if (fieldsEl == null) {
            return null;
        }
        return fieldsEl;
    }

    public Map<String, String> getHints(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (Map)fields.get(field + _HINTS_SUFFIX);
    }

    public int getMaxLength(String model, String field) {
        Map<String, String> hints = this.getHints(model, field);
        if (hints == null) {
            return Integer.MAX_VALUE;
        }
        int maxLength = GetterUtil.getInteger((String)"75");
        return GetterUtil.getInteger((String)hints.get("max-length"), (int)maxLength);
    }

    public abstract ModelHintsCallback getModelHintsCallback();

    public abstract String[] getModelHintsConfigs();

    public List<String> getModels() {
        return ListUtil.fromCollection(this._models);
    }

    public Tuple getSanitizeTuple(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (Tuple)fields.get(field + _SANITIZE_SUFFIX);
    }

    public List<Tuple> getSanitizeTuples(String model) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> sanitizeTuples = new ArrayList<Tuple>();
        for (Map.Entry entry : fields.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(_SANITIZE_SUFFIX)) continue;
            Tuple sanitizeTuple = (Tuple)entry.getValue();
            sanitizeTuples.add(sanitizeTuple);
        }
        return sanitizeTuples;
    }

    public abstract SAXReader getSAXReader();

    public String getType(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (String)fields.get(field + _TYPE_SUFFIX);
    }

    public List<Tuple> getValidators(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null || fields.get(field + _VALIDATORS_SUFFIX) == null) {
            return null;
        }
        return (List)fields.get(field + _VALIDATORS_SUFFIX);
    }

    public String getValue(String model, String field, String name, String defaultValue) {
        Map<String, String> hints = this.getHints(model, field);
        if (hints == null) {
            return defaultValue;
        }
        return GetterUtil.getString((String)hints.get(name), (String)defaultValue);
    }

    public boolean hasField(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return false;
        }
        return fields.containsKey(field + _ELEMENTS_SUFFIX);
    }

    public boolean isCustomValidator(String validatorName) {
        return validatorName.equals("custom");
    }

    public boolean isLocalized(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return false;
        }
        Boolean localized = (Boolean)fields.get(field + _LOCALIZATION_SUFFIX);
        if (localized != null) {
            return localized;
        }
        return false;
    }

    public void read(ClassLoader classLoader, InputStream inputStream) throws Exception {
        this.read(classLoader, null, inputStream);
    }

    public void read(ClassLoader classLoader, String source) throws Exception {
        this.read(classLoader, source, classLoader.getResourceAsStream(source));
    }

    public void read(ClassLoader classLoader, String source, InputStream inputStream) throws Exception {
        String name;
        if (inputStream == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        SAXReader saxReader = this.getSAXReader();
        Document document = saxReader.read(inputStream);
        Element rootElement = document.getRootElement();
        List rootElements = rootElement.elements("hint-collection");
        for (Element hintCollectionElement : rootElements) {
            name = hintCollectionElement.attributeValue("name");
            Map<String, String> hints = this._hintCollections.get(name);
            if (hints == null) {
                hints = new HashMap<String, String>();
                this._hintCollections.put(name, hints);
            }
            List hintElements = hintCollectionElement.elements("hint");
            for (Element hintElement : hintElements) {
                String hintName = hintElement.attributeValue("name");
                String hintValue = hintElement.getText();
                hints.put(hintName, hintValue);
            }
        }
        rootElements = rootElement.elements("model");
        for (Element modelElement : rootElements) {
            LinkedHashMap<String, Object> fields;
            name = modelElement.attributeValue("name");
            ModelHintsCallback modelHintsCallback = this.getModelHintsCallback();
            modelHintsCallback.execute(classLoader, name);
            HashMap<String, String> defaultHints = new HashMap<String, String>();
            this._defaultHints.put(name, defaultHints);
            Element defaultHintsElement = modelElement.element("default-hints");
            if (defaultHintsElement != null) {
                List hintElements = defaultHintsElement.elements("hint");
                for (Element hintElement : hintElements) {
                    String hintName = hintElement.attributeValue("name");
                    String hintValue = hintElement.getText();
                    defaultHints.put(hintName, hintValue);
                }
            }
            if ((fields = (LinkedHashMap<String, Object>)this._modelFields.get(name)) == null) {
                fields = new LinkedHashMap<String, Object>();
                this._modelFields.put(name, fields);
            }
            this._models.add(name);
            List modelElements = modelElement.elements("field");
            for (Element fieldElement : modelElements) {
                String fieldName = fieldElement.attributeValue("name");
                String fieldType = fieldElement.attributeValue("type");
                boolean fieldLocalized = GetterUtil.getBoolean((String)fieldElement.attributeValue("localized"));
                HashMap fieldHints = HashMapBuilder.putAll(defaultHints).build();
                List fieldElements = fieldElement.elements("hint-collection");
                for (Element hintCollectionElement : fieldElements) {
                    Map<String, String> hints = this._hintCollections.get(hintCollectionElement.attributeValue("name"));
                    fieldHints.putAll(hints);
                }
                fieldElements = fieldElement.elements("hint");
                for (Element hintElement : fieldElements) {
                    String hintName = hintElement.attributeValue("name");
                    String hintValue = hintElement.getText();
                    fieldHints.put(hintName, hintValue);
                }
                Tuple fieldSanitize = null;
                Element sanitizeElement = fieldElement.element("sanitize");
                if (sanitizeElement != null) {
                    String contentType = sanitizeElement.attributeValue("content-type");
                    String modes = sanitizeElement.attributeValue("modes");
                    fieldSanitize = new Tuple(new Object[]{fieldName, contentType, modes});
                }
                TreeMap<String, Tuple> fieldValidators = new TreeMap<String, Tuple>();
                fieldElements = fieldElement.elements("validator");
                for (Element validatorElement : fieldElements) {
                    String validatorName = validatorElement.attributeValue("name");
                    if (Validator.isNull((String)validatorName)) continue;
                    String validatorErrorMessage = GetterUtil.getString((String)validatorElement.attributeValue("error-message"));
                    String validatorValue = GetterUtil.getString((String)validatorElement.getText());
                    boolean customValidator = this.isCustomValidator(validatorName);
                    if (customValidator) {
                        validatorName = this.buildCustomValidatorName(validatorName);
                    }
                    Tuple fieldValidator = new Tuple(new Object[]{fieldName, validatorName, validatorErrorMessage, validatorValue, customValidator});
                    fieldValidators.put(validatorName, fieldValidator);
                }
                fields.put(fieldName + _ELEMENTS_SUFFIX, fieldElement);
                fields.put(fieldName + _TYPE_SUFFIX, fieldType);
                fields.put(fieldName + _LOCALIZATION_SUFFIX, fieldLocalized);
                fields.put(fieldName + _HINTS_SUFFIX, fieldHints);
                if (fieldSanitize != null) {
                    fields.put(fieldName + _SANITIZE_SUFFIX, fieldSanitize);
                }
                if (fieldValidators.isEmpty()) continue;
                fields.put(fieldName + _VALIDATORS_SUFFIX, ListUtil.fromMapValues(fieldValidators));
            }
        }
    }

    public String trimString(String model, String field, String value) {
        if (value == null) {
            return value;
        }
        int maxLength = this.getMaxLength(model, field);
        if (value.length() > maxLength) {
            return value.substring(0, maxLength);
        }
        return value;
    }
}

