/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.model.impl.UserGroupRoleModelImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;

public class UserGroupRoleModelListener
extends BaseModelListener<UserGroupRole> {
    public void onAfterCreate(UserGroupRole userGroupRole) {
        this._clearCache(userGroupRole);
        this._reindexUser(userGroupRole.getUserId());
    }

    public void onAfterRemove(UserGroupRole userGroupRole) {
        this._clearCache(userGroupRole);
        this._reindexUser(userGroupRole.getUserId());
    }

    public void onAfterUpdate(UserGroupRole originalUserGroupRole, UserGroupRole userGroupRole) {
        this._clearCache(userGroupRole);
        this._reindexUser(userGroupRole.getUserId());
    }

    public void onBeforeUpdate(UserGroupRole originalUserGroupRole, UserGroupRole userGroupRole) {
        UserGroupRoleModelImpl userGroupRoleModelImpl = (UserGroupRoleModelImpl)userGroupRole;
        long originalUserId = (Long)userGroupRoleModelImpl.getColumnOriginalValue("userId");
        if (originalUserId != userGroupRoleModelImpl.getUserId()) {
            PermissionCacheUtil.clearCache(originalUserId);
        }
    }

    private void _clearCache(UserGroupRole userGroupRole) {
        if (userGroupRole != null) {
            PermissionCacheUtil.clearCache(userGroupRole.getUserId());
        }
    }

    private void _reindexUser(long userId) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex(User.class.getName(), userId);
        }
        catch (SearchException searchException) {
            throw new ModelListenerException((Throwable)searchException);
        }
    }
}

