/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PluginSettingLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.LayoutServiceBaseImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class LayoutServiceImpl
extends LayoutServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutServiceImpl.class);
    @BeanReference(type=ExportImportConfigurationLocalService.class)
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=PluginSettingLocalService.class)
    private PluginSettingLocalService _pluginSettingLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, long classNameId, long classPK, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        Layout layout = this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, classNameId, classPK, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, masterLayoutPlid, serviceContext);
        this.checkLayoutTypeSettings(layout, "", typeSettings);
        return layout;
    }

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(groupId, privateLayout, parentLayoutId, 0L, 0L, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, false, friendlyURLMap, masterLayoutPlid, serviceContext);
    }

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(groupId, privateLayout, parentLayoutId, 0L, 0L, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, false, friendlyURLMap, 0L, serviceContext);
    }

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext);
    }

    public FileEntry addTempFileEntry(long groupId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"DELETE");
        this.layoutLocalService.deleteLayout(groupId, privateLayout, layoutId, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"DELETE");
        this.layoutLocalService.deleteLayout(plid, serviceContext);
    }

    public void deleteTempFileEntry(long groupId, String folderName, String fileName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName);
    }

    public Layout fetchLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layout != null) {
            LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        }
        return layout;
    }

    public List<Layout> getAncestorLayouts(long plid) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        return this.filterLayouts(layout.getAncestors());
    }

    public long getControlPanelLayoutPlid() throws PortalException {
        Group group = this._groupLocalService.fetchGroup(CompanyThreadLocal.getCompanyId().longValue(), "Control Panel");
        List layouts = this.layoutLocalService.getLayouts(group.getGroupId(), true);
        if (ListUtil.isEmpty((List)layouts)) {
            throw new NoSuchLayoutException("Unable to get control panel layout");
        }
        Layout layout = (Layout)layouts.get(0);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout.getPlid();
    }

    public long getDefaultPlid(long groupId, boolean privateLayout) {
        return this.layoutLocalService.getDefaultPlid(groupId, privateLayout);
    }

    public long getDefaultPlid(long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId <= 0L) {
            return 0L;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        String scopeGroupLayoutUuid = null;
        Group scopeGroup = this._groupLocalService.getGroup(scopeGroupId);
        if (scopeGroup.isLayout()) {
            Layout scopeGroupLayout = this.layoutLocalService.getLayout(scopeGroup.getClassPK());
            scopeGroupLayoutUuid = scopeGroupLayout.getUuid();
        }
        Map jxPortletPreferencesMap = PortletPreferencesFactoryUtil.getPortletSetupMap((long)scopeGroup.getCompanyId(), (long)groupId, (long)0L, (int)3, (String)portletId, (boolean)privateLayout);
        for (Map.Entry entry : jxPortletPreferencesMap.entrySet()) {
            LayoutTypePortlet layoutTypePortlet;
            long plid = (Long)entry.getKey();
            Layout layout = null;
            try {
                layout = this.layoutLocalService.getLayout(plid);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)noSuchLayoutException);
                continue;
            }
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW") || !layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
            PortletPreferences jxPortletPreferences = (PortletPreferences)entry.getValue();
            String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
            if (scopeGroup.isLayout()) {
                String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                if (!Validator.isNotNull((String)scopeType) || !Validator.isNotNull((String)scopeLayoutUuid) || !scopeLayoutUuid.equals(scopeGroupLayoutUuid)) continue;
                return layout.getPlid();
            }
            if (!(scopeGroup.isCompany() ? Validator.isNotNull((String)scopeType) && scopeType.equals("company") : Validator.isNull((String)scopeType))) continue;
            return layout.getPlid();
        }
        return 0L;
    }

    @ThreadLocalCachable
    public long getDefaultPlid(long groupId, long scopeGroupId, String portletId) throws PortalException {
        long plid = this.getDefaultPlid(groupId, scopeGroupId, false, portletId);
        if (plid == 0L) {
            plid = this.getDefaultPlid(groupId, scopeGroupId, true, portletId);
        }
        return plid;
    }

    public Layout getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout;
    }

    public String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout.getName(languageId);
    }

    public long getLayoutPlid(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout.getPlid();
    }

    public LayoutReference[] getLayoutReferences(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        LayoutReference[] layoutReferences = this.layoutLocalService.getLayouts(companyId, portletId, preferencesKey, preferencesValue);
        ArrayList<LayoutReference> filteredLayoutReferences = new ArrayList<LayoutReference>(layoutReferences.length);
        for (LayoutReference layoutReference : layoutReferences) {
            try {
                LayoutModel layoutModel = layoutReference.getLayoutModel();
                if (!LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)layoutModel.getPlid(), (String)"VIEW")) continue;
                filteredLayoutReferences.add(layoutReference);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
        return filteredLayoutReferences.toArray(new LayoutReference[0]);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.filterFindByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws PortalException {
        return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId));
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws PortalException {
        return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end));
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) throws PortalException {
        return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, type));
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type, int start, int end) throws PortalException {
        return this.layoutPersistence.filterFindByG_P_T(groupId, privateLayout, type, start, end);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String keywords, String[] types, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterFindByG_P(groupId, privateLayout, start, end, orderByComparator);
        }
        return this.layoutLocalService.getLayouts(groupId, this.getUserId(), privateLayout, keywords, types, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String keywords, String[] types, int[] statuses, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterFindByG_P_ST(groupId, privateLayout, statuses, start, end, orderByComparator);
        }
        return this.layoutLocalService.getLayouts(groupId, this.getUserId(), privateLayout, keywords, types, statuses, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, String type) {
        return this.layoutPersistence.filterFindByG_T(groupId, type);
    }

    public List<Layout> getLayouts(long groupId, String type, int start, int end) {
        return this.layoutPersistence.filterFindByG_T(groupId, type, start, end);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout) {
        return this.layoutPersistence.filterCountByG_P(groupId, privateLayout);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.filterCountByG_P_P(groupId, privateLayout, parentLayoutId);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId, int priority) {
        return this.layoutPersistence.filterCountByG_P_P_LteP(groupId, privateLayout, parentLayoutId, priority);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, String type) {
        return this.layoutPersistence.filterCountByG_P_T(groupId, privateLayout, type);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, String keywords, String[] types) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterCountByG_P(groupId, privateLayout);
        }
        return this.layoutLocalService.getLayoutsCount(groupId, this.getUserId(), privateLayout, keywords, types);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, String keywords, String[] types, int[] statuses) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterCountByG_P_ST(groupId, privateLayout, statuses);
        }
        return this.layoutLocalService.getLayoutsCount(groupId, this.getUserId(), privateLayout, keywords, types, statuses);
    }

    public int getLayoutsCount(long groupId, String type) {
        return this.layoutPersistence.filterCountByG_T(groupId, type);
    }

    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}));
    }

    public boolean hasLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.layoutLocalService.hasLayout(uuid, groupId, privateLayout);
    }

    public boolean hasPortletId(long plid, String portletId) throws PortalException {
        LayoutTypePortlet layoutTypePortlet;
        Layout layout = this.layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return false;
        }
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        LayoutType layoutType = layout.getLayoutType();
        return layoutType instanceof LayoutTypePortlet && (layoutTypePortlet = (LayoutTypePortlet)layoutType).hasPortletId(portletId);
    }

    public Layout publishLayout(long plid) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"PUBLISH_STAGING");
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)PortalUUIDUtil.generate(), (String)groupName, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)cronText, (TimeZone)TimeZone.getTimeZone(MapUtil.getString(parameterMap, (String)"timeZoneId")));
        User user = this._userPersistence.findByPrimaryKey(this.getUserId());
        Map publishLayoutLocalSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutLocalSettingsMap((User)user, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 3, publishLayoutLocalSettingsMap);
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_local_publisher", (Object)exportImportConfiguration.getExportImportConfigurationId(), (int)0);
    }

    public void schedulePublishToRemote(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)sourceGroupId, (String)"PUBLISH_STAGING");
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)PortalUUIDUtil.generate(), (String)groupName, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)cronText, (TimeZone)TimeZone.getTimeZone(MapUtil.getString(parameterMap, (String)"timeZoneId")));
        User user = this._userPersistence.findByPrimaryKey(this.getUserId());
        Map publishLayoutRemoteSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutRemoteSettingsMap((long)this.getUserId(), (long)sourceGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 4, publishLayoutRemoteSettingsMap);
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_remote_publisher", (Object)exportImportConfiguration.getExportImportConfigurationId(), (int)0);
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        this.layoutLocalService.setLayouts(groupId, privateLayout, parentLayoutId, layoutIds, serviceContext);
    }

    public void unschedulePublishToLive(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public void unschedulePublishToRemote(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateIconImage(plid, bytes);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean hasIconImage, byte[] iconBytes, long masterLayoutPlid, long styleBookEntryId, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
        Layout updatedLayout = this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, hasIconImage, iconBytes, masterLayoutPlid, styleBookEntryId, serviceContext);
        if (!(layout.getLayoutType() instanceof LayoutTypePortlet)) {
            this.checkLayoutTypeSettings(layout, "", updatedLayout.getTypeSettings());
        }
        return updatedLayout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
        this.checkLayoutTypeSettings(layout, layout.getTypeSettings(), typeSettings);
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        if (Validator.isNotNull((String)themeId)) {
            this._pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        }
        return this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateName(groupId, privateLayout, layoutId, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateName(plid, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(plid, parentPlid);
    }

    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutIdAndPriority(plid, parentPlid, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, nextLayoutId, previousLayoutId);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(plid, priority);
    }

    public Layout updateType(long plid, String type) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)this.layoutLocalService.getLayout(plid), (String)"UPDATE");
        return this.layoutLocalService.updateType(plid, type);
    }

    protected void checkLayoutTypeSettings(Layout layout, String originalTypeSettings, String newTypeSettings) throws PortalException {
        if (!(layout.getLayoutType() instanceof LayoutTypePortlet)) {
            return;
        }
        List<String> originalPortletIds = this.getPortletIds(layout, originalTypeSettings);
        List<String> newPortletIds = this.getPortletIds(layout, newTypeSettings);
        for (String portletId : newPortletIds) {
            if (originalPortletIds.contains(portletId)) continue;
            PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getPlid(), (String)portletId, (String)"ADD_TO_PAGE");
        }
    }

    protected List<Layout> filterLayouts(List<Layout> layouts) throws PortalException {
        ArrayList<Layout> filteredLayouts = new ArrayList<Layout>();
        for (Layout layout : layouts) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW")) continue;
            filteredLayouts.add(layout);
        }
        return filteredLayouts;
    }

    protected List<String> getPortletIds(Layout layout, String typeSettings) {
        if (Validator.isBlank((String)typeSettings)) {
            return Collections.emptyList();
        }
        Layout clonedLayout = (Layout)layout.clone();
        clonedLayout.setType("portlet");
        clonedLayout.setTypeSettings(typeSettings);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)clonedLayout.getLayoutType();
        return layoutTypePortlet.getPortletIds();
    }
}

