/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.DuplicateRoleException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredRoleException;
import com.liferay.portal.kernel.exception.RoleNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.Groups_OrgsTable;
import com.liferay.portal.kernel.model.Groups_RolesTable;
import com.liferay.portal.kernel.model.Groups_UserGroupsTable;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourceActionTable;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.ResourcePermissionTable;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleTable;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.TeamTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRoleTable;
import com.liferay.portal.kernel.model.UserGroupRoleTable;
import com.liferay.portal.kernel.model.UserGroups_TeamsTable;
import com.liferay.portal.kernel.model.Users_GroupsTable;
import com.liferay.portal.kernel.model.Users_OrgsTable;
import com.liferay.portal.kernel.model.Users_RolesTable;
import com.liferay.portal.kernel.model.Users_TeamsTable;
import com.liferay.portal.kernel.model.Users_UserGroupsTable;
import com.liferay.portal.kernel.model.role.RoleConstants;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.ResourcePermissionPersistence;
import com.liferay.portal.kernel.service.persistence.TeamPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.RoleLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RoleLocalServiceImpl
extends RoleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(RoleLocalServiceImpl.class);
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @BeanReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=LayoutLocalService.class)
    private LayoutLocalService _layoutLocalService;
    @BeanReference(type=ResourceActionLocalService.class)
    private ResourceActionLocalService _resourceActionLocalService;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=ResourcePermissionLocalService.class)
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @BeanReference(type=ResourcePermissionPersistence.class)
    private ResourcePermissionPersistence _resourcePermissionPersistence;
    @BeanReference(type=TeamPersistence.class)
    private TeamPersistence _teamPersistence;
    @BeanReference(type=UserGroupGroupRoleLocalService.class)
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @BeanReference(type=UserGroupRoleLocalService.class)
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public Role addRole(long userId, String className, long classPK, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String subtype, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        className = GetterUtil.getString((String)className);
        long classNameId = this._classNameLocalService.getClassNameId(className);
        long roleId = this.counterLocalService.increment();
        if (classNameId <= 0L || className.equals(Role.class.getName())) {
            classNameId = this._classNameLocalService.getClassNameId(Role.class);
            classPK = roleId;
        }
        this.validate(0L, user.getCompanyId(), classNameId, name);
        Role role = this.rolePersistence.create(roleId);
        if (serviceContext != null) {
            role.setUuid(serviceContext.getUuid());
        }
        role.setCompanyId(user.getCompanyId());
        role.setUserId(user.getUserId());
        role.setUserName(user.getFullName());
        role.setClassNameId(classNameId);
        role.setClassPK(classPK);
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescriptionMap(descriptionMap);
        role.setType(type);
        role.setSubtype(subtype);
        role.setExpandoBridgeAttributes(serviceContext);
        role = (Role)this.rolePersistence.update((BaseModel)role);
        long ownerId = userId;
        if (user.isDefaultUser()) {
            ownerId = 0L;
        }
        this._resourceLocalService.addResources(user.getCompanyId(), 0L, ownerId, Role.class.getName(), role.getRoleId(), false, false, false);
        if (!user.isDefaultUser()) {
            this._resourceLocalService.addResources(user.getCompanyId(), 0L, userId, Role.class.getName(), role.getRoleId(), false, false, false);
            if (!ExportImportThreadLocal.isImportInProcess()) {
                this.reindex(userId);
            }
        }
        return role;
    }

    @Override
    public void addUserRole(long userId, long roleId) throws PortalException {
        this._userPersistence.addRole(userId, roleId);
        this.reindex(userId);
    }

    @Override
    public void addUserRole(long userId, Role role) throws PortalException {
        this._userPersistence.addRole(userId, role);
        this.reindex(userId);
    }

    @Override
    public void addUserRoles(long userId, List<Role> roles) throws PortalException {
        this._userPersistence.addRoles(userId, roles);
        this.reindex(userId);
    }

    @Override
    public void addUserRoles(long userId, long[] roleIds) throws PortalException {
        this._userPersistence.addRoles(userId, roleIds);
        this.reindex(userId);
    }

    public void checkSystemRoles() throws PortalException {
        this._companyLocalService.forEachCompanyId(companyId -> this.checkSystemRoles((long)companyId));
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemRoles(long companyId) throws PortalException {
        String[] allSystemRoles;
        String[] systemSiteRoles;
        String[] systemOrganizationRoles;
        String[] systemRoles;
        HashMap<String, Role> companyRolesMap = new HashMap<String, Role>();
        for (String[] role : this.rolePersistence.findByCompanyId(companyId)) {
            companyRolesMap.put(role.getName(), (Role)role);
        }
        for (String name : systemRoles = PortalUtil.getSystemRoles()) {
            HashMap descriptionMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)PropsUtil.get(StringBundler.concat((String[])new String[]{"system.role.", StringUtil.replace((String)name, (char)' ', (char)'.'), ".description"}))).build();
            int type = 1;
            this.checkSystemRole(companyRolesMap, companyId, name, descriptionMap, type);
        }
        for (String name : systemOrganizationRoles = PortalUtil.getSystemOrganizationRoles()) {
            HashMap descriptionMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)PropsUtil.get(StringBundler.concat((String[])new String[]{"system.organization.role.", StringUtil.replace((String)name, (char)' ', (char)'.'), ".description"}))).build();
            int type = 3;
            this.checkSystemRole(companyRolesMap, companyId, name, descriptionMap, type);
        }
        for (String name : systemSiteRoles = PortalUtil.getSystemSiteRoles()) {
            HashMap descriptionMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)PropsUtil.get(StringBundler.concat((String[])new String[]{"system.site.role.", StringUtil.replace((String)name, (char)' ', (char)'.'), ".description"}))).build();
            int type = 2;
            this.checkSystemRole(companyRolesMap, companyId, name, descriptionMap, type);
        }
        for (String roleName : allSystemRoles = (String[])ArrayUtil.append((Object[][])new String[][]{systemRoles, systemOrganizationRoles, systemSiteRoles})) {
            Role role = this.getRole(companyId, roleName);
            this._resourceLocalService.addResources(companyId, 0L, 0L, Role.class.getName(), role.getRoleId(), false, false, false);
        }
        Role userRole = this.getRole(companyId, "User");
        for (String roleName : allSystemRoles) {
            if (companyRolesMap.containsKey(roleName)) continue;
            Role role = this.getRole(companyId, roleName);
            this._resourcePermissionLocalService.setResourcePermissions(companyId, Role.class.getName(), 4, String.valueOf(role.getRoleId()), userRole.getRoleId(), new String[]{"VIEW"});
        }
    }

    @Override
    public void clearUserRoles(long userId) throws PortalException {
        this._userPersistence.clearRoles(userId);
        this.reindex(userId);
    }

    @Override
    public Role deleteRole(long roleId) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        return this.roleLocalService.deleteRole(role);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Role deleteRole(Role role) throws PortalException {
        if (role.isSystem() && !CompanyThreadLocal.isDeleteInProcess()) {
            throw new RequiredRoleException();
        }
        List resourcePermissions = this._resourcePermissionPersistence.findByRoleId(role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this._resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        this._resourceLocalService.deleteResource(role.getCompanyId(), Role.class.getName(), 4, role.getRoleId());
        if (role.getType() == 5 || role.getType() == 3 || role.getType() == 2) {
            List groups = this._groupPersistence.findByC_S(role.getCompanyId(), true);
            for (Group group : groups) {
                UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
                List defaultSiteRoleIds = ListUtil.fromArray((long[])StringUtil.split((String)typeSettingsUnicodeProperties.getProperty("defaultSiteRoleIds"), (long)0L));
                if (!defaultSiteRoleIds.contains(role.getRoleId())) continue;
                defaultSiteRoleIds.remove(role.getRoleId());
                typeSettingsUnicodeProperties.setProperty("defaultSiteRoleIds", ListUtil.toString((List)defaultSiteRoleIds, (String)""));
                this._groupLocalService.updateGroup(group.getGroupId(), typeSettingsUnicodeProperties.toString());
            }
            this._userGroupRoleLocalService.deleteUserGroupRolesByRoleId(role.getRoleId());
            this._userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByRoleId(role.getRoleId());
        }
        this.rolePersistence.remove((BaseModel)role);
        this._expandoRowLocalService.deleteRows(role.getRoleId());
        return role;
    }

    @Override
    public void deleteUserRole(long userId, long roleId) throws PortalException {
        this._userPersistence.removeRole(userId, roleId);
        this.reindex(userId);
    }

    @Override
    public void deleteUserRole(long userId, Role role) throws PortalException {
        this._userPersistence.removeRole(userId, role);
        this.reindex(userId);
    }

    @Override
    public void deleteUserRoles(long userId, List<Role> roles) throws PortalException {
        this._userPersistence.removeRoles(userId, roles);
        this.reindex(userId);
    }

    @Override
    public void deleteUserRoles(long userId, long[] roleIds) throws PortalException {
        this._userPersistence.removeRoles(userId, roleIds);
        this.reindex(userId);
    }

    public Role fetchRole(long companyId, String name) {
        return this.rolePersistence.fetchByC_N(companyId, name);
    }

    public int getAssigneesTotal(long roleId) throws PortalException {
        int assigneesTotal = 0;
        Role role = this.getRole(roleId);
        int type = role.getType();
        if (type == 1) {
            assigneesTotal += this._groupLocalService.getRoleGroupsCount(roleId);
            assigneesTotal += this._userLocalService.getRoleUsersCount(roleId, 0);
        }
        if (type == 5 || type == 2) {
            DynamicQuery userGroupGroupRoleDynamicQuery = this._userGroupGroupRoleLocalService.dynamicQuery();
            Property property = PropertyFactoryUtil.forName((String)"roleId");
            userGroupGroupRoleDynamicQuery.add(property.eq((Object)roleId));
            userGroupGroupRoleDynamicQuery.setProjection(ProjectionFactoryUtil.countDistinct((String)"userGroupId"));
            List list = this._userGroupRoleLocalService.dynamicQuery(userGroupGroupRoleDynamicQuery);
            Long count = (Long)list.get(0);
            assigneesTotal += count.intValue();
        }
        if (type == 5 || type == 3 || type == 2) {
            DynamicQuery userDynamicQuery = this._userLocalService.dynamicQuery();
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            userDynamicQuery.add(statusProperty.eq((Object)0));
            userDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"userId"));
            DynamicQuery userGroupRoleDynamicQuery = this._userGroupRoleLocalService.dynamicQuery();
            Property userIdProperty = PropertyFactoryUtil.forName((String)"userId");
            userGroupRoleDynamicQuery.add(userIdProperty.in(userDynamicQuery));
            Property roleIdProperty = PropertyFactoryUtil.forName((String)"roleId");
            userGroupRoleDynamicQuery.add(roleIdProperty.eq((Object)roleId));
            userGroupRoleDynamicQuery.setProjection(ProjectionFactoryUtil.countDistinct((String)"userId"));
            List list = this._userGroupRoleLocalService.dynamicQuery(userGroupRoleDynamicQuery);
            Long count = (Long)list.get(0);
            assigneesTotal += count.intValue();
        }
        return assigneesTotal;
    }

    public Role getDefaultGroupRole(long groupId) throws PortalException {
        Group group = this._groupPersistence.findByPrimaryKey(groupId);
        if (group.isLayout()) {
            Layout layout = this._layoutLocalService.getLayout(group.getClassPK());
            group = layout.getGroup();
        }
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        Role role = null;
        role = group.isCompany() ? this.getRole(group.getCompanyId(), "User") : (group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.isRegularSite() || group.isSite() ? this.getRole(group.getCompanyId(), "Site Member") : (group.isOrganization() ? this.getRole(group.getCompanyId(), "Organization User") : this.getRole(group.getCompanyId(), "User")));
        return role;
    }

    public List<Role> getGroupRelatedRoles(long groupId) throws PortalException {
        ArrayList<Role> roles = new ArrayList<Role>();
        Group group = this._groupLocalService.getGroup(groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        int[] types = RoleConstants.TYPES_REGULAR;
        if (group.isOrganization()) {
            types = group.isSite() ? RoleConstants.TYPES_ORGANIZATION_AND_REGULAR_AND_SITE : RoleConstants.TYPES_ORGANIZATION_AND_REGULAR;
        } else if (group.isLayout() || group.isLayoutSetPrototype() || group.isSite() || group.isUser()) {
            types = RoleConstants.TYPES_REGULAR_AND_SITE;
        }
        roles.addAll(this.getRoles(group.getCompanyId(), types));
        roles.addAll(this.getTeamRoles(groupId));
        return roles;
    }

    public List<Role> getGroupRolesAndTeamRoles(long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId, int start, int end) {
        return this.roleFinder.findByGroupRoleAndTeamRole(companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId, start, end);
    }

    public int getGroupRolesAndTeamRolesCount(long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId) {
        return this.roleFinder.countByGroupRoleAndTeamRole(companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId);
    }

    public Map<String, List<String>> getResourceRoles(long companyId, String name, int scope, String primKey) {
        HashMap<String, List<String>> rolesMap = new HashMap<String, List<String>>();
        for (Object[] array : (List)this.rolePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{RoleTable.INSTANCE.name.as("roleName"), ResourceActionTable.INSTANCE.actionId.as("actionId")}).from((Table)ResourcePermissionTable.INSTANCE).innerJoinON((Table)RoleTable.INSTANCE, RoleTable.INSTANCE.roleId.eq((Expression)ResourcePermissionTable.INSTANCE.roleId)).innerJoinON((Table)ResourceActionTable.INSTANCE, ResourceActionTable.INSTANCE.name.eq((Expression)ResourcePermissionTable.INSTANCE.name).and((Expression)ResourceActionTable.INSTANCE.bitwiseValue.eq(DSLFunctionFactoryUtil.bitAnd((Expression)ResourcePermissionTable.INSTANCE.actionIds, (Expression)ResourceActionTable.INSTANCE.bitwiseValue)))).where(ResourcePermissionTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)ResourcePermissionTable.INSTANCE.name.eq((Object)name)).and((Expression)ResourcePermissionTable.INSTANCE.scope.eq((Object)scope)).and((Expression)ResourcePermissionTable.INSTANCE.primKey.eq((Object)primKey))))) {
            String roleName = (String)array[0];
            String actionId = (String)array[1];
            List roles = rolesMap.computeIfAbsent(roleName, key -> new ArrayList());
            roles.add(actionId);
        }
        return rolesMap;
    }

    public List<Role> getResourceRoles(long companyId, String name, int scope, String primKey, String actionId) {
        ResourceAction resourceAction = this._resourceActionLocalService.fetchResourceAction(name, actionId);
        if (resourceAction == null) {
            return Collections.emptyList();
        }
        return (List)this.rolePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)RoleTable.INSTANCE).from((Table)RoleTable.INSTANCE).innerJoinON((Table)ResourcePermissionTable.INSTANCE, ResourcePermissionTable.INSTANCE.roleId.eq((Expression)RoleTable.INSTANCE.roleId)).where(ResourcePermissionTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)ResourcePermissionTable.INSTANCE.name.eq((Object)name)).and((Expression)ResourcePermissionTable.INSTANCE.scope.eq((Object)scope)).and((Expression)ResourcePermissionTable.INSTANCE.primKey.eq((Object)primKey)).and((Expression)DSLFunctionFactoryUtil.bitAnd((Expression)ResourcePermissionTable.INSTANCE.actionIds, (long)resourceAction.getBitwiseValue()).eq((Object)resourceAction.getBitwiseValue()))).orderBy(new OrderByExpression[]{RoleTable.INSTANCE.name.ascending()}));
    }

    public Role getRole(long companyId, String name) throws PortalException {
        return this.rolePersistence.findByC_N(companyId, name);
    }

    public List<Role> getRoles(int type, String subtype) {
        return this.rolePersistence.findByT_S(type, subtype);
    }

    public List<Role> getRoles(long companyId) {
        return this.rolePersistence.findByCompanyId(companyId);
    }

    public List<Role> getRoles(long companyId, int[] types) {
        return this.rolePersistence.findByC_T(companyId, types);
    }

    public List<Role> getRoles(long companyId, long classNameId, long[] classPKs, int type) {
        return this.rolePersistence.findByC_C_C_T(companyId, classNameId, classPKs, type);
    }

    public List<Role> getRoles(long[] roleIds) throws PortalException {
        ArrayList<Role> roles = new ArrayList<Role>(roleIds.length);
        for (long roleId : roleIds) {
            roles.add(this.getRole(roleId));
        }
        return roles;
    }

    public List<Role> getSubtypeRoles(String subtype) {
        return this.rolePersistence.findBySubtype(subtype);
    }

    public int getSubtypeRolesCount(String subtype) {
        return this.rolePersistence.countBySubtype(subtype);
    }

    public Role getTeamRole(long companyId, long teamId) throws PortalException {
        return this.rolePersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(Team.class), teamId);
    }

    public Map<Team, Role> getTeamRoleMap(long groupId) throws PortalException {
        return this.getTeamRoleMap(groupId, null);
    }

    public List<Role> getTeamRoles(long groupId) throws PortalException {
        return this.getTeamRoles(groupId, null);
    }

    public List<Role> getTeamRoles(long groupId, long[] excludedRoleIds) throws PortalException {
        Map<Team, Role> teamRoleMap = this.getTeamRoleMap(groupId, excludedRoleIds);
        Collection<Role> roles = teamRoleMap.values();
        return ListUtil.fromCollection(roles);
    }

    public List<Role> getTeamsRoles(long companyId, long[] teamIds) throws PortalException {
        return this.rolePersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(Team.class), teamIds);
    }

    public List<Role> getTypeRoles(int type) {
        return this.rolePersistence.findByType(type);
    }

    public List<Role> getTypeRoles(int type, int start, int end) {
        return this.rolePersistence.findByType(type, start, end);
    }

    public int getTypeRolesCount(int type) {
        return this.rolePersistence.countByType(type);
    }

    public List<Role> getUserGroupGroupRoles(long userId, long groupId) {
        return this.getUserGroupGroupRoles(userId, groupId, -1, -1);
    }

    public List<Role> getUserGroupGroupRoles(long userId, long groupId, int start, int end) {
        return (List)this.rolePersistence.dslQuery(DSLQueryFactoryUtil.select((Table)RoleTable.INSTANCE).from((Table)RoleTable.INSTANCE).innerJoinON((Table)UserGroupGroupRoleTable.INSTANCE, UserGroupGroupRoleTable.INSTANCE.roleId.eq((Expression)RoleTable.INSTANCE.roleId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)UserGroupGroupRoleTable.INSTANCE.userGroupId)).where(Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId).and((Expression)UserGroupGroupRoleTable.INSTANCE.groupId.eq((Object)groupId))).limit(start, end));
    }

    public int getUserGroupGroupRolesCount(long userId, long groupId) {
        return this.rolePersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)RoleTable.INSTANCE).innerJoinON((Table)UserGroupGroupRoleTable.INSTANCE, UserGroupGroupRoleTable.INSTANCE.roleId.eq((Expression)RoleTable.INSTANCE.roleId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)UserGroupGroupRoleTable.INSTANCE.userGroupId)).where(Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId).and((Expression)UserGroupGroupRoleTable.INSTANCE.groupId.eq((Object)groupId))));
    }

    public List<Role> getUserGroupRoles(long userId, long groupId) {
        return (List)this.rolePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)RoleTable.INSTANCE).from((Table)RoleTable.INSTANCE).innerJoinON((Table)UserGroupRoleTable.INSTANCE, UserGroupRoleTable.INSTANCE.roleId.eq((Expression)RoleTable.INSTANCE.roleId)).where(UserGroupRoleTable.INSTANCE.userId.eq((Object)userId).and((Expression)UserGroupRoleTable.INSTANCE.groupId.eq((Object)groupId))));
    }

    public List<Role> getUserRelatedRoles(long userId, List<Group> groups) {
        if (ListUtil.isEmpty(groups)) {
            return Collections.emptyList();
        }
        long[] groupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            groupIds[i] = group.getGroupId();
        }
        return this.getUserRelatedRoles(userId, groupIds);
    }

    public List<Role> getUserRelatedRoles(long userId, long groupId) {
        return this.getUserRelatedRoles(userId, new long[]{groupId});
    }

    public List<Role> getUserRelatedRoles(long userId, long[] groupIds) {
        return (List)this.rolePersistence.dslQuery(DSLQueryFactoryUtil.select((Table)RoleTable.INSTANCE).from((Table)RoleTable.INSTANCE).innerJoinON((Table)Users_RolesTable.INSTANCE, Users_RolesTable.INSTANCE.roleId.eq((Expression)RoleTable.INSTANCE.roleId)).where(Users_RolesTable.INSTANCE.userId.eq((Object)userId)).union((DSLQuery)DSLQueryFactoryUtil.select((Table)RoleTable.INSTANCE).from((Table)RoleTable.INSTANCE).innerJoinON((Table)Groups_RolesTable.INSTANCE, Groups_RolesTable.INSTANCE.roleId.eq((Expression)RoleTable.INSTANCE.roleId)).where(() -> {
            if (groupIds.length == 0) {
                return null;
            }
            Predicate predicate = Groups_RolesTable.INSTANCE.groupId.eq((Object)groupIds[0]);
            for (int i = 1; i < groupIds.length; ++i) {
                predicate = predicate.or((Expression)Groups_RolesTable.INSTANCE.groupId.eq((Object)groupIds[i]));
            }
            return predicate.withParentheses();
        })));
    }

    public List<Role> getUserTeamRoles(long userId, long groupId) {
        long classNameId = this._classNameLocalService.getClassNameId(Team.class);
        return (List)this.rolePersistence.dslQuery(DSLQueryFactoryUtil.select((Table)RoleTable.INSTANCE).from((Table)RoleTable.INSTANCE).innerJoinON((Table)TeamTable.INSTANCE, TeamTable.INSTANCE.companyId.eq((Expression)RoleTable.INSTANCE.companyId).and((Expression)TeamTable.INSTANCE.teamId.eq((Expression)RoleTable.INSTANCE.classPK))).innerJoinON((Table)Users_TeamsTable.INSTANCE, Users_TeamsTable.INSTANCE.teamId.eq((Expression)TeamTable.INSTANCE.teamId)).where(RoleTable.INSTANCE.classNameId.eq((Object)classNameId).and((Expression)TeamTable.INSTANCE.groupId.eq((Object)groupId)).and((Expression)Users_TeamsTable.INSTANCE.userId.eq((Object)userId))).union((DSLQuery)DSLQueryFactoryUtil.select((Table)RoleTable.INSTANCE).from((Table)RoleTable.INSTANCE).innerJoinON((Table)TeamTable.INSTANCE, TeamTable.INSTANCE.companyId.eq((Expression)RoleTable.INSTANCE.companyId).and((Expression)TeamTable.INSTANCE.teamId.eq((Expression)RoleTable.INSTANCE.classPK))).innerJoinON((Table)UserGroups_TeamsTable.INSTANCE, UserGroups_TeamsTable.INSTANCE.teamId.eq((Expression)TeamTable.INSTANCE.teamId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)UserGroups_TeamsTable.INSTANCE.userGroupId)).where(RoleTable.INSTANCE.classNameId.eq((Object)classNameId).and((Expression)TeamTable.INSTANCE.groupId.eq((Object)groupId)).and((Expression)Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId)))));
    }

    @ThreadLocalCachable
    public boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws PortalException {
        Role role = this.rolePersistence.fetchByC_N(companyId, name);
        if (role == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Role ", name, " with company ID ", companyId, " does not exist"}));
            }
            return false;
        }
        if (role.getType() != 1) {
            throw new IllegalArgumentException(name + " is not a regular role");
        }
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        if (userId == defaultUserId) {
            return name.equals("Guest");
        }
        if (inherited) {
            String roleId;
            String key;
            if (this._userPersistence.containsRole(userId, role.getRoleId())) {
                return true;
            }
            ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.REQUEST, (Serializable)((Object)RoleLocalServiceImpl.class.getName()));
            Boolean value = (Boolean)threadLocalCache.get(key = (roleId = String.valueOf(role.getRoleId())).concat(String.valueOf(userId)));
            if (value != null) {
                return value;
            }
            value = PermissionCacheUtil.getUserRole(userId, role);
            if (value == null) {
                List roleIds = (List)this.rolePersistence.dslQuery(DSLQueryFactoryUtil.select((Expression[])new Expression[]{Groups_RolesTable.INSTANCE.roleId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_OrgsTable.INSTANCE, Users_OrgsTable.INSTANCE.organizationId.eq((Expression)GroupTable.INSTANCE.classPK)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)role.getRoleId()).and((Expression)Users_OrgsTable.INSTANCE.userId.eq((Object)userId))).union((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{Groups_RolesTable.INSTANCE.roleId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)Groups_OrgsTable.INSTANCE, Groups_OrgsTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_OrgsTable.INSTANCE, Users_OrgsTable.INSTANCE.organizationId.eq((Expression)Groups_OrgsTable.INSTANCE.organizationId)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)role.getRoleId()).and((Expression)Users_OrgsTable.INSTANCE.userId.eq((Object)userId)))).union((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{Groups_RolesTable.INSTANCE.roleId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)Users_GroupsTable.INSTANCE, Users_GroupsTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)role.getRoleId()).and((Expression)Users_GroupsTable.INSTANCE.userId.eq((Object)userId)))).union((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{Users_RolesTable.INSTANCE.roleId}).from((Table)Users_RolesTable.INSTANCE).where(Users_RolesTable.INSTANCE.roleId.eq((Object)role.getRoleId()).and((Expression)Users_RolesTable.INSTANCE.userId.eq((Object)userId)))).union((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{Groups_RolesTable.INSTANCE.roleId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)GroupTable.INSTANCE.classPK)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)role.getRoleId()).and((Expression)Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId)))).union((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{Groups_RolesTable.INSTANCE.roleId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)Groups_UserGroupsTable.INSTANCE, Groups_UserGroupsTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)Groups_UserGroupsTable.INSTANCE.userGroupId)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)role.getRoleId()).and((Expression)Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId)))));
                value = !roleIds.isEmpty() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                PermissionCacheUtil.putUserRole(userId, role, value);
            }
            threadLocalCache.put(key, (Object)value);
            return value;
        }
        return this._userPersistence.containsRole(userId, role.getRoleId());
    }

    public boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws PortalException {
        for (String name : names) {
            if (!this.hasUserRole(userId, companyId, name, inherited)) continue;
            return true;
        }
        return false;
    }

    public List<Role> search(long companyId, String keywords, Integer[] types, int start, int end, OrderByComparator<Role> orderByComparator) {
        return this.search(companyId, keywords, types, new LinkedHashMap<String, Object>(), start, end, orderByComparator);
    }

    public List<Role> search(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> orderByComparator) {
        return this.roleFinder.findByKeywords(companyId, keywords, types, params, start, end, orderByComparator);
    }

    public List<Role> search(long companyId, String name, String description, Integer[] types, int start, int end, OrderByComparator<Role> orderByComparator) {
        return this.search(companyId, name, description, types, new LinkedHashMap<String, Object>(), start, end, orderByComparator);
    }

    public List<Role> search(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> orderByComparator) {
        return this.roleFinder.findByC_N_D_T(companyId, name, description, types, params, true, start, end, orderByComparator);
    }

    public int searchCount(long companyId, String keywords, Integer[] types) {
        return this.searchCount(companyId, keywords, types, new LinkedHashMap<String, Object>());
    }

    public int searchCount(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params) {
        return this.roleFinder.countByKeywords(companyId, keywords, types, params);
    }

    public int searchCount(long companyId, String name, String description, Integer[] types) {
        return this.searchCount(companyId, name, description, types, new LinkedHashMap<String, Object>());
    }

    public int searchCount(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params) {
        return this.roleFinder.countByC_N_D_T(companyId, name, description, types, params, true);
    }

    @Override
    public void setUserRoles(long userId, long[] roleIds) throws PortalException {
        roleIds = UsersAdminUtil.addRequiredRoles((long)userId, (long[])roleIds);
        this._userPersistence.setRoles(userId, roleIds);
        this.reindex(userId);
    }

    public void unsetUserRoles(long userId, long[] roleIds) throws PortalException {
        roleIds = UsersAdminUtil.removeRequiredRoles((long)userId, (long[])roleIds);
        this._userPersistence.removeRoles(userId, roleIds);
        this.reindex(userId);
    }

    public Role updateRole(long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype, ServiceContext serviceContext) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        this.validate(roleId, role.getCompanyId(), role.getClassNameId(), name);
        if (role.isSystem()) {
            name = role.getName();
            subtype = null;
        }
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescriptionMap(descriptionMap);
        role.setSubtype(subtype);
        role.setExpandoBridgeAttributes(serviceContext);
        return (Role)this.rolePersistence.update((BaseModel)role);
    }

    public void validateName(String name) throws PortalException {
        String[] invalidCharacters = StringUtil.split((String)", *", (String)" ");
        if (Validator.isNull((String)name) || StringUtil.indexOfAny((String)name, (String[])invalidCharacters) > -1) {
            throw new RoleNameException();
        }
        if (!PropsValues.ROLES_NAME_ALLOW_NUMERIC && Validator.isNumber((String)name)) {
            throw new RoleNameException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSystemRole(Map<String, Role> companyRolesMap, long companyId, String name, Map<Locale, String> descriptionMap, int type) throws PortalException {
        block11: {
            Role role = companyRolesMap.get(name);
            try {
                if (role == null) {
                    role = this.rolePersistence.findByC_N(companyId, name);
                }
                if (!descriptionMap.equals(role.getDescriptionMap())) {
                    role.setDescriptionMap(descriptionMap);
                    this.roleLocalService.updateRole(role);
                }
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchRoleException);
                }
                User user = this._userLocalService.getDefaultUser(companyId);
                PermissionThreadLocal.setAddResource((boolean)false);
                try {
                    role = this.roleLocalService.addRole(user.getUserId(), null, 0L, name, null, descriptionMap, type, null, null);
                }
                finally {
                    PermissionThreadLocal.setAddResource((boolean)true);
                }
                if (name.equals("Analytics Administrator")) {
                    this.initAnalyticsAdministratorViewPermissions(role);
                }
                if (name.equals("Publications User")) {
                    this.initPublicationsUserViewPermissions(role);
                }
                if (!name.equals("User")) break block11;
                this.initPersonalControlPanelPortletsPermissions(role);
            }
        }
    }

    protected String[] getDefaultControlPanelPortlets() {
        String myAccountPortletId = PortletProviderUtil.getPortletId((String)"com.liferay.admin.kernel.util.PortalMyAccountApplicationType$MyAccount", (PortletProvider.Action)PortletProvider.Action.VIEW);
        return new String[]{myAccountPortletId, "com_liferay_layout_admin_web_portlet_MyPagesPortlet", "com_liferay_portal_workflow_instance_web_portlet_MyWorkflowInstancePortlet", "com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet"};
    }

    protected Map<Team, Role> getTeamRoleMap(long groupId, long[] excludedRoleIds) throws PortalException {
        List teams;
        Group group = this._groupPersistence.findByPrimaryKey(groupId);
        if (group.isLayout()) {
            group = group.getParentGroup();
        }
        if ((teams = this._teamPersistence.findByGroupId(group.getGroupId())).isEmpty()) {
            return Collections.emptyMap();
        }
        Set roleIds = SetUtil.fromArray((long[])excludedRoleIds);
        LinkedHashMap<Team, Role> teamRoleMap = new LinkedHashMap<Team, Role>();
        for (Team team : teams) {
            Role role = this.getTeamRole(team.getCompanyId(), team.getTeamId());
            if (roleIds.contains(role.getRoleId())) continue;
            teamRoleMap.put(team, role);
        }
        return teamRoleMap;
    }

    protected void initAnalyticsAdministratorViewPermissions(Role role) throws PortalException {
        this._resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), Group.class.getName(), 1, String.valueOf(role.getCompanyId()), role.getRoleId(), "VIEW");
        this._resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), User.class.getName(), 1, String.valueOf(role.getCompanyId()), role.getRoleId(), "VIEW");
        this._resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), Organization.class.getName(), 1, String.valueOf(role.getCompanyId()), role.getRoleId(), "VIEW_MEMBERS");
        this._resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), UserGroup.class.getName(), 1, String.valueOf(role.getCompanyId()), role.getRoleId(), "VIEW_MEMBERS");
    }

    protected void initPersonalControlPanelPortletsPermissions(Role role) throws PortalException {
        for (String portletId : this.getDefaultControlPanelPortlets()) {
            ResourceAction resourceAction;
            int count = this._resourcePermissionPersistence.countByC_N_S_P_R(role.getCompanyId(), portletId, 1, String.valueOf(role.getCompanyId()), role.getRoleId());
            if (count > 0 || (resourceAction = this._resourceActionLocalService.fetchResourceAction(portletId, "ACCESS_IN_CONTROL_PANEL")) == null) continue;
            this.setRolePermissions(role, portletId, new String[]{"ACCESS_IN_CONTROL_PANEL"});
        }
    }

    protected void initPublicationsUserViewPermissions(Role role) throws PortalException {
        this._resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), "90", 1, String.valueOf(role.getCompanyId()), role.getRoleId(), "VIEW_CONTROL_PANEL");
    }

    protected void reindex(long userId) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)this._userLocalService.fetchUser(userId));
    }

    protected void setRolePermissions(Role role, String name, String[] actionIds) throws PortalException {
        this._resourcePermissionLocalService.setResourcePermissions(role.getCompanyId(), name, 1, String.valueOf(role.getCompanyId()), role.getRoleId(), actionIds);
    }

    protected void validate(long roleId, long companyId, long classNameId, String name) throws PortalException {
        int count;
        if (classNameId == this._classNameLocalService.getClassNameId(Role.class)) {
            this.validateName(name);
        }
        if ((count = this.rolePersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)RoleTable.INSTANCE).where(RoleTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)DSLFunctionFactoryUtil.lower((Expression)RoleTable.INSTANCE.name).eq((Object)StringUtil.lowerCase((String)name))).and((Expression)RoleTable.INSTANCE.roleId.neq((Object)roleId))))) > 0) {
            throw new DuplicateRoleException("{roleId=" + roleId + "}");
        }
        if (name.equals("PLACEHOLDER_DEFAULT_GROUP_ROLE")) {
            throw new RoleNameException("PLACEHOLDER_DEFAULT_GROUP_ROLE is a temporary placeholder that must not be persisted");
        }
    }
}

