/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.gzip.GZipResponse;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZipFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = GZipFilter.class.getName() + "#SKIP_FILTER";
    private static final String _COMPRESS = "compress";
    private static final Log _log = LogFactoryUtil.getLog(GZipFilter.class);
    private final boolean _filterEnabled;

    public GZipFilter() {
        boolean filterEnabled = false;
        if (super.isFilterEnabled() && (ServerDetector.isJBoss() || ServerDetector.isTomcat() || ServerDetector.isWebLogic() || ServerDetector.isWebSphere())) {
            filterEnabled = true;
        }
        this._filterEnabled = filterEnabled;
    }

    @Override
    public boolean isFilterEnabled() {
        return this._filterEnabled;
    }

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.isCompress(httpServletRequest) && !this.isInclude(httpServletRequest) && BrowserSnifferUtil.acceptsGzip((HttpServletRequest)httpServletRequest) && !this.isAlreadyFiltered(httpServletRequest);
    }

    protected boolean isAlreadyFiltered(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isCompress(HttpServletRequest httpServletRequest) {
        return ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)_COMPRESS, (boolean)true);
    }

    protected boolean isInclude(HttpServletRequest httpServletRequest) {
        String uri = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
        return uri != null;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (_log.isDebugEnabled()) {
            String completeURL = HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest);
            _log.debug((Object)("Compressing " + completeURL));
        }
        httpServletRequest.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        GZipResponse gZipResponse = new GZipResponse(httpServletResponse);
        this.processFilter(GZipFilter.class.getName(), httpServletRequest, (HttpServletResponse)gZipResponse, filterChain);
        gZipResponse.finishResponse();
    }
}

