/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AuthPublicPathRegistry {
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final Set<String> _paths = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ServiceTracker<Object, Object> _serviceTracker = new ServiceTracker(_bundleContext, SystemBundleUtil.createFilter((String)"(&(auth.public.path=*)(objectClass=java.lang.Object))"), (ServiceTrackerCustomizer)new AuthPublicTrackerCustomizer());

    public static boolean contains(String path) {
        return _paths.contains(path);
    }

    public static void register(String ... paths) {
        Collections.addAll(_paths, paths);
    }

    public static void unregister(String ... paths) {
        _paths.removeAll(Arrays.asList(paths));
    }

    static {
        _serviceTracker.open();
    }

    private static class AuthPublicTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private AuthPublicTrackerCustomizer() {
        }

        public Object addingService(ServiceReference<Object> serviceReference) {
            List paths = StringUtil.asList((Object)serviceReference.getProperty("auth.public.path"));
            for (String path : paths) {
                _paths.add(path);
            }
            return _bundleContext.getService(serviceReference);
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
        }

        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            List paths = StringUtil.asList((Object)serviceReference.getProperty("auth.public.path"));
            for (String path : paths) {
                _paths.remove(path);
            }
            _bundleContext.ungetService(serviceReference);
        }
    }
}

