/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XSLTBuilder {
    private static final Log _log = LogFactoryUtil.getLog(XSLTBuilder.class);

    public static void main(String[] args) throws IOException {
        if (args.length == 2) {
            String xmls = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
                xmls = bufferedReader.readLine();
            }
            new XSLTBuilder(StringUtil.split((String)xmls), args[0], args[1]);
        } else if (args.length == 3) {
            new XSLTBuilder(StringUtil.split((String)args[0]), args[1], args[2]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public XSLTBuilder(String xml, String xsl, String html) {
        this(new String[]{xml}, xsl, html);
    }

    public XSLTBuilder(String[] xmls, String xsl, String html) {
        try {
            System.setProperty("line.separator", "\n");
            String prefix = html.substring(0, html.lastIndexOf(46));
            Document document = this._combineAndSortXMLs(xmls, prefix + ".xsl");
            if (xmls.length > 1) {
                String completeXml = prefix + "-complete.xml";
                String completeContent = Dom4jUtil.toString((Node)document);
                Files.write(Paths.get(completeXml, new String[0]), completeContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(xsl));
            transformer.transform((Source)new DocumentSource(document), new StreamResult(new FileOutputStream(html)));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private Document _combineAndSortXMLs(String[] xmls, String xsl) throws Exception {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        TreeMap<String, Element> elementMap = new TreeMap<String, Element>();
        for (String xml : xmls) {
            Document document = saxReader.read(new File(xml));
            List nodes = document.selectNodes("//file-name");
            for (Node node : nodes) {
                elementMap.put(node.getText(), node.getParent());
            }
        }
        Document document = DocumentHelper.createDocument();
        File xslFile = new File(xsl);
        if (xslFile.exists()) {
            document.addProcessingInstruction("xml-stylesheet", (Map)HashMapBuilder.put((Object)"href", (Object)xslFile.getName()).put((Object)"type", (Object)"text/xsl").build());
        }
        Element versionsElement = document.addElement("versions");
        Element versionElement = versionsElement.addElement("version");
        Element librariesElement = versionElement.addElement("libraries");
        for (Element element : elementMap.values()) {
            librariesElement.add(element.detach());
        }
        return document;
    }
}

