/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.portletrepository.PortletRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);

    protected void addClassName(long classNameId, String className) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("insert into ClassName_ (mvccVersion, classNameId, value) values (?, ?, ?)");){
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, classNameId);
            preparedStatement.setString(3, className);
            preparedStatement.executeUpdate();
        }
    }

    protected void addDDMStructureLink(long ddmStructureLinkId, long classNameId, long classPK, long ddmStructureId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("insert into DDMStructureLink (structureLinkId, classNameId, classPK, structureId) values (?, ?, ?, ?)");){
            preparedStatement.setLong(1, ddmStructureLinkId);
            preparedStatement.setLong(2, classNameId);
            preparedStatement.setLong(3, classPK);
            preparedStatement.setLong(4, ddmStructureId);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to add dynamic data mapping structure link for file entry type " + classPK));
            throw exception;
        }
    }

    protected void doUpgrade() throws Exception {
        this._populateEmptyTitles("DLFileEntry");
        this.updateFileEntryFileNames();
        this.updateFileEntryTypeNamesAndDescriptions();
        this.updateFileEntryTypeDDMStructureLinks();
        this._populateEmptyTitles("DLFileVersion");
        this.updateFileVersionFileNames();
        this.alterColumnType("DLFolder", "name", "VARCHAR(255) null");
        this.updateRepositoryClassNameIds();
    }

    /*
     * Exception decompiling
     */
    protected boolean hasFileEntry(long groupId, long folderId, long fileEntryId, String title, String fileName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateFileEntryFileNames() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("alter table DLFileEntry add fileName VARCHAR(255) null");
            this.runSQL("update DLFileEntry set fileName = title where title like CONCAT('%.', extension) or extension = '' or extension is null");
            this.runSQL("update DLFileEntry set fileName = CONCAT(title, '.', extension) where (fileName is null or fileName = '') and LENGTH(title) + LENGTH(extension) < 255");
            this._updateLongFileNames("DLFileEntry");
            this.runSQL("update DLFileEntry set fileName = REPLACE(fileName, '/', '_') where fileName is not null and fileName != ''");
            this._fixDuplicateFileEntryFileNames();
        }
    }

    protected void updateFileEntryTypeDDMStructureLinks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select * from DLFileEntryTypes_DDMStructures");
             ResultSet resultSet = preparedStatement.executeQuery();){
            long classNameId = PortalUtil.getClassNameId(DLFileEntryType.class);
            while (resultSet.next()) {
                long structureId = resultSet.getLong("structureId");
                long fileEntryTypeId = resultSet.getLong("fileEntryTypeId");
                this.addDDMStructureLink(this.increment(), classNameId, fileEntryTypeId, structureId);
            }
            this.runSQL("drop table DLFileEntryTypes_DDMStructures");
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, groupId from Group_ where classNameId = ?");){
            preparedStatement.setLong(1, PortalUtil.getClassNameId(Company.class));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong(1);
                    long groupId = resultSet.getLong(2);
                    this.updateFileEntryTypeNamesAndDescriptions(companyId, groupId);
                }
            }
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long companyId, long groupId) throws Exception {
        HashMap nameLanguageKeys = HashMapBuilder.put((Object)"contract", (Object)"CONTRACT").put((Object)"marketing-banner", (Object)"MARKETING BANNER").put((Object)"online-training", (Object)"ONLINE TRAINING").put((Object)"sales-presentation", (Object)"SALES PRESENTATION").build();
        for (Map.Entry nameAndKey : nameLanguageKeys.entrySet()) {
            String dlFileEntryTypeKey = (String)nameAndKey.getValue();
            String nameLanguageKey = (String)nameAndKey.getKey();
            this.updateFileEntryTypeNamesAndDescriptions(companyId, groupId, dlFileEntryTypeKey, nameLanguageKey);
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long companyId, long groupId, String dlFileEntryTypeKey, String nameLanguageKey) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select fileEntryTypeId, name, description from DLFileEntryType where groupId = ? and fileEntryTypeKey = ?");){
            preparedStatement.setLong(1, groupId);
            preparedStatement.setString(2, dlFileEntryTypeKey);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    return;
                }
                long fileEntryTypeId = resultSet.getLong(1);
                String name = resultSet.getString(2);
                String description = resultSet.getString(3);
                if (resultSet.next()) {
                    throw new IllegalStateException(String.format("Found more than one row in table DLFileEntryType with groupId %s and fileEntryTypeKey %s", groupId, dlFileEntryTypeKey));
                }
                this.updateFileEntryTypeNamesAndDescriptions(companyId, fileEntryTypeId, nameLanguageKey, name, description);
            }
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long companyId, long dlFileEntryTypeId, String nameLanguageKey, String nameXML, String descriptionXML) throws Exception {
        String name;
        boolean update = false;
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId));
        Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
        Map descriptionMap = LocalizationUtil.getLocalizationMap((String)descriptionXML);
        String value = LanguageUtil.get((Locale)defaultLocale, (String)nameLanguageKey);
        String description = (String)descriptionMap.get(defaultLocale);
        if (description == null) {
            descriptionMap.put(defaultLocale, value);
            update = true;
        }
        if ((name = (String)nameMap.get(defaultLocale)) == null) {
            nameMap.put(defaultLocale, value);
            update = true;
        }
        if (update) {
            this.updateFileEntryTypeNamesAndDescriptions(dlFileEntryTypeId, nameXML, descriptionXML, nameMap, descriptionMap, defaultLocale);
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long fileEntryTypeId, String nameXML, String descriptionXML, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, Locale defaultLocale) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DLFileEntryType set name = ?, description = ? where fileEntryTypeId = ?");){
            String languageId = LanguageUtil.getLanguageId((Locale)defaultLocale);
            nameXML = LocalizationUtil.updateLocalization(nameMap, (String)nameXML, (String)"Name", (String)languageId);
            descriptionXML = LocalizationUtil.updateLocalization(descriptionMap, (String)descriptionXML, (String)"Description", (String)languageId);
            preparedStatement.setString(1, nameXML);
            preparedStatement.setString(2, descriptionXML);
            preparedStatement.setLong(3, fileEntryTypeId);
            int rowCount = preparedStatement.executeUpdate();
            if (rowCount != 1) {
                throw new IllegalStateException(String.format("Updated %s rows in table DLFileEntryType with fileEntryTypeId %s", rowCount, fileEntryTypeId));
            }
        }
    }

    protected void updateFileVersionFileName(long fileVersionId, String fileName) throws Exception {
    }

    protected void updateFileVersionFileNames() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("alter table DLFileVersion add fileName VARCHAR(255) null");
            this.runSQL("update DLFileVersion set fileName = title where title like CONCAT('%.', extension) or extension = '' or extension is null");
            this.runSQL(StringBundler.concat((String[])new String[]{"update DLFileVersion set fileName = CONCAT(title, ", "CONCAT('.', extension)) where (fileName is null or ", "fileName = '') and LENGTH(title) + LENGTH(extension) < ", "255"}));
            this._updateLongFileNames("DLFileVersion");
        }
    }

    protected void updateRepositoryClassNameIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long liferayRepositoryClassNameId = PortalUtil.getClassNameId(LiferayRepository.class);
            long portletRepositoryClassNameId = PortalUtil.getClassNameId(PortletRepository.class);
            if (portletRepositoryClassNameId == 0L) {
                portletRepositoryClassNameId = this.increment();
                this.addClassName(portletRepositoryClassNameId, PortletRepository.class.getName());
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update Repository set classNameId = ? where classNameId = ?");){
                preparedStatement.setLong(1, portletRepositoryClassNameId);
                preparedStatement.setLong(2, liferayRepositoryClassNameId);
                preparedStatement.executeUpdate();
            }
        }
    }

    private void _fixDuplicateFileEntryFileNames() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId, folderId, fileName from DLFileEntry group by groupId, folderId, fileName having count(*) > 1");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                long folderId = resultSet.getLong("folderId");
                String fileName = resultSet.getString("fileName");
                this._fixDuplicateFileEntryFileNames(groupId, folderId, fileName);
            }
        }
    }

    private void _fixDuplicateFileEntryFileNames(long groupId, long folderId, String fileName) throws Exception {
        HashSet<String> generatedUniqueFileNames = new HashSet<String>();
        HashSet<String> generatedUniqueTitles = new HashSet<String>();
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select fileEntryId, extension, title, version from DLFileEntry where groupId = ? and folderId = ? and fileName = ?");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update DLFileEntry set fileName = ?, title = ? where fileEntryId = ?"));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DLFileVersion set title = ? where fileEntryId = ? and version = ? and status != ?");){
            preparedStatement1.setLong(1, groupId);
            preparedStatement1.setLong(2, folderId);
            preparedStatement1.setString(3, fileName);
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                resultSet.next();
                int i = 1;
                while (resultSet.next()) {
                    long fileEntryId = resultSet.getLong("fileEntryId");
                    String extension = GetterUtil.getString((String)resultSet.getString("extension"));
                    String title = GetterUtil.getString((String)resultSet.getString("title"));
                    String version = resultSet.getString("version");
                    String uniqueFileName = null;
                    String titleExtension = "";
                    String titleWithoutExtension = title;
                    if (title.endsWith("." + extension)) {
                        titleExtension = "." + extension;
                        titleWithoutExtension = titleWithoutExtension.substring(0, title.length() - titleExtension.length());
                    }
                    do {
                        String count = String.valueOf(i);
                        int availableLength = 254 - (extension.length() + count.length());
                        if (Validator.isNotNull((String)extension)) {
                            --availableLength;
                        }
                        if (titleWithoutExtension.length() > availableLength) {
                            titleWithoutExtension = titleWithoutExtension.substring(0, availableLength);
                        }
                        StringBundler sb = new StringBundler(4);
                        sb.append(titleWithoutExtension);
                        sb.append("_");
                        sb.append(count);
                        if (Validator.isNotNull((String)titleExtension)) {
                            sb.append(titleExtension);
                        }
                        title = sb.toString();
                        uniqueFileName = DLUtil.getSanitizedFileName((String)title, (String)extension);
                        ++i;
                    } while (generatedUniqueFileNames.contains(uniqueFileName) || generatedUniqueTitles.contains(title) || this.hasFileEntry(groupId, folderId, fileEntryId, title, uniqueFileName));
                    generatedUniqueFileNames.add(uniqueFileName);
                    generatedUniqueTitles.add(title);
                    preparedStatement2.setString(1, uniqueFileName);
                    preparedStatement2.setString(2, title);
                    preparedStatement2.setLong(3, fileEntryId);
                    preparedStatement2.addBatch();
                    preparedStatement3.setString(1, title);
                    preparedStatement3.setLong(2, fileEntryId);
                    preparedStatement3.setString(3, version);
                    preparedStatement3.setInt(4, 8);
                    preparedStatement3.addBatch();
                }
                preparedStatement2.executeBatch();
                preparedStatement3.executeBatch();
            }
        }
    }

    private void _populateEmptyTitles(String tableName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL(StringBundler.concat((String[])new String[]{"update ", tableName, " set title = ", "CONCAT('unknown-title-', CAST_TEXT(fileEntryId)) where ", "title = '' or title is null"}));
        }
    }

    private void _updateLongFileNames(String tableName) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select fileEntryId, title, extension from " + tableName + " where fileName = '' or fileName is null");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update " + tableName + " set fileName = ? where fileEntryId = ?"));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long fileEntryId = resultSet.getLong("fileEntryId");
                String extension = GetterUtil.getString((String)resultSet.getString("extension"));
                String title = GetterUtil.getString((String)resultSet.getString("title"));
                String fileName = DLUtil.getSanitizedFileName((String)title, (String)extension);
                preparedStatement2.setString(1, fileName);
                preparedStatement2.setLong(2, fileEntryId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

