/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.util.PropsValues;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class UpgradeGroup
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.dropIndexes("Group_", "name");
        this.alterColumnType("Group_", "name", "STRING null");
        try (SafeCloseable safeCloseable = this.addTempIndex("Group_", false, new String[]{"classNameId", "classPK"});){
            this.updateGlobalGroupName();
            this.updateGroupsNames();
        }
    }

    protected void updateGlobalGroupName() throws Exception {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId from Company");){
            String[] stringArray = null;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    companyIds.add(companyId);
                }
            }
            catch (Throwable companyId) {
                stringArray = companyId;
                throw companyId;
            }
        }
        for (Long companyId : companyIds) {
            LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
            for (String languageId : PropsValues.LOCALES_ENABLED) {
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                localizedValuesMap.put(locale, LanguageUtil.get((ResourceBundle)LanguageResources.getResourceBundle(locale), (String)"global"));
            }
            String nameXML = LocalizationUtil.getXml((LocalizedValuesMap)localizedValuesMap, (String)"global");
            PreparedStatement preparedStatement = this.connection.prepareStatement("update Group_ set name = ? where companyId = ? and friendlyURL = '/global'");
            Throwable throwable = null;
            try {
                preparedStatement.setString(1, nameXML);
                preparedStatement.setLong(2, companyId);
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (preparedStatement == null) continue;
                if (throwable != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGroupsNames() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform("select groupId, name, typeSettings from Group_ where site = [$TRUE$] and friendlyURL != '/global'"));
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update Group_ set name = ? where groupId = ?"));){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                String name = resultSet.getString("name");
                String typeSettings = resultSet.getString("typeSettings");
                UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(typeSettings).build();
                String defaultLanguageId = typeSettingsUnicodeProperties.getProperty("languageId");
                Locale currentDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
                try {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)LocaleUtil.fromLanguageId((String)defaultLanguageId));
                    LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
                    for (String languageId : StringUtil.split((String)typeSettingsUnicodeProperties.getProperty("locales"))) {
                        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                        localizedValuesMap.put(locale, name);
                    }
                    String nameXML = LocalizationUtil.updateLocalization((Map)localizedValuesMap.getValues(), (String)"", (String)"name", (String)defaultLanguageId);
                    preparedStatement2.setString(1, nameXML);
                    preparedStatement2.setLong(2, groupId);
                    preparedStatement2.addBatch();
                }
                finally {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)currentDefaultLocale);
                }
            }
            preparedStatement2.executeBatch();
        }
    }
}

