/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.internal.FilterConfigImpl;
import java.io.Closeable;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class InvokerFilterContainerImpl
implements Closeable,
InvokerFilterContainer {
    public static final InvokerFilterContainer EMPTY_INVOKER_FILTER_CONTAINER = new EmptyInvokerFilterContainer();
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilterContainerImpl.class);
    private final List<ActionFilter> _actionFilters = new CopyOnWriteArrayList<ActionFilter>();
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final List<EventFilter> _eventFilters = new CopyOnWriteArrayList<EventFilter>();
    private final List<HeaderFilter> _headerFilters = new CopyOnWriteArrayList<HeaderFilter>();
    private final List<RenderFilter> _renderFilters = new CopyOnWriteArrayList<RenderFilter>();
    private final List<ResourceFilter> _resourceFilters = new CopyOnWriteArrayList<ResourceFilter>();
    private final List<ServiceRegistrationTuple> _serviceRegistrationTuples = new CopyOnWriteArrayList<ServiceRegistrationTuple>();
    private final ServiceTracker<javax.portlet.filter.PortletFilter, javax.portlet.filter.PortletFilter> _serviceTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokerFilterContainerImpl(Portlet portlet, PortletContext portletContext) throws PortletException {
        String rootPortletId = portlet.getRootPortletId();
        Filter filter = SystemBundleUtil.createFilter((String)StringBundler.concat((String[])new String[]{"(&(javax.portlet.name=", rootPortletId, ")(objectClass=", javax.portlet.filter.PortletFilter.class.getName(), "))"}));
        this._serviceTracker = new ServiceTracker(this._bundleContext, filter, (ServiceTrackerCustomizer)new PortletFilterServiceTrackerCustomizer(portletContext));
        this._serviceTracker.open();
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"javax.portlet.name", (Object)rootPortletId).put((Object)"preinitialized.filter", (Object)Boolean.TRUE).build();
        Map portletFilters = portlet.getPortletFilters();
        for (Map.Entry entry : portletFilters.entrySet()) {
            PortletFilter portletFilterModel = (PortletFilter)entry.getValue();
            javax.portlet.filter.PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(javax.portlet.filter.PortletFilter.class, (Object)portletFilter, (Dictionary)HashMapDictionaryBuilder.putAll((Dictionary)properties).put((Object)"filter.lifecycles", (Object)portletFilterModel.getLifecycles()).build());
            ServiceRegistrationTuple serviceRegistrationTuple = new ServiceRegistrationTuple(portletFilterModel, (ServiceRegistration<javax.portlet.filter.PortletFilter>)serviceRegistration);
            this._serviceRegistrationTuples.add(serviceRegistrationTuple);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            for (String portletFilterClassName : PropsValues.PORTLET_FILTERS_SYSTEM) {
                PortletFilterImpl portletFilterModel = new PortletFilterImpl(portletFilterClassName, portletFilterClassName, Collections.emptySet(), Collections.emptyMap(), portlet.getPortletApp());
                javax.portlet.filter.PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(javax.portlet.filter.PortletFilter.class, (Object)portletFilter, (Dictionary)properties);
                this._serviceRegistrationTuples.add(new ServiceRegistrationTuple(portletFilterModel, (ServiceRegistration<javax.portlet.filter.PortletFilter>)serviceRegistration));
            }
        }
        finally {
            currentThread.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void close() {
        for (ServiceRegistrationTuple serviceRegistrationTuple : this._serviceRegistrationTuples) {
            PortletFilterFactory.destroy(serviceRegistrationTuple.getPortletFilterModel());
            ServiceRegistration<javax.portlet.filter.PortletFilter> serviceRegistration = serviceRegistrationTuple.getServiceRegistration();
            serviceRegistration.unregister();
        }
        this._serviceRegistrationTuples.clear();
        this._serviceTracker.close();
        this._actionFilters.clear();
        this._eventFilters.clear();
        this._headerFilters.clear();
        this._renderFilters.clear();
        this._resourceFilters.clear();
    }

    public List<ActionFilter> getActionFilters() {
        return this._actionFilters;
    }

    public List<EventFilter> getEventFilters() {
        return this._eventFilters;
    }

    public List<HeaderFilter> getHeaderFilters() {
        return this._headerFilters;
    }

    public List<RenderFilter> getRenderFilters() {
        return this._renderFilters;
    }

    public List<ResourceFilter> getResourceFilters() {
        return this._resourceFilters;
    }

    private class PortletFilterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<javax.portlet.filter.PortletFilter, javax.portlet.filter.PortletFilter> {
        private final PortletContext _portletContext;

        public PortletFilterServiceTrackerCustomizer(PortletContext portletContext) {
            this._portletContext = portletContext;
        }

        public javax.portlet.filter.PortletFilter addingService(ServiceReference<javax.portlet.filter.PortletFilter> serviceReference) {
            javax.portlet.filter.PortletFilter portletFilter = (javax.portlet.filter.PortletFilter)InvokerFilterContainerImpl.this._bundleContext.getService(serviceReference);
            boolean preinitializedFilter = GetterUtil.getBoolean((Object)serviceReference.getProperty("preinitialized.filter"));
            if (!preinitializedFilter) {
                String filterName = GetterUtil.getString((Object)serviceReference.getProperty("service.id"), (String)ClassUtil.getClassName((Object)portletFilter));
                HashMap<String, String> params = new HashMap<String, String>();
                for (String key : serviceReference.getPropertyKeys()) {
                    if (!key.startsWith("javax.portlet.init-param.")) continue;
                    params.put(key.substring("javax.portlet.init-param.".length()), GetterUtil.getString((Object)serviceReference.getProperty(key)));
                }
                FilterConfigImpl filterConfig = new FilterConfigImpl(filterName, this._portletContext, params);
                try {
                    portletFilter.init((FilterConfig)filterConfig);
                }
                catch (PortletException portletException) {
                    _log.error((Throwable)portletException);
                    InvokerFilterContainerImpl.this._bundleContext.ungetService(serviceReference);
                    return null;
                }
            }
            Set lifecycles = (Set)serviceReference.getProperty("filter.lifecycles");
            if (portletFilter instanceof ActionFilter && this._isDeclaredLifecycle("ACTION_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._actionFilters.add((ActionFilter)portletFilter);
            }
            if (portletFilter instanceof EventFilter && this._isDeclaredLifecycle("EVENT_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._eventFilters.add((EventFilter)portletFilter);
            }
            if (portletFilter instanceof HeaderFilter && this._isDeclaredLifecycle("HEADER_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._headerFilters.add((HeaderFilter)portletFilter);
            }
            if (portletFilter instanceof RenderFilter && this._isDeclaredLifecycle("RENDER_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._renderFilters.add((RenderFilter)portletFilter);
            }
            if (portletFilter instanceof ResourceFilter && this._isDeclaredLifecycle("RESOURCE_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._resourceFilters.add((ResourceFilter)portletFilter);
            }
            return portletFilter;
        }

        public void modifiedService(ServiceReference<javax.portlet.filter.PortletFilter> serviceReference, javax.portlet.filter.PortletFilter portletFilter) {
        }

        public void removedService(ServiceReference<javax.portlet.filter.PortletFilter> serviceReference, javax.portlet.filter.PortletFilter portletFilter) {
            InvokerFilterContainerImpl.this._bundleContext.ungetService(serviceReference);
            InvokerFilterContainerImpl.this._actionFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._eventFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._headerFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._renderFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._resourceFilters.remove(portletFilter);
            boolean preinitializedFilter = GetterUtil.getBoolean((Object)serviceReference.getProperty("preinitialized.filter"));
            if (preinitializedFilter) {
                return;
            }
            portletFilter.destroy();
        }

        private boolean _isDeclaredLifecycle(String lifecycle, Set<String> lifecycles) {
            if (lifecycles == null || lifecycles.isEmpty()) {
                return true;
            }
            return lifecycles.contains(lifecycle);
        }
    }

    private static class ServiceRegistrationTuple {
        private final PortletFilter _portletFilterModel;
        private final ServiceRegistration<javax.portlet.filter.PortletFilter> _serviceRegistration;

        public ServiceRegistrationTuple(PortletFilter portletFilterModel, ServiceRegistration<javax.portlet.filter.PortletFilter> serviceRegistration) {
            this._portletFilterModel = portletFilterModel;
            this._serviceRegistration = serviceRegistration;
        }

        public PortletFilter getPortletFilterModel() {
            return this._portletFilterModel;
        }

        public ServiceRegistration<javax.portlet.filter.PortletFilter> getServiceRegistration() {
            return this._serviceRegistration;
        }
    }

    private static class EmptyInvokerFilterContainer
    implements Closeable,
    InvokerFilterContainer {
        private EmptyInvokerFilterContainer() {
        }

        @Override
        public void close() {
        }

        public List<ActionFilter> getActionFilters() {
            return Collections.emptyList();
        }

        public List<EventFilter> getEventFilters() {
            return Collections.emptyList();
        }

        public List<HeaderFilter> getHeaderFilters() {
            return Collections.emptyList();
        }

        public List<RenderFilter> getRenderFilters() {
            return Collections.emptyList();
        }

        public List<ResourceFilter> getResourceFilters() {
            return Collections.emptyList();
        }
    }
}

