/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert.documentlibrary;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import java.io.IOException;
import java.io.InputStream;

public interface DLStoreConvertProcess {
    public void copy(Store var1, Store var2) throws PortalException;

    public void move(Store var1, Store var2) throws PortalException;

    default public void transferFile(Store sourceStore, Store targetStore, long companyId, long repositoryId, String fileName, String versionLabel, boolean delete) {
        try (InputStream inputStream = sourceStore.getFileAsStream(companyId, repositoryId, fileName, versionLabel);){
            targetStore.addFile(companyId, repositoryId, fileName, versionLabel, inputStream);
            if (delete) {
                sourceStore.deleteFile(companyId, repositoryId, fileName, versionLabel);
            }
        }
        catch (PortalException | IOException exception) {
            throw new SystemException(exception);
        }
    }
}

