/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.util;

import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class RetryDataSourceWrapper
extends DataSourceWrapper {
    public RetryDataSourceWrapper(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        int retries = PropsValues.RETRY_DATA_SOURCE_MAX_RETRIES;
        SQLException sqlException1 = null;
        while (retries-- >= 0) {
            try {
                return super.getConnection();
            }
            catch (SQLException sqlException2) {
                if (sqlException1 != null) continue;
                sqlException1 = sqlException2;
            }
        }
        throw sqlException1;
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        int retries = PropsValues.RETRY_DATA_SOURCE_MAX_RETRIES;
        SQLException sqlException1 = null;
        while (retries-- >= 0) {
            try {
                return super.getConnection(userName, password);
            }
            catch (SQLException sqlException2) {
                if (sqlException1 != null) continue;
                sqlException1 = sqlException2;
            }
        }
        throw sqlException1;
    }
}

