/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.CustomUserAttributes;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletURLListenerFactory;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PortletHotDeployListener
extends BaseHotDeployListener {
    private static final String _JNDI_JDBC = "java_liferay:jdbc";
    private static final String _JNDI_JDBC_LIFERAY_POOL = "java_liferay:jdbc/LiferayPool";
    private static final Log _log = LogFactoryUtil.getLog(PortletHotDeployListener.class);
    private static final Map<String, Boolean> _dataSourceBindStates = new HashMap<String, Boolean>();
    private static final Map<String, List<Portlet>> _portlets = new HashMap<String, List<Portlet>>();
    private final Map<String, ServiceRegistration<ResourceBundleLoader>> _resourceBundleLoaderServiceRegistrations = new HashMap<String, ServiceRegistration<ResourceBundleLoader>>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error registering portlets for ", throwable);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering portlets for ", throwable);
        }
    }

    protected void checkResourceBundles(ClassLoader classLoader, Portlet portlet) {
        if (Validator.isNull((String)portlet.getResourceBundle())) {
            return;
        }
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        ClassResourceBundleLoader resourceBundleLoader = new ClassResourceBundleLoader(portlet.getResourceBundle(), classLoader);
        this._resourceBundleLoaderServiceRegistrations.put(portlet.getPortletId(), (ServiceRegistration<ResourceBundleLoader>)bundleContext.registerService(ResourceBundleLoader.class, (Object)resourceBundleLoader, (Dictionary)HashMapDictionaryBuilder.put((Object)"resource.bundle.base.name", (Object)portlet.getResourceBundle()).put((Object)"service.ranking", (Object)Integer.MIN_VALUE).put((Object)"servlet.context.name", (Object)portlet.getContextName()).build()));
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        List beanFilterNames = (List)servletContext.getAttribute("BEAN_FILTER_NAMES");
        List beanPortletIds = (List)servletContext.getAttribute("BEAN_PORTLET_IDS");
        if (beanFilterNames != null || beanPortletIds != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Detected bean portlet from servlet context attributes");
            }
            return;
        }
        try (InputStream inputStream = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest;
            Attributes mainAttributes;
            String value;
            if (inputStream != null && (value = (mainAttributes = (manifest = new Manifest(inputStream)).getMainAttributes()).getValue("Require-Capability")) != null && value.contains("osgi.cdi.extension")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Detected bean portlet from /META-INF/MANIFEST.MF");
                }
                return;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/portlet.xml")), StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/portlet-custom.xml")), StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-portlet.xml")), StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/web.xml"))})[0] == null && xmls[1] == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering portlets for " + servletContextName));
        }
        PortletContextBag portletContextBag = new PortletContextBag(servletContextName);
        PortletContextBagPool.put(servletContextName, portletContextBag);
        List portlets = PortletLocalServiceUtil.initWAR((String)servletContextName, (ServletContext)servletContext, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        boolean portletAppInitialized = false;
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        for (Portlet portlet : portlets) {
            if (portletAppInitialized) continue;
            this.initPortletApp(servletContextName, servletContext, classLoader, portlet);
            portletAppInitialized = true;
        }
        String xml = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-display.xml"));
        PortletCategory newPortletCategory = PortletLocalServiceUtil.getWARDisplay((String)servletContextName, (String)xml);
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
            if (portletCategory != null) {
                portletCategory.merge(newPortletCategory);
            } else {
                _log.error((Object)("Unable to register portlet for company " + companyId + " because it does not exist"));
            }
        });
        String[] sources = this._processPortletProperties(classLoader);
        ResourceActionsUtil.populateModelResources((ClassLoader)classLoader, (String[])sources);
        for (Portlet portlet : portlets) {
            ResourceActionsUtil.populatePortletResource((Portlet)portlet, (ClassLoader)classLoader, (String[])sources);
            this.checkResourceBundles(classLoader, portlet);
            CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
                Portlet curPortlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portlet.getPortletId());
                PortletLocalServiceUtil.checkPortlet((Portlet)curPortlet);
            });
        }
        for (Portlet portlet : portlets) {
            portlet.setReady(GetterUtil.getBoolean((String)servletContext.getInitParameter("portlets-ready-by-default"), (boolean)true));
        }
        DirectServletRegistryUtil.clearServlets();
        FileTimestampUtil.reset((ServletContext)servletContext);
        _portlets.put(servletContextName, portlets);
        servletContext.setAttribute("PLUGIN_PORTLETS", (Object)portlets);
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{portlets.size(), " portlets for ", servletContextName, " are available for use"}));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<Portlet> portlets;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((portlets = _portlets.remove(servletContextName)) == null) {
            return;
        }
        HashSet<String> portletIds = new HashSet<String>();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unregistering portlets for " + servletContextName));
        }
        for (Portlet portlet : portlets) {
            this._destroyPortlet(portlet, portletIds);
        }
        ServletContextPool.remove((String)servletContextName);
        if (!portletIds.isEmpty()) {
            CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                portletCategory.separate(portletIds);
            });
        }
        PortletContextBagPool.remove(servletContextName);
        DirectServletRegistryUtil.clearServlets();
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{portlets.size(), " portlets for ", servletContextName, " were unregistered"}));
            }
        }
    }

    protected void initPortletApp(String servletContextName, ServletContext servletContext, ClassLoader classLoader, Portlet portlet) throws Exception {
        PortletContextBag portletContextBag = PortletContextBagPool.get(servletContextName);
        PortletApp portletApp = portlet.getPortletApp();
        servletContext.setAttribute("com.liferay.portal.kernel.model.PortletApp", (Object)portletApp);
        Map customUserAttributes1 = portletApp.getCustomUserAttributes();
        for (Map.Entry entry : customUserAttributes1.entrySet()) {
            String attrCustomClass = (String)entry.getValue();
            Class<?> clazz = classLoader.loadClass(attrCustomClass);
            CustomUserAttributes customUserAttributes2 = (CustomUserAttributes)clazz.newInstance();
            Map<String, CustomUserAttributes> customUserAttributesMap = portletContextBag.getCustomUserAttributes();
            customUserAttributesMap.put(attrCustomClass, customUserAttributes2);
        }
        Set portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            javax.portlet.filter.PortletFilter portletFilterInstance = (javax.portlet.filter.PortletFilter)this.newInstance(classLoader, new Class[]{ActionFilter.class, EventFilter.class, javax.portlet.filter.PortletFilter.class, RenderFilter.class, ResourceFilter.class}, portletFilter.getFilterClass());
            Map<String, javax.portlet.filter.PortletFilter> portletFiltersMap = portletContextBag.getPortletFilters();
            portletFiltersMap.put(portletFilter.getFilterName(), portletFilterInstance);
        }
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        invokerPortlet.setPortletFilters();
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLGenerationListener portletURLListenerInstance = (PortletURLGenerationListener)this.newInstance(classLoader, PortletURLGenerationListener.class, portletURLListener.getListenerClass());
            Map<String, PortletURLGenerationListener> portletURLListenersMap = portletContextBag.getPortletURLListeners();
            portletURLListenersMap.put(portletURLListener.getListenerClass(), portletURLListenerInstance);
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected void unbindDataSource(String servletContextName) {
        block10: {
            Boolean dataSourceBindState = _dataSourceBindStates.remove(servletContextName);
            if (dataSourceBindState == null) {
                return;
            }
            try {
                InitialContext context;
                block9: {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Dynamically unbinding the Liferay data source");
                    }
                    context = new InitialContext();
                    try {
                        context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                        context.unbind(_JNDI_JDBC_LIFERAY_POOL);
                    }
                    catch (NamingException namingException) {
                        if (!_log.isDebugEnabled()) break block9;
                        _log.debug((Throwable)namingException);
                    }
                }
                try {
                    context.lookup(_JNDI_JDBC);
                    context.destroySubcontext(_JNDI_JDBC);
                }
                catch (NamingException namingException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)namingException);
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Object)("Unable to dynamically unbind the Liferay data source: " + exception.getMessage()));
            }
        }
    }

    private void _destroyPortlet(Portlet portlet, Set<String> portletIds) throws Exception {
        portlet.unsetReady();
        PortletApp portletApp = portlet.getPortletApp();
        Set portletFilters = portletApp.getPortletFilters();
        for (Object portletFilter : portletFilters) {
            PortletFilterFactory.destroy((PortletFilter)portletFilter);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.destroy(portletURLListener);
        }
        PortletInstanceFactoryUtil.destroy((Portlet)portlet);
        portletIds.add(portlet.getPortletId());
        ServiceRegistration<ResourceBundleLoader> resourceBundleLoaderServiceRegistration = this._resourceBundleLoaderServiceRegistrations.remove(portlet.getPortletId());
        if (resourceBundleLoaderServiceRegistration != null) {
            resourceBundleLoaderServiceRegistration.unregister();
        }
    }

    private String[] _processPortletProperties(ClassLoader classLoader) throws Exception {
        Configuration portletPropertiesConfiguration = null;
        try {
            portletPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read portlet.properties", (Throwable)exception);
            }
            return new String[0];
        }
        Properties portletProperties = portletPropertiesConfiguration.getProperties();
        return StringUtil.split((String)portletProperties.getProperty("resource.actions.configs"));
    }
}

