/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.security.permission.contributor;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RoleCollectionImpl
implements RoleCollection {
    private Set<Long> _addedRoleIds;
    private final long _groupId;
    private final PermissionChecker _permissionChecker;
    private Set<Long> _removedRoleIds;
    private final long[] _roleIds;
    private final User _user;
    private final UserBag _userBag;

    public RoleCollectionImpl(User user, UserBag userBag, long[] roleIds, long groupId, PermissionChecker permissionChecker) {
        this._user = user;
        this._userBag = userBag;
        this._roleIds = roleIds;
        this._groupId = groupId;
        this._permissionChecker = permissionChecker;
    }

    public boolean addRoleId(long roleId) {
        if (this.hasRoleId(roleId)) {
            return false;
        }
        if (this._addedRoleIds == null) {
            this._addedRoleIds = new HashSet<Long>();
        }
        if (this._removedRoleIds != null) {
            this._removedRoleIds.remove(roleId);
        }
        this._addedRoleIds.add(roleId);
        return true;
    }

    public long getCompanyId() {
        return this._permissionChecker.getCompanyId();
    }

    public long getGroupId() {
        return this._groupId;
    }

    public long[] getInitialRoleIds() {
        return (long[])this._roleIds.clone();
    }

    public long[] getRoleIds() {
        if (this._addedRoleIds == null && this._removedRoleIds == null) {
            return this._roleIds;
        }
        Set rolesIds = SetUtil.fromArray((long[])this._roleIds);
        if (this._addedRoleIds != null) {
            rolesIds.addAll(this._addedRoleIds);
        }
        if (this._removedRoleIds != null) {
            rolesIds.removeAll(this._removedRoleIds);
        }
        long[] roleIdsArray = ArrayUtil.toLongArray((Collection)rolesIds);
        Arrays.sort(roleIdsArray);
        return roleIdsArray;
    }

    public User getUser() {
        return this._user;
    }

    public UserBag getUserBag() {
        return this._userBag;
    }

    public boolean hasRoleId(long roleId) {
        if (this._addedRoleIds != null && this._addedRoleIds.contains(roleId)) {
            return true;
        }
        if (this._removedRoleIds != null && this._removedRoleIds.contains(roleId)) {
            return false;
        }
        return Arrays.binarySearch(this._roleIds, roleId) >= 0;
    }

    public boolean isSignedIn() {
        return this._permissionChecker.isSignedIn();
    }

    public boolean removeRoleId(long roleId) {
        if (!this.hasRoleId(roleId)) {
            return false;
        }
        if (this._addedRoleIds != null) {
            this._addedRoleIds.remove(roleId);
        }
        if (this._removedRoleIds == null) {
            this._removedRoleIds = new HashSet<Long>();
        }
        this._removedRoleIds.add(roleId);
        return true;
    }
}

