/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.patcher;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.patcher.Patcher;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;

public class PatcherImpl
implements Patcher {
    private static final Log _log = LogFactoryUtil.getLog(PatcherImpl.class);
    private boolean _configured;
    private final String[] _fixedIssueKeys;
    private final String[] _installedPatchNames;
    private final int _patchingToolVersion;
    private final String _patchingToolVersionDisplayName;
    private final String[] _patchLevels;
    private final Properties _properties = this._getProperties("patcher.properties");
    private final boolean _separated;
    private final String _separationId;

    public PatcherImpl() {
        this._fixedIssueKeys = StringUtil.split((String)this._properties.getProperty("fixed.issues"));
        this._installedPatchNames = StringUtil.split((String)this._properties.getProperty("installed.patches"));
        this._patchLevels = StringUtil.split((String)this._properties.getProperty("patch.levels"));
        this._patchingToolVersion = GetterUtil.getInteger((Object)this._properties.get("patching.tool.version"));
        this._patchingToolVersionDisplayName = this.getPatchingToolVersionDisplayName();
        this._separated = GetterUtil.getBoolean((String)this._properties.getProperty("separated"));
        this._separationId = this._properties.getProperty("separation.id");
    }

    public boolean applyPatch(File patchFile) {
        File patchDirectory = this.getPatchDirectory();
        if (patchDirectory == null) {
            return false;
        }
        try {
            FileUtil.copyFile((File)patchFile, (File)new File(patchDirectory + "/" + patchFile.getName()));
            return true;
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to copy ", patchFile.getAbsolutePath(), " to ", patchDirectory.getAbsolutePath()}), (Throwable)exception);
            return false;
        }
    }

    public String[] getFixedIssues() {
        return this._fixedIssueKeys;
    }

    public String[] getInstalledPatches() {
        return this._installedPatchNames;
    }

    public File getPatchDirectory() {
        String patchDirectoryName = this._properties.getProperty("patch.directory");
        File patchDirectory = null;
        if (Validator.isNotNull((String)patchDirectoryName)) {
            patchDirectory = new File(patchDirectoryName);
            if (!patchDirectory.exists()) {
                _log.error((Object)"The patch directory does not exist");
                this._configured = false;
            } else {
                this._configured = true;
            }
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"The patch directory is not specified");
            }
            this._configured = false;
        }
        return patchDirectory;
    }

    public int getPatchingToolVersion() {
        return this._patchingToolVersion;
    }

    public String getPatchingToolVersionDisplayName() {
        if (this._patchingToolVersionDisplayName != null) {
            return this._patchingToolVersionDisplayName;
        }
        String patchingToolVersionDisplayName = "1.0." + this.getPatchingToolVersion();
        if (this._properties.containsKey("patching.tool.version.display.name")) {
            patchingToolVersionDisplayName = this._properties.getProperty("patching.tool.version.display.name");
        }
        return patchingToolVersionDisplayName;
    }

    public String[] getPatchLevels() {
        return this._patchLevels;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public String getSeparationId() {
        return this._separationId;
    }

    public boolean isConfigured() {
        this.getPatchDirectory();
        return this._configured;
    }

    public boolean isSeparated() {
        return this._separated;
    }

    private Properties _getProperties(String fileName) {
        Properties properties;
        block19: {
            if (Validator.isNull((String)fileName)) {
                fileName = "patcher.properties";
            }
            properties = new Properties();
            Class<?> clazz = this.getClass();
            if (Objects.equals(fileName, "patcher-service.properties")) {
                clazz = clazz.getInterfaces()[0];
            }
            ClassLoader classLoader = clazz.getClassLoader();
            try (InputStream inputStream = classLoader.getResourceAsStream(fileName);){
                if (inputStream == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Unable to load " + fileName));
                    }
                } else {
                    properties.load(inputStream);
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block19;
                _log.warn((Throwable)ioException);
            }
        }
        return properties;
    }
}

