/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class AuthTokenWhitelistImpl
extends BaseAuthTokenWhitelist {
    private volatile Set<String> _originCSRFWhitelist;
    private volatile Set<String> _portletCSRFWhitelist;
    private volatile Set<String> _portletInvocationWhitelist;

    public boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        for (String whitelistedOrigin : this._getOriginCSRFWhitelist()) {
            if (!origin.startsWith(whitelistedOrigin)) continue;
            return true;
        }
        return false;
    }

    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        Set<String> portletCSRFWhitelist = this._getPortletCSRFWhitelist();
        return portletCSRFWhitelist.contains(portlet.getRootPortletId());
    }

    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        Set<String> portletInvocationWhitelist = this._getPortletInvocationWhitelist();
        return portletInvocationWhitelist.contains(portlet.getPortletId());
    }

    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String rootPortletId = PortletIdCodec.decodePortletName((String)liferayPortletURL.getPortletId());
        Set<String> portletCSRFWhitelist = this._getPortletCSRFWhitelist();
        return portletCSRFWhitelist.contains(rootPortletId);
    }

    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        Set<String> portletInvocationWhitelist = this._getPortletInvocationWhitelist();
        return portletInvocationWhitelist.contains(liferayPortletURL.getPortletId());
    }

    public boolean isValidSharedSecret(String sharedSecret) {
        if (Validator.isNull((String)sharedSecret) || Validator.isNull((String)PropsValues.AUTH_TOKEN_SHARED_SECRET)) {
            return false;
        }
        return sharedSecret.equals(DigesterUtil.digest((String)PropsValues.AUTH_TOKEN_SHARED_SECRET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getOriginCSRFWhitelist() {
        Set<String> originCSRFWhitelist = this._originCSRFWhitelist;
        if (originCSRFWhitelist != null) {
            return originCSRFWhitelist;
        }
        AuthTokenWhitelistImpl authTokenWhitelistImpl = this;
        synchronized (authTokenWhitelistImpl) {
            if (this._originCSRFWhitelist == null) {
                originCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
                this.registerPortalProperty("auth.token.ignore.origins");
                this.trackWhitelistServices("auth.token.ignore.origins", originCSRFWhitelist);
                this._originCSRFWhitelist = originCSRFWhitelist;
            } else {
                originCSRFWhitelist = this._originCSRFWhitelist;
            }
        }
        return originCSRFWhitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getPortletCSRFWhitelist() {
        Set<String> portletCSRFWhitelist = this._portletCSRFWhitelist;
        if (portletCSRFWhitelist != null) {
            return portletCSRFWhitelist;
        }
        AuthTokenWhitelistImpl authTokenWhitelistImpl = this;
        synchronized (authTokenWhitelistImpl) {
            if (this._portletCSRFWhitelist == null) {
                portletCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
                this.registerPortalProperty("auth.token.ignore.portlets");
                this.trackWhitelistServices("auth.token.ignore.portlets", portletCSRFWhitelist);
                this._portletCSRFWhitelist = portletCSRFWhitelist;
            } else {
                portletCSRFWhitelist = this._portletCSRFWhitelist;
            }
        }
        return portletCSRFWhitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getPortletInvocationWhitelist() {
        Set<String> portletInvocationWhitelist = this._portletInvocationWhitelist;
        if (portletInvocationWhitelist != null) {
            return portletInvocationWhitelist;
        }
        AuthTokenWhitelistImpl authTokenWhitelistImpl = this;
        synchronized (authTokenWhitelistImpl) {
            if (this._portletInvocationWhitelist == null) {
                portletInvocationWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
                this.registerPortalProperty("portlet.add.default.resource.check.whitelist");
                this.trackWhitelistServices("portlet.add.default.resource.check.whitelist", portletInvocationWhitelist);
                this._portletInvocationWhitelist = portletInvocationWhitelist;
            } else {
                portletInvocationWhitelist = this._portletInvocationWhitelist;
            }
        }
        return portletInvocationWhitelist;
    }
}

