/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PwdAuthenticator {
    private static final String _PRETENDED_CLEAR_TEXT_PASSWORD = "password";
    private static final String _PRETENDED_CURRENT_ENCRYPTED_PASSWORD;
    private static final String _PRETENDED_LOGIN = "login";
    private static final Log _log;

    public static boolean authenticate(String login, String clearTextPassword, String currentEncryptedPassword) throws PwdEncryptorException {
        String encryptedPassword = PasswordEncryptorUtil.encrypt((String)clearTextPassword, (String)currentEncryptedPassword);
        if (currentEncryptedPassword.equals(encryptedPassword)) {
            return true;
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("auth.mac.allow"))) {
            try {
                MessageDigest digester = MessageDigest.getInstance(PropsUtil.get("auth.mac.algorithm"));
                digester.update(login.getBytes("UTF-8"));
                String shardKey = PropsUtil.get("auth.mac.shared.key");
                if (Validator.isNull((String)shardKey)) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Please set the property auth.mac.shared.key");
                    }
                    return false;
                }
                encryptedPassword = Base64.encode((byte[])digester.digest(shardKey.getBytes("UTF-8")));
                return clearTextPassword.equals(encryptedPassword);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SystemException((Throwable)noSuchAlgorithmException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SystemException((Throwable)unsupportedEncodingException);
            }
        }
        return false;
    }

    public static void pretendToAuthenticate() throws PwdEncryptorException {
        PwdAuthenticator.authenticate(_PRETENDED_LOGIN, _PRETENDED_CLEAR_TEXT_PASSWORD, _PRETENDED_CURRENT_ENCRYPTED_PASSWORD);
    }

    static {
        _log = LogFactoryUtil.getLog((String)PwdAuthenticator.class.getName());
        try {
            _PRETENDED_CURRENT_ENCRYPTED_PASSWORD = PasswordEncryptorUtil.encrypt((String)"currentPassword");
        }
        catch (PwdEncryptorException pwdEncryptorException) {
            throw new RuntimeException(pwdEncryptorException);
        }
    }
}

