/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.security.pwd.Toolkit;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;

public class PwdToolkitUtil {
    private static volatile Toolkit _toolkit = (Toolkit)ServiceProxyFactory.newServiceTrackedInstance(Toolkit.class, PwdToolkitUtil.class, (String)"_toolkit", (boolean)false, (boolean)true);

    public static String generate(PasswordPolicy passwordPolicy) {
        return _toolkit.generate(passwordPolicy);
    }

    public static Toolkit getToolkit() {
        return _toolkit;
    }

    public static void validate(long companyId, long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException {
        if (!password1.equals(password2)) {
            throw new UserPasswordException.MustMatch(userId);
        }
        if (!LDAPSettingsUtil.isPasswordPolicyEnabled((long)companyId) && PwdToolkitUtilThreadLocal.isValidate()) {
            _toolkit.validate(userId, password1, password2, passwordPolicy);
        }
    }

    private PwdToolkitUtil() {
    }
}

