/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class LayoutLocalServiceStagingAdvice
implements BeanFactoryAware {
    protected LayoutLocalServiceHelper layoutLocalServiceHelper;
    private static final Class<?>[] _GET_LAYOUTS_TYPES = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _UPDATE_LAYOUT_PARAMETER_TYPES = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, String.class, Boolean.class, byte[].class, ServiceContext.class};
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceStagingAdvice.class);
    private static final Set<String> _layoutLocalServiceStagingAdviceMethodNames = new HashSet<String>(Arrays.asList("create", "createLayout", "deleteLayout", "getLayouts", "updateLayout", "updateLookAndFeel", "updateName"));
    private static final Function<InvocationHandler, Layout> _proxyProviderFunction = ProxyUtil.getProxyProviderFunction((Class[])new Class[]{Layout.class, ModelWrapper.class});
    private BeanFactory _beanFactory;

    public LayoutLocalServiceStagingAdvice() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Instantiating " + this.hashCode()));
        }
    }

    public void afterPropertiesSet() throws BeansException {
        AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)ProxyUtil.fetchInvocationHandler((Object)this._beanFactory.getBean(LayoutLocalService.class.getName()), AopInvocationHandler.class);
        aopInvocationHandler.setTarget(ProxyUtil.newProxyInstance((ClassLoader)LayoutLocalServiceStagingAdvice.class.getClassLoader(), (Class[])new Class[]{IdentifiableOSGiService.class, LayoutLocalService.class, BaseLocalService.class}, (InvocationHandler)new LayoutLocalServiceStagingInvocationHandler(this, aopInvocationHandler.getTarget())));
        this.layoutLocalServiceHelper = (LayoutLocalServiceHelper)this._beanFactory.getBean(LayoutLocalServiceHelper.class.getName());
    }

    public void deleteLayout(LayoutLocalService layoutLocalService, Layout layout, ServiceContext serviceContext) throws PortalException {
        long layoutSetBranchId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"layoutSetBranchId");
        if (layoutSetBranchId > 0L) {
            LayoutRevisionLocalServiceUtil.deleteLayoutRevisions((long)layoutSetBranchId, (long)layout.getPlid());
            List notIncompleteLayoutRevisions = LayoutRevisionUtil.findByP_NotS((long)layout.getPlid(), (int)6);
            if (notIncompleteLayoutRevisions.isEmpty()) {
                LayoutRevisionLocalServiceUtil.deleteLayoutLayoutRevisions((long)layout.getPlid());
                this.doDeleteLayout(layoutLocalService, layout, serviceContext);
            }
        } else {
            this.doDeleteLayout(layoutLocalService, layout, serviceContext);
        }
    }

    public void deleteLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        Layout layout = layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        this.deleteLayout(layoutLocalService, layout, serviceContext);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this._beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layout updateLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean hasIconImage, byte[] iconBytes, long masterLayoutPlid, long styleBookEntryId, ServiceContext serviceContext) throws PortalException {
        LayoutRevision layoutRevision;
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        Map<Locale, String> layoutFriendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = layoutFriendlyURLMap.get(LocaleUtil.getSiteDefault());
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, layoutFriendlyURLMap, serviceContext);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout layout = LayoutUtil.findByG_P_L((long)groupId, (boolean)privateLayout, (long)layoutId);
        if (LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            layout = this.getProxiedLayout(layout);
        }
        if ((layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout)) == null) {
            return layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, hasIconImage, iconBytes, masterLayoutPlid, styleBookEntryId, serviceContext);
        }
        layoutLocalService.updateAsset(serviceContext.getUserId(), layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setParentLayoutId(parentLayoutId);
        layoutRevision.setNameMap(nameMap);
        layoutRevision.setTitleMap(titleMap);
        layoutRevision.setDescriptionMap(descriptionMap);
        layoutRevision.setKeywordsMap(keywordsMap);
        layoutRevision.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        if (!hasIconImage) {
            layout.setIconImageId(0L);
            layoutRevision.setIconImageId(0L);
        } else {
            PortalUtil.updateImageId((BaseModel)layout, (boolean)hasIconImage, (byte[])iconBytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        }
        layout.setLayoutPrototypeLinkEnabled(ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled"));
        layout.setExpandoBridgeAttributes(serviceContext);
        LayoutUtil.update((Layout)layout);
        LayoutFriendlyURLLocalServiceUtil.updateLayoutFriendlyURLs((long)layout.getUserId(), (long)layout.getCompanyId(), (long)layout.getGroupId(), (long)layout.getPlid(), (boolean)layout.isPrivateLayout(), layoutFriendlyURLMap, (ServiceContext)serviceContext);
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        int workflowAction = serviceContext.getWorkflowAction();
        try {
            serviceContext.setWorkflowAction(2);
            LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        }
        finally {
            serviceContext.setWorkflowAction(workflowAction);
        }
        return layout;
    }

    public Layout updateLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        LayoutRevision layoutRevision;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
        }
        Layout layout = LayoutUtil.findByG_P_L((long)groupId, (boolean)privateLayout, (long)layoutId);
        if (LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            layout = this.getProxiedLayout(layout);
        }
        if ((layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout)) == null) {
            return layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
        }
        layout.setTypeSettings(typeSettings);
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        return layout;
    }

    public Layout updateLookAndFeel(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutRevision layoutRevision;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
        }
        Layout layout = LayoutUtil.findByG_P_L((long)groupId, (boolean)privateLayout, (long)layoutId);
        if (LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            layout = this.getProxiedLayout(layout);
        }
        if ((layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout)) == null) {
            return layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
        }
        layout.setThemeId(themeId);
        layout.setColorSchemeId(colorSchemeId);
        layout.setCss(css);
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        return layout;
    }

    public Layout updateName(LayoutLocalService layoutLocalService, Layout layout, String name, String languageId) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return layoutLocalService.updateName(layout, name, languageId);
        }
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)(layout = this.wrapLayout(layout)));
        if (layoutRevision == null) {
            return layoutLocalService.updateName(layout, name, languageId);
        }
        this.layoutLocalServiceHelper.validateName(name, languageId);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        serviceContext.setWorkflowAction(2);
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeleteLayout(LayoutLocalService layoutLocalService, Layout layout, ServiceContext serviceContext) throws PortalException {
        block7: {
            boolean mergeLayoutPrototypesIsInProgress = false;
            try {
                mergeLayoutPrototypesIsInProgress = MergeLayoutPrototypesThreadLocal.isInProgress();
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.push(Layout.class, (long)layout.getPlid());
                if (systemEventHierarchyEntry == null) {
                    layoutLocalService.deleteLayout(layout, serviceContext);
                    break block7;
                }
                try {
                    layoutLocalService.deleteLayout(layout, serviceContext);
                    systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
                    SystemEventLocalServiceUtil.addSystemEvent((long)0L, (long)layout.getGroupId(), (String)Layout.class.getName(), (long)layout.getPlid(), (String)layout.getUuid(), null, (int)1, (String)systemEventHierarchyEntry.getExtraData());
                }
                finally {
                    SystemEventHierarchyEntryThreadLocal.pop(Layout.class, (long)layout.getPlid());
                }
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)mergeLayoutPrototypesIsInProgress);
            }
        }
    }

    protected Layout getProxiedLayout(Layout layout) {
        ServiceContext serviceContext;
        ObjectValuePair<ServiceContext, Map<Layout, Object>> objectValuePair = ProxiedLayoutsThreadLocal.getProxiedLayouts();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        if (objectValuePair != null && (serviceContext = (ServiceContext)objectValuePair.getKey()) == currentServiceContext) {
            Map proxiedLayouts = (Map)objectValuePair.getValue();
            Object proxiedLayout = proxiedLayouts.get(layout);
            if (proxiedLayout != null) {
                Layout cachedProxiedLayout = (Layout)proxiedLayout;
                if (layout.getMvccVersion() == cachedProxiedLayout.getMvccVersion()) {
                    return cachedProxiedLayout;
                }
                proxiedLayouts.remove(layout);
            }
            proxiedLayout = _proxyProviderFunction.apply((InvocationHandler)new LayoutStagingHandler(layout));
            proxiedLayouts.put(layout, proxiedLayout);
            return (Layout)proxiedLayout;
        }
        Layout proxiedLayout = _proxyProviderFunction.apply((InvocationHandler)new LayoutStagingHandler(layout));
        ProxiedLayoutsThreadLocal.setProxiedLayouts((ObjectValuePair<ServiceContext, Map<Layout, Object>>)new ObjectValuePair((Object)currentServiceContext, (Object)HashMapBuilder.put((Object)layout, (Object)proxiedLayout).build()));
        return proxiedLayout;
    }

    protected Layout unwrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler == null) {
            return layout;
        }
        return layoutStagingHandler.getLayout();
    }

    protected Layout wrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler != null || !LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return layout;
        }
        return this.getProxiedLayout(layout);
    }

    protected List<Layout> wrapLayouts(List<Layout> layouts, boolean showIncomplete) {
        long layoutSetBranchId;
        block7: {
            if (layouts.isEmpty()) {
                return layouts;
            }
            Layout firstLayout = layouts.get(0);
            Layout wrappedFirstLayout = this.wrapLayout(firstLayout);
            if (wrappedFirstLayout == firstLayout) {
                return layouts;
            }
            layoutSetBranchId = 0L;
            if (!showIncomplete) {
                long userId = 0L;
                try {
                    userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
                    if (userId > 0L) {
                        LayoutSet layoutSet = firstLayout.getLayoutSet();
                        layoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)UserLocalServiceUtil.getUser((long)userId), (long)layoutSet.getLayoutSetId());
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)("No layout set branch found for user " + userId), (Throwable)exception);
                }
            }
        }
        ArrayList<Layout> wrappedLayouts = new ArrayList<Layout>(layouts.size());
        for (Layout layout : layouts) {
            Layout wrappedLayout = this.wrapLayout(layout);
            if (!showIncomplete && StagingUtil.isIncomplete((Layout)wrappedLayout, (long)layoutSetBranchId)) continue;
            wrappedLayouts.add(wrappedLayout);
        }
        return wrappedLayouts;
    }

    protected Object wrapReturnValue(Object returnValue, boolean showIncomplete) {
        if (returnValue instanceof Layout) {
            returnValue = this.wrapLayout((Layout)returnValue);
        } else if (returnValue instanceof List) {
            Object object;
            List list = returnValue;
            if (!list.isEmpty() && (object = list.get(0)) instanceof Layout) {
                returnValue = this.wrapLayouts(returnValue, showIncomplete);
            }
        } else if (returnValue instanceof Map) {
            Map map = (Map)((Object)returnValue);
            if (map.isEmpty()) {
                return returnValue;
            }
            map.replaceAll((key, value) -> this.wrapReturnValue(value, showIncomplete));
        }
        return returnValue;
    }

    private class LayoutLocalServiceStagingInvocationHandler
    implements InvocationHandler {
        private final LayoutLocalServiceStagingAdvice _layoutLocalServiceStagingAdvice;
        private final Object _targetObject;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            if (!StagingAdvicesThreadLocal.isEnabled()) {
                return this._invoke(method, arguments);
            }
            String methodName = method.getName();
            if (!_layoutLocalServiceStagingAdviceMethodNames.contains(methodName)) {
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), false);
            }
            Object returnValue = null;
            Object[] parameterTypes = method.getParameterTypes();
            if (methodName.equals("create") || methodName.equals("createLayout")) {
                return this._invoke(method, arguments);
            }
            if (methodName.equals("deleteLayout")) {
                if (arguments.length == 2 && arguments[0] instanceof Layout) {
                    LayoutLocalServiceStagingAdvice.this.deleteLayout((LayoutLocalService)this._targetObject, (Layout)arguments[0], (ServiceContext)arguments[1]);
                    return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
                } else if (arguments.length == 3) {
                    LayoutLocalServiceStagingAdvice.this.deleteLayout((LayoutLocalService)this._targetObject, (Layout)arguments[0], (ServiceContext)arguments[2]);
                    return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
                } else {
                    if (arguments.length != 4) return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), false);
                    LayoutLocalServiceStagingAdvice.this.deleteLayout((LayoutLocalService)this._targetObject, (Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (ServiceContext)arguments[3]);
                }
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
            }
            if (methodName.equals("getLayouts")) {
                boolean showIncomplete = false;
                if (arguments.length == 6 && parameterTypes[3].equals(Boolean.TYPE)) {
                    showIncomplete = (Boolean)arguments[3];
                    return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
                } else if (arguments.length == 7 && parameterTypes[3].equals(Boolean.TYPE)) {
                    showIncomplete = (Boolean)arguments[3];
                    return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
                } else {
                    if (!Arrays.equals(parameterTypes, _GET_LAYOUTS_TYPES)) return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
                    showIncomplete = true;
                }
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(this._invoke(method, arguments), showIncomplete);
            }
            if (methodName.equals("updateLayout") && (arguments.length == 15 || arguments.length == 16 || arguments.length == 17)) {
                Map friendlyURLMap = null;
                friendlyURLMap = Arrays.equals(parameterTypes, _UPDATE_LAYOUT_PARAMETER_TYPES) ? HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)((String)arguments[11])).build() : (Map)arguments[11];
                long masterLayoutPlid = 0L;
                long styleBookEntryId = 0L;
                ServiceContext serviceContext = null;
                if (arguments.length == 15) {
                    serviceContext = (ServiceContext)arguments[14];
                } else if (arguments.length == 16) {
                    masterLayoutPlid = (Long)arguments[14];
                    serviceContext = (ServiceContext)arguments[15];
                } else if (arguments.length == 17) {
                    masterLayoutPlid = (Long)arguments[14];
                    styleBookEntryId = (Long)arguments[15];
                    serviceContext = (ServiceContext)arguments[16];
                }
                returnValue = LayoutLocalServiceStagingAdvice.this.updateLayout((LayoutLocalService)this._targetObject, (Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (Long)arguments[3], (Map)arguments[4], (Map)arguments[5], (Map)arguments[6], (Map)arguments[7], (Map)arguments[8], (String)arguments[9], (Boolean)arguments[10], friendlyURLMap, (Boolean)arguments[12], (byte[])arguments[13], masterLayoutPlid, styleBookEntryId, serviceContext);
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
            }
            if (methodName.equals("updateLayout") && arguments.length == 10) {
                LayoutLocalServiceStagingAdvice.this.updateLookAndFeel((LayoutLocalService)this._targetObject, (Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (String)arguments[5], (String)arguments[6], (String)arguments[8]);
            }
            try {
                Class<LayoutLocalServiceStagingAdvice> clazz = LayoutLocalServiceStagingAdvice.class;
                parameterTypes = (Class[])ArrayUtil.append((Object[])new Class[]{LayoutLocalService.class}, (Object[])parameterTypes);
                Method layoutLocalServiceStagingAdviceMethod = clazz.getMethod(methodName, (Class<?>[])parameterTypes);
                arguments = ArrayUtil.append((Object[])new Object[]{this._targetObject}, (Object[])arguments);
                returnValue = layoutLocalServiceStagingAdviceMethod.invoke((Object)this._layoutLocalServiceStagingAdvice, arguments);
                return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchMethodException);
                }
                returnValue = this._invoke(method, arguments);
            }
            return LayoutLocalServiceStagingAdvice.this.wrapReturnValue(returnValue, false);
        }

        private LayoutLocalServiceStagingInvocationHandler(LayoutLocalServiceStagingAdvice layoutLocalServiceStagingAdvice2, Object targetObject) {
            this._layoutLocalServiceStagingAdvice = layoutLocalServiceStagingAdvice2;
            this._targetObject = targetObject;
        }

        private Object _invoke(Method method, Object[] arguments) throws Throwable {
            try {
                return method.invoke(this._targetObject, arguments);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }
}

