/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetTable;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetUtil;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelperUtil;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.LayoutSetImpl;
import com.liferay.portal.model.impl.LayoutSetModelImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LayoutSetPersistenceImpl
extends BasePersistenceImpl<LayoutSet>
implements LayoutSetPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = LayoutSetImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "layoutSet.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByLayoutSetPrototypeUuid;
    private FinderPath _finderPathWithoutPaginationFindByLayoutSetPrototypeUuid;
    private FinderPath _finderPathCountByLayoutSetPrototypeUuid;
    private static final String _FINDER_COLUMN_LAYOUTSETPROTOTYPEUUID_LAYOUTSETPROTOTYPEUUID_2 = "layoutSet.layoutSetPrototypeUuid = ?";
    private static final String _FINDER_COLUMN_LAYOUTSETPROTOTYPEUUID_LAYOUTSETPROTOTYPEUUID_3 = "(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')";
    private FinderPath _finderPathFetchByG_P;
    private FinderPath _finderPathCountByG_P;
    private static final String _FINDER_COLUMN_G_P_GROUPID_2 = "layoutSet.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_P_PRIVATELAYOUT_2 = "layoutSet.privateLayout = ?";
    private FinderPath _finderPathWithPaginationFindByC_L;
    private FinderPath _finderPathWithoutPaginationFindByC_L;
    private FinderPath _finderPathCountByC_L;
    private static final String _FINDER_COLUMN_C_L_COMPANYID_2 = "layoutSet.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_LAYOUTSETPROTOTYPEUUID_2 = "layoutSet.layoutSetPrototypeUuid = ?";
    private static final String _FINDER_COLUMN_C_L_LAYOUTSETPROTOTYPEUUID_3 = "(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')";
    private FinderPath _finderPathFetchByP_L;
    private FinderPath _finderPathCountByP_L;
    private static final String _FINDER_COLUMN_P_L_PRIVATELAYOUT_2 = "layoutSet.privateLayout = ? AND ";
    private static final String _FINDER_COLUMN_P_L_LOGOID_2 = "layoutSet.logoId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private static final String _SQL_SELECT_LAYOUTSET = "SELECT layoutSet FROM LayoutSet layoutSet";
    private static final String _SQL_SELECT_LAYOUTSET_WHERE = "SELECT layoutSet FROM LayoutSet layoutSet WHERE ";
    private static final String _SQL_COUNT_LAYOUTSET = "SELECT COUNT(layoutSet) FROM LayoutSet layoutSet";
    private static final String _SQL_COUNT_LAYOUTSET_WHERE = "SELECT COUNT(layoutSet) FROM LayoutSet layoutSet WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "layoutSet.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No LayoutSet exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No LayoutSet exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;

    public List<LayoutSet> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<LayoutSet> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<LayoutSet> findByGroupId(long groupId, int start, int end, OrderByComparator<LayoutSet> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<LayoutSet> findByGroupId(long groupId, int start, int end, OrderByComparator<LayoutSet> orderByComparator, boolean useFinderCache) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (LayoutSet layoutSet : list) {
                if (groupId == layoutSet.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY layoutSet.layoutSetId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LayoutSet findByGroupId_First(long groupId, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByGroupId_First(groupId, orderByComparator);
        if (layoutSet != null) {
            return layoutSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchLayoutSetException(sb.toString());
    }

    public LayoutSet fetchByGroupId_First(long groupId, OrderByComparator<LayoutSet> orderByComparator) {
        List<LayoutSet> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSet findByGroupId_Last(long groupId, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (layoutSet != null) {
            return layoutSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchLayoutSetException(sb.toString());
    }

    public LayoutSet fetchByGroupId_Last(long groupId, OrderByComparator<LayoutSet> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<LayoutSet> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSet[] findByGroupId_PrevAndNext(long layoutSetId, long groupId, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.findByPrimaryKey(layoutSetId);
        Session session = null;
        try {
            session = this.openSession();
            LayoutSet[] array = new LayoutSetImpl[]{this.getByGroupId_PrevAndNext(session, layoutSet, groupId, orderByComparator, true), layoutSet, this.getByGroupId_PrevAndNext(session, layoutSet, groupId, orderByComparator, false)};
            LayoutSet[] layoutSetArray = array;
            return layoutSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSet getByGroupId_PrevAndNext(Session session, LayoutSet layoutSet, long groupId, OrderByComparator<LayoutSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY layoutSet.layoutSetId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)layoutSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LayoutSet)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (LayoutSet layoutSet : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)layoutSet);
        }
    }

    public int countByGroupId(long groupId) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByGroupId;
            finderArgs = new Object[]{groupId};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LayoutSet> findByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        return this.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid, -1, -1, null);
    }

    public List<LayoutSet> findByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid, int start, int end) {
        return this.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid, start, end, null);
    }

    public List<LayoutSet> findByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid, int start, int end, OrderByComparator<LayoutSet> orderByComparator) {
        return this.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid, start, end, orderByComparator, true);
    }

    public List<LayoutSet> findByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid, int start, int end, OrderByComparator<LayoutSet> orderByComparator, boolean useFinderCache) {
        layoutSetPrototypeUuid = Objects.toString(layoutSetPrototypeUuid, "");
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByLayoutSetPrototypeUuid;
                finderArgs = new Object[]{layoutSetPrototypeUuid};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByLayoutSetPrototypeUuid;
            finderArgs = new Object[]{layoutSetPrototypeUuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (LayoutSet layoutSet : list) {
                if (layoutSetPrototypeUuid.equals(layoutSet.getLayoutSetPrototypeUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
            boolean bindLayoutSetPrototypeUuid = false;
            if (layoutSetPrototypeUuid.isEmpty()) {
                sb.append("(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')");
            } else {
                bindLayoutSetPrototypeUuid = true;
                sb.append("layoutSet.layoutSetPrototypeUuid = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY layoutSet.layoutSetId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindLayoutSetPrototypeUuid) {
                    queryPos.add(layoutSetPrototypeUuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LayoutSet findByLayoutSetPrototypeUuid_First(String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByLayoutSetPrototypeUuid_First(layoutSetPrototypeUuid, orderByComparator);
        if (layoutSet != null) {
            return layoutSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("layoutSetPrototypeUuid=");
        sb.append(layoutSetPrototypeUuid);
        sb.append("}");
        throw new NoSuchLayoutSetException(sb.toString());
    }

    public LayoutSet fetchByLayoutSetPrototypeUuid_First(String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) {
        List<LayoutSet> list = this.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSet findByLayoutSetPrototypeUuid_Last(String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByLayoutSetPrototypeUuid_Last(layoutSetPrototypeUuid, orderByComparator);
        if (layoutSet != null) {
            return layoutSet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("layoutSetPrototypeUuid=");
        sb.append(layoutSetPrototypeUuid);
        sb.append("}");
        throw new NoSuchLayoutSetException(sb.toString());
    }

    public LayoutSet fetchByLayoutSetPrototypeUuid_Last(String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) {
        int count = this.countByLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
        if (count == 0) {
            return null;
        }
        List<LayoutSet> list = this.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSet[] findByLayoutSetPrototypeUuid_PrevAndNext(long layoutSetId, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        layoutSetPrototypeUuid = Objects.toString(layoutSetPrototypeUuid, "");
        LayoutSet layoutSet = this.findByPrimaryKey(layoutSetId);
        Session session = null;
        try {
            session = this.openSession();
            LayoutSet[] array = new LayoutSetImpl[]{this.getByLayoutSetPrototypeUuid_PrevAndNext(session, layoutSet, layoutSetPrototypeUuid, orderByComparator, true), layoutSet, this.getByLayoutSetPrototypeUuid_PrevAndNext(session, layoutSet, layoutSetPrototypeUuid, orderByComparator, false)};
            LayoutSet[] layoutSetArray = array;
            return layoutSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSet getByLayoutSetPrototypeUuid_PrevAndNext(Session session, LayoutSet layoutSet, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
        boolean bindLayoutSetPrototypeUuid = false;
        if (layoutSetPrototypeUuid.isEmpty()) {
            sb.append("(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')");
        } else {
            bindLayoutSetPrototypeUuid = true;
            sb.append("layoutSet.layoutSetPrototypeUuid = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY layoutSet.layoutSetId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindLayoutSetPrototypeUuid) {
            queryPos.add(layoutSetPrototypeUuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)layoutSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LayoutSet)list.get(1);
        }
        return null;
    }

    public void removeByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        for (LayoutSet layoutSet : this.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid, -1, -1, null)) {
            this.remove((BaseModel)layoutSet);
        }
    }

    public int countByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        layoutSetPrototypeUuid = Objects.toString(layoutSetPrototypeUuid, "");
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByLayoutSetPrototypeUuid;
            finderArgs = new Object[]{layoutSetPrototypeUuid};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_LAYOUTSET_WHERE);
            boolean bindLayoutSetPrototypeUuid = false;
            if (layoutSetPrototypeUuid.isEmpty()) {
                sb.append("(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')");
            } else {
                bindLayoutSetPrototypeUuid = true;
                sb.append("layoutSet.layoutSetPrototypeUuid = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindLayoutSetPrototypeUuid) {
                    queryPos.add(layoutSetPrototypeUuid);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LayoutSet findByG_P(long groupId, boolean privateLayout) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByG_P(groupId, privateLayout);
        if (layoutSet == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchLayoutSetException(sb.toString());
        }
        return layoutSet;
    }

    public LayoutSet fetchByG_P(long groupId, boolean privateLayout) {
        return this.fetchByG_P(groupId, privateLayout, true);
    }

    public LayoutSet fetchByG_P(long groupId, boolean privateLayout, boolean useFinderCache) {
        LayoutSet layoutSet;
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{groupId, privateLayout};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByG_P, finderArgs);
        }
        if (result instanceof LayoutSet && (groupId != (layoutSet = (LayoutSet)result).getGroupId() || privateLayout != layoutSet.isPrivateLayout())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_G_P_GROUPID_2);
            sb.append(_FINDER_COLUMN_G_P_PRIVATELAYOUT_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(privateLayout);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByG_P, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    LayoutSet layoutSet2 = (LayoutSet)list.get(0);
                    result = layoutSet2;
                    this.cacheResult(layoutSet2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (LayoutSet)result;
    }

    public LayoutSet removeByG_P(long groupId, boolean privateLayout) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.findByG_P(groupId, privateLayout);
        return (LayoutSet)this.remove((BaseModel)layoutSet);
    }

    public int countByG_P(long groupId, boolean privateLayout) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByG_P;
            finderArgs = new Object[]{groupId, privateLayout};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_G_P_GROUPID_2);
            sb.append(_FINDER_COLUMN_G_P_PRIVATELAYOUT_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(privateLayout);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<LayoutSet> findByC_L(long companyId, String layoutSetPrototypeUuid) {
        return this.findByC_L(companyId, layoutSetPrototypeUuid, -1, -1, null);
    }

    public List<LayoutSet> findByC_L(long companyId, String layoutSetPrototypeUuid, int start, int end) {
        return this.findByC_L(companyId, layoutSetPrototypeUuid, start, end, null);
    }

    public List<LayoutSet> findByC_L(long companyId, String layoutSetPrototypeUuid, int start, int end, OrderByComparator<LayoutSet> orderByComparator) {
        return this.findByC_L(companyId, layoutSetPrototypeUuid, start, end, orderByComparator, true);
    }

    public List<LayoutSet> findByC_L(long companyId, String layoutSetPrototypeUuid, int start, int end, OrderByComparator<LayoutSet> orderByComparator, boolean useFinderCache) {
        layoutSetPrototypeUuid = Objects.toString(layoutSetPrototypeUuid, "");
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByC_L;
                finderArgs = new Object[]{companyId, layoutSetPrototypeUuid};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByC_L;
            finderArgs = new Object[]{companyId, layoutSetPrototypeUuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (LayoutSet layoutSet : list) {
                if (companyId == layoutSet.getCompanyId() && layoutSetPrototypeUuid.equals(layoutSet.getLayoutSetPrototypeUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            boolean bindLayoutSetPrototypeUuid = false;
            if (layoutSetPrototypeUuid.isEmpty()) {
                sb.append("(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')");
            } else {
                bindLayoutSetPrototypeUuid = true;
                sb.append("layoutSet.layoutSetPrototypeUuid = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY layoutSet.layoutSetId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindLayoutSetPrototypeUuid) {
                    queryPos.add(layoutSetPrototypeUuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public LayoutSet findByC_L_First(long companyId, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByC_L_First(companyId, layoutSetPrototypeUuid, orderByComparator);
        if (layoutSet != null) {
            return layoutSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", layoutSetPrototypeUuid=");
        sb.append(layoutSetPrototypeUuid);
        sb.append("}");
        throw new NoSuchLayoutSetException(sb.toString());
    }

    public LayoutSet fetchByC_L_First(long companyId, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) {
        List<LayoutSet> list = this.findByC_L(companyId, layoutSetPrototypeUuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSet findByC_L_Last(long companyId, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByC_L_Last(companyId, layoutSetPrototypeUuid, orderByComparator);
        if (layoutSet != null) {
            return layoutSet;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", layoutSetPrototypeUuid=");
        sb.append(layoutSetPrototypeUuid);
        sb.append("}");
        throw new NoSuchLayoutSetException(sb.toString());
    }

    public LayoutSet fetchByC_L_Last(long companyId, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) {
        int count = this.countByC_L(companyId, layoutSetPrototypeUuid);
        if (count == 0) {
            return null;
        }
        List<LayoutSet> list = this.findByC_L(companyId, layoutSetPrototypeUuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSet[] findByC_L_PrevAndNext(long layoutSetId, long companyId, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator) throws NoSuchLayoutSetException {
        layoutSetPrototypeUuid = Objects.toString(layoutSetPrototypeUuid, "");
        LayoutSet layoutSet = this.findByPrimaryKey(layoutSetId);
        Session session = null;
        try {
            session = this.openSession();
            LayoutSet[] array = new LayoutSetImpl[]{this.getByC_L_PrevAndNext(session, layoutSet, companyId, layoutSetPrototypeUuid, orderByComparator, true), layoutSet, this.getByC_L_PrevAndNext(session, layoutSet, companyId, layoutSetPrototypeUuid, orderByComparator, false)};
            LayoutSet[] layoutSetArray = array;
            return layoutSetArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSet getByC_L_PrevAndNext(Session session, LayoutSet layoutSet, long companyId, String layoutSetPrototypeUuid, OrderByComparator<LayoutSet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
        sb.append(_FINDER_COLUMN_C_L_COMPANYID_2);
        boolean bindLayoutSetPrototypeUuid = false;
        if (layoutSetPrototypeUuid.isEmpty()) {
            sb.append("(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')");
        } else {
            bindLayoutSetPrototypeUuid = true;
            sb.append("layoutSet.layoutSetPrototypeUuid = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY layoutSet.layoutSetId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindLayoutSetPrototypeUuid) {
            queryPos.add(layoutSetPrototypeUuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)layoutSet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LayoutSet)list.get(1);
        }
        return null;
    }

    public void removeByC_L(long companyId, String layoutSetPrototypeUuid) {
        for (LayoutSet layoutSet : this.findByC_L(companyId, layoutSetPrototypeUuid, -1, -1, null)) {
            this.remove((BaseModel)layoutSet);
        }
    }

    public int countByC_L(long companyId, String layoutSetPrototypeUuid) {
        layoutSetPrototypeUuid = Objects.toString(layoutSetPrototypeUuid, "");
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_L;
            finderArgs = new Object[]{companyId, layoutSetPrototypeUuid};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            boolean bindLayoutSetPrototypeUuid = false;
            if (layoutSetPrototypeUuid.isEmpty()) {
                sb.append("(layoutSet.layoutSetPrototypeUuid IS NULL OR layoutSet.layoutSetPrototypeUuid = '')");
            } else {
                bindLayoutSetPrototypeUuid = true;
                sb.append("layoutSet.layoutSetPrototypeUuid = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindLayoutSetPrototypeUuid) {
                    queryPos.add(layoutSetPrototypeUuid);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LayoutSet findByP_L(boolean privateLayout, long logoId) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByP_L(privateLayout, logoId);
        if (layoutSet == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("privateLayout=");
            sb.append(privateLayout);
            sb.append(", logoId=");
            sb.append(logoId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchLayoutSetException(sb.toString());
        }
        return layoutSet;
    }

    public LayoutSet fetchByP_L(boolean privateLayout, long logoId) {
        return this.fetchByP_L(privateLayout, logoId, true);
    }

    public LayoutSet fetchByP_L(boolean privateLayout, long logoId, boolean useFinderCache) {
        LayoutSet layoutSet;
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{privateLayout, logoId};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByP_L, finderArgs);
        }
        if (result instanceof LayoutSet && (privateLayout != (layoutSet = (LayoutSet)result).isPrivateLayout() || logoId != layoutSet.getLogoId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_P_L_PRIVATELAYOUT_2);
            sb.append(_FINDER_COLUMN_P_L_LOGOID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(privateLayout);
                queryPos.add(logoId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByP_L, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!productionMode || !useFinderCache) {
                                finderArgs = new Object[]{privateLayout, logoId};
                            }
                            _log.warn((Object)("LayoutSetPersistenceImpl.fetchByP_L(boolean, long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    LayoutSet layoutSet2 = (LayoutSet)list.get(0);
                    result = layoutSet2;
                    this.cacheResult(layoutSet2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (LayoutSet)result;
    }

    public LayoutSet removeByP_L(boolean privateLayout, long logoId) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.findByP_L(privateLayout, logoId);
        return (LayoutSet)this.remove((BaseModel)layoutSet);
    }

    public int countByP_L(boolean privateLayout, long logoId) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByP_L;
            finderArgs = new Object[]{privateLayout, logoId};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_LAYOUTSET_WHERE);
            sb.append(_FINDER_COLUMN_P_L_PRIVATELAYOUT_2);
            sb.append(_FINDER_COLUMN_P_L_LOGOID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(privateLayout);
                queryPos.add(logoId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public LayoutSetPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("settings", "settings_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(LayoutSet.class);
        this.setModelImplClass(LayoutSetImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)LayoutSetTable.INSTANCE);
    }

    public void cacheResult(LayoutSet layoutSet) {
        if (layoutSet.getCtCollectionId() != 0L) {
            return;
        }
        EntityCacheUtil.putResult(LayoutSetImpl.class, (Serializable)Long.valueOf(layoutSet.getPrimaryKey()), (Serializable)layoutSet);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByG_P, (Object[])new Object[]{layoutSet.getGroupId(), layoutSet.isPrivateLayout()}, (Object)layoutSet);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByP_L, (Object[])new Object[]{layoutSet.isPrivateLayout(), layoutSet.getLogoId()}, (Object)layoutSet);
    }

    public void cacheResult(List<LayoutSet> layoutSets) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && layoutSets.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (LayoutSet layoutSet : layoutSets) {
            if (layoutSet.getCtCollectionId() != 0L) continue;
            LayoutSet cachedLayoutSet = (LayoutSet)EntityCacheUtil.getResult(LayoutSetImpl.class, (Serializable)Long.valueOf(layoutSet.getPrimaryKey()));
            if (cachedLayoutSet == null) {
                this.cacheResult(layoutSet);
                continue;
            }
            LayoutSetModelImpl layoutSetModelImpl = (LayoutSetModelImpl)layoutSet;
            LayoutSetModelImpl cachedLayoutSetModelImpl = (LayoutSetModelImpl)cachedLayoutSet;
            layoutSetModelImpl.setCompanyFallbackVirtualHostname(cachedLayoutSetModelImpl.getCompanyFallbackVirtualHostname());
            layoutSetModelImpl.setVirtualHostnames(cachedLayoutSetModelImpl.getVirtualHostnames());
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(LayoutSetImpl.class);
        FinderCacheUtil.clearCache(LayoutSetImpl.class);
    }

    public void clearCache(LayoutSet layoutSet) {
        EntityCacheUtil.removeResult(LayoutSetImpl.class, (BaseModel)layoutSet);
    }

    public void clearCache(List<LayoutSet> layoutSets) {
        for (LayoutSet layoutSet : layoutSets) {
            EntityCacheUtil.removeResult(LayoutSetImpl.class, (BaseModel)layoutSet);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(LayoutSetImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(LayoutSetImpl.class, (Serializable)primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(LayoutSetModelImpl layoutSetModelImpl) {
        Object[] args = new Object[]{layoutSetModelImpl.getGroupId(), layoutSetModelImpl.isPrivateLayout()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByG_P, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByG_P, (Object[])args, (Object)((Object)layoutSetModelImpl));
        args = new Object[]{layoutSetModelImpl.isPrivateLayout(), layoutSetModelImpl.getLogoId()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByP_L, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByP_L, (Object[])args, (Object)((Object)layoutSetModelImpl));
    }

    public LayoutSet create(long layoutSetId) {
        LayoutSetImpl layoutSet = new LayoutSetImpl();
        layoutSet.setNew(true);
        layoutSet.setPrimaryKey(layoutSetId);
        layoutSet.setCompanyId(CompanyThreadLocal.getCompanyId());
        return layoutSet;
    }

    public LayoutSet remove(long layoutSetId) throws NoSuchLayoutSetException {
        return this.remove(Long.valueOf(layoutSetId));
    }

    public LayoutSet remove(Serializable primaryKey) throws NoSuchLayoutSetException {
        Session session = null;
        try {
            session = this.openSession();
            LayoutSet layoutSet = (LayoutSet)session.get(LayoutSetImpl.class, primaryKey);
            if (layoutSet == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchLayoutSetException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            LayoutSet layoutSet2 = (LayoutSet)this.remove((BaseModel)layoutSet);
            return layoutSet2;
        }
        catch (NoSuchLayoutSetException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSet removeImpl(LayoutSet layoutSet) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)layoutSet)) {
                layoutSet = (LayoutSet)session.get(LayoutSetImpl.class, layoutSet.getPrimaryKeyObj());
            }
            if (layoutSet != null && CTPersistenceHelperUtil.isRemove((CTModel)layoutSet)) {
                session.delete((Object)layoutSet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (layoutSet != null) {
            this.clearCache(layoutSet);
        }
        return layoutSet;
    }

    public LayoutSet updateImpl(LayoutSet layoutSet) {
        boolean isNew = layoutSet.isNew();
        if (!(layoutSet instanceof LayoutSetModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(layoutSet.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)layoutSet);
                throw new IllegalArgumentException("Implement ModelWrapper in layoutSet proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom LayoutSet implementation " + layoutSet.getClass());
        }
        LayoutSetModelImpl layoutSetModelImpl = (LayoutSetModelImpl)layoutSet;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && layoutSet.getCreateDate() == null) {
            if (serviceContext == null) {
                layoutSet.setCreateDate(date);
            } else {
                layoutSet.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!layoutSetModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                layoutSet.setModifiedDate(date);
            } else {
                layoutSet.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (CTPersistenceHelperUtil.isInsert((CTModel)layoutSet)) {
                if (!isNew) {
                    session.evict(LayoutSetImpl.class, layoutSet.getPrimaryKeyObj());
                }
                session.save((Object)layoutSet);
            } else {
                layoutSet = (LayoutSet)session.merge((Object)layoutSet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (layoutSet.getCtCollectionId() != 0L) {
            if (isNew) {
                layoutSet.setNew(false);
            }
            layoutSet.resetOriginalValues();
            return layoutSet;
        }
        EntityCacheUtil.putResult(LayoutSetImpl.class, (BaseModel)layoutSetModelImpl, (boolean)false, (boolean)true);
        this.cacheUniqueFindersCache(layoutSetModelImpl);
        if (isNew) {
            layoutSet.setNew(false);
        }
        layoutSet.resetOriginalValues();
        return layoutSet;
    }

    public LayoutSet findByPrimaryKey(Serializable primaryKey) throws NoSuchLayoutSetException {
        LayoutSet layoutSet = this.fetchByPrimaryKey(primaryKey);
        if (layoutSet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchLayoutSetException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return layoutSet;
    }

    public LayoutSet findByPrimaryKey(long layoutSetId) throws NoSuchLayoutSetException {
        return this.findByPrimaryKey(Long.valueOf(layoutSetId));
    }

    public LayoutSet fetchByPrimaryKey(Serializable primaryKey) {
        if (CTPersistenceHelperUtil.isProductionMode(LayoutSet.class)) {
            return (LayoutSet)super.fetchByPrimaryKey(primaryKey);
        }
        LayoutSet layoutSet = null;
        Session session = null;
        try {
            session = this.openSession();
            layoutSet = (LayoutSet)session.get(LayoutSetImpl.class, primaryKey);
            if (layoutSet != null) {
                this.cacheResult(layoutSet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return layoutSet;
    }

    public LayoutSet fetchByPrimaryKey(long layoutSetId) {
        return this.fetchByPrimaryKey(Long.valueOf(layoutSetId));
    }

    public Map<Serializable, LayoutSet> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (CTPersistenceHelperUtil.isProductionMode(LayoutSet.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, LayoutSet> map = new HashMap<Serializable, LayoutSet>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            LayoutSet layoutSet = this.fetchByPrimaryKey(primaryKey);
            if (layoutSet != null) {
                map.put(primaryKey, layoutSet);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (LayoutSet layoutSet : query.list()) {
                map.put(layoutSet.getPrimaryKeyObj(), layoutSet);
                this.cacheResult(layoutSet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<LayoutSet> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<LayoutSet> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<LayoutSet> findAll(int start, int end, OrderByComparator<LayoutSet> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<LayoutSet> findAll(int start, int end, OrderByComparator<LayoutSet> orderByComparator, boolean useFinderCache) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_LAYOUTSET);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_LAYOUTSET;
                sql = sql.concat(" ORDER BY layoutSet.layoutSetId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (LayoutSet layoutSet : this.findAll()) {
            this.remove((BaseModel)layoutSet);
        }
    }

    public int countAll() {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(LayoutSet.class);
        Long count = null;
        if (productionMode) {
            count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_LAYOUTSET);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "layoutSetId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_LAYOUTSET;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return LayoutSetModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "LayoutSet";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._finderPathWithPaginationFindByLayoutSetPrototypeUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLayoutSetPrototypeUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"layoutSetPrototypeUuid"}, true);
        this._finderPathWithoutPaginationFindByLayoutSetPrototypeUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByLayoutSetPrototypeUuid", new String[]{String.class.getName()}, new String[]{"layoutSetPrototypeUuid"}, true);
        this._finderPathCountByLayoutSetPrototypeUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLayoutSetPrototypeUuid", new String[]{String.class.getName()}, new String[]{"layoutSetPrototypeUuid"}, false);
        this._finderPathFetchByG_P = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByG_P", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"groupId", "privateLayout"}, true);
        this._finderPathCountByG_P = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_P", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"groupId", "privateLayout"}, false);
        this._finderPathWithPaginationFindByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_L", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "layoutSetPrototypeUuid"}, true);
        this._finderPathWithoutPaginationFindByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_L", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "layoutSetPrototypeUuid"}, true);
        this._finderPathCountByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_L", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "layoutSetPrototypeUuid"}, false);
        this._finderPathFetchByP_L = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByP_L", new String[]{Boolean.class.getName(), Long.class.getName()}, new String[]{"privateLayout", "logoId"}, true);
        this._finderPathCountByP_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByP_L", new String[]{Boolean.class.getName(), Long.class.getName()}, new String[]{"privateLayout", "logoId"}, false);
        this._setLayoutSetUtilPersistence(this);
    }

    public void destroy() {
        this._setLayoutSetUtilPersistence(null);
        EntityCacheUtil.removeCache((String)LayoutSetImpl.class.getName());
    }

    private void _setLayoutSetUtilPersistence(LayoutSetPersistence layoutSetPersistence) {
        try {
            Field field = LayoutSetUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, layoutSetPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctIgnoreColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("createDate");
        ctIgnoreColumnNames.add("modifiedDate");
        ctStrictColumnNames.add("privateLayout");
        ctStrictColumnNames.add("logoId");
        ctStrictColumnNames.add("themeId");
        ctStrictColumnNames.add("colorSchemeId");
        ctStrictColumnNames.add("css");
        ctStrictColumnNames.add("settings_");
        ctStrictColumnNames.add("layoutSetPrototypeUuid");
        ctStrictColumnNames.add("layoutSetPrototypeLinkEnabled");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.IGNORE, ctIgnoreColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("layoutSetId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"groupId", "privateLayout"});
        _log = LogFactoryUtil.getLog(LayoutSetPersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"settings"});
    }
}

