/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServletAdapter
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(ServletAdapter.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private ServiceTracker<Servlet, Servlet> _serviceTracker;

    public void destroy() {
        super.destroy();
        this._serviceTracker.close();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Filter filter = SystemBundleUtil.createFilter((String)StringBundler.concat((String[])new String[]{"(&", config.getInitParameter("filter"), "(objectClass=", Servlet.class.getName(), "))"}));
        this._serviceTracker = new ServiceTracker(this._bundleContext, filter, (ServiceTrackerCustomizer)new ServletTrackerCustomizer());
        this._serviceTracker.open();
    }

    protected Servlet getServlet() {
        return (Servlet)this._serviceTracker.getService();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Servlet servlet = this.getServlet();
        if (servlet == null) {
            ServletConfig servletConfig = this.getServletConfig();
            PortalUtil.sendError((int)503, (Exception)((Object)new ServletException("A servlet matching the filter " + servletConfig.getInitParameter("filter") + " is unavailable")), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return;
        }
        servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private class ServletTrackerCustomizer
    implements ServiceTrackerCustomizer<Servlet, Servlet> {
        private ServletTrackerCustomizer() {
        }

        public Servlet addingService(final ServiceReference<Servlet> serviceReference) {
            ServletConfig servletConfig = new ServletConfig(){

                public String getInitParameter(String name) {
                    return GetterUtil.getString((Object)serviceReference.getProperty(name), null);
                }

                public Enumeration<String> getInitParameterNames() {
                    return Collections.enumeration(Arrays.asList(serviceReference.getPropertyKeys()));
                }

                public ServletContext getServletContext() {
                    return ServletContextPool.get((String)PortalUtil.getServletContextName());
                }

                public String getServletName() {
                    return GetterUtil.getString((Object)serviceReference.getProperty("osgi.http.whiteboard.servlet.name"));
                }
            };
            Servlet servlet = (Servlet)ServletAdapter.this._bundleContext.getService(serviceReference);
            try {
                servlet.init(servletConfig);
            }
            catch (ServletException servletException) {
                _log.error((Object)"Unable to initialize servlet", (Throwable)servletException);
            }
            return servlet;
        }

        public void modifiedService(ServiceReference<Servlet> serviceReference, Servlet service) {
        }

        public void removedService(ServiceReference<Servlet> serviceReference, Servlet service) {
            service.destroy();
            ServletAdapter.this._bundleContext.ungetService(serviceReference);
        }
    }
}

