/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ResourceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.servlet.filters.IgnoreModuleRequestFilter;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.servlet.filters.util.CacheFileNameGenerator;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicCSSFilter
extends IgnoreModuleRequestFilter {
    public static final boolean ENABLED = GetterUtil.getBoolean((String)PropsUtil.get(DynamicCSSFilter.class.getName()));
    private static final String _CACHE_FILE_NAME_RTL = "_rtl";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = "css";
    private static final Log _log = LogFactoryUtil.getLog(DynamicCSSFilter.class);
    private ServletContext _servletContext;
    private File _tempDir;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        this._tempDir = new File(tempDir, _TEMP_DIR);
        this._tempDir.mkdirs();
    }

    protected String getCacheFileName(HttpServletRequest httpServletRequest) {
        String cacheFileName = CacheFileNameGenerator.getCacheFileName(httpServletRequest, DynamicCSSFilter.class.getName());
        if (PortalUtil.isRightToLeft((HttpServletRequest)httpServletRequest)) {
            return cacheFileName + _CACHE_FILE_NAME_RTL;
        }
        return cacheFileName;
    }

    protected Object getDynamicContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String content;
        String dynamicContent;
        long lastModified;
        File cacheDataFile;
        block13: {
            ObjectValuePair objectValuePair;
            String originalRequestPath = httpServletRequest.getRequestURI();
            if (originalRequestPath.endsWith(_CSS_EXTENSION) && PortalUtil.isRightToLeft((HttpServletRequest)httpServletRequest)) {
                int pos = originalRequestPath.lastIndexOf(".");
                originalRequestPath = originalRequestPath.substring(0, pos) + _CACHE_FILE_NAME_RTL + originalRequestPath.substring(pos);
            }
            if ((objectValuePair = ResourceUtil.getObjectValuePair((String)originalRequestPath, (String)this.getRequestPath(httpServletRequest), (ServletContext)this._servletContext)) == null) {
                return null;
            }
            URL resourceURL = (URL)objectValuePair.getValue();
            String cacheCommonFileName = this.getCacheFileName(httpServletRequest);
            File cacheContentTypeFile = new File(this._tempDir, cacheCommonFileName + "_E_CTYPE");
            cacheDataFile = new File(this._tempDir, cacheCommonFileName + "_E_DATA");
            lastModified = this.getLastModified(httpServletRequest, resourceURL);
            if (cacheDataFile.exists() && cacheDataFile.lastModified() == lastModified) {
                if (cacheContentTypeFile.exists()) {
                    httpServletResponse.setContentType(FileUtil.read((File)cacheContentTypeFile));
                }
                return cacheDataFile;
            }
            ServletContext servletContext = (ServletContext)objectValuePair.getKey();
            dynamicContent = null;
            content = null;
            try {
                if (originalRequestPath.endsWith(_CSS_EXTENSION)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Replacing tokens on CSS " + originalRequestPath));
                    }
                    content = StringUtil.read((InputStream)resourceURL.openStream());
                    dynamicContent = DynamicCSSUtil.replaceToken(servletContext, httpServletRequest, content);
                    httpServletResponse.setContentType("text/css; charset=UTF-8");
                    FileUtil.write((File)cacheContentTypeFile, (String)"text/css; charset=UTF-8");
                    break block13;
                }
                if (originalRequestPath.endsWith(_JSP_EXTENSION)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Replacing tokens on JSP or servlet " + originalRequestPath));
                    }
                    BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
                    this.processFilter(DynamicCSSFilter.class.getName(), httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, filterChain);
                    content = bufferCacheServletResponse.getString();
                    dynamicContent = DynamicCSSUtil.replaceToken(servletContext, httpServletRequest, content);
                    FileUtil.write((File)cacheContentTypeFile, (String)bufferCacheServletResponse.getContentType());
                    break block13;
                }
                return null;
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to replace tokens in CSS " + originalRequestPath), (Throwable)exception);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)content);
                }
                httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            }
        }
        if (dynamicContent != null) {
            FileUtil.write((File)cacheDataFile, (String)dynamicContent);
        } else {
            dynamicContent = content;
        }
        cacheDataFile.setLastModified(lastModified);
        return dynamicContent;
    }

    protected long getLastModified(HttpServletRequest httpServletRequest, URL resourceURL) throws Exception {
        long resourceLastModified = URLUtil.getLastModifiedTime((URL)resourceURL);
        long requestLastModified = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"t", (long)-1L);
        return Math.max(resourceLastModified, requestLastModified);
    }

    protected String getRequestPath(HttpServletRequest httpServletRequest) {
        String requestPath = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        if (!contextPath.equals("/")) {
            requestPath = requestPath.substring(contextPath.length());
        }
        return requestPath;
    }

    @Override
    protected boolean isModuleRequest(HttpServletRequest httpServletRequest) {
        if (PortalWebResourcesUtil.hasContextPath((String)httpServletRequest.getRequestURI())) {
            return false;
        }
        return super.isModuleRequest(httpServletRequest);
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        Object parsedContent = this.getDynamicContent(httpServletRequest, httpServletResponse, filterChain);
        if (parsedContent == null) {
            this.processFilter(DynamicCSSFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
        } else if (parsedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (File)((File)parsedContent));
        } else if (parsedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)((String)parsedContent));
        }
    }
}

