/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.fragment;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FragmentFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = FragmentFilter.class.getName() + "#SKIP_FILTER";
    private static final Log _log = LogFactoryUtil.getLog(FragmentFilter.class);

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.isFragment(httpServletRequest, httpServletResponse) && !this.isAlreadyFiltered(httpServletRequest);
    }

    protected String getContent(HttpServletRequest httpServletRequest, String content) {
        String fragmentId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_f_id");
        int x = content.indexOf("<!-- Begin fragment " + fragmentId + " -->");
        int y = content.indexOf("<!-- End fragment " + fragmentId + " -->");
        if (x == -1 || y == -1) {
            return content;
        }
        x = content.indexOf(">", x);
        return content.substring(x + 1, y);
    }

    protected boolean isAlreadyFiltered(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isFragment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String fragmentId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_f_id");
        return Validator.isNotNull((String)fragmentId);
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        httpServletRequest.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        if (_log.isDebugEnabled()) {
            String completeURL = HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest);
            _log.debug((Object)("Fragmenting " + completeURL));
        }
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        this.processFilter(FragmentFilter.class.getName(), httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, filterChain);
        String content = bufferCacheServletResponse.getString();
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)this.getContent(httpServletRequest, content));
    }
}

