/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Map;

public class DBBuilder {
    private final String _databaseName;
    private final DBType[] _dbTypes;

    public static void main(String[] args) throws Exception {
        ToolDependencies.wireBasic();
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String databaseName = arguments.get("db.database.name");
        String databaseTypesString = arguments.get("db.database.types");
        DBType[] dbTypes = DBType.values();
        if (databaseTypesString != null) {
            String[] databaseTypeValues = StringUtil.split((String)databaseTypesString);
            dbTypes = new DBType[databaseTypeValues.length];
            for (int i = 0; i < dbTypes.length; ++i) {
                dbTypes[i] = DBType.valueOf((String)StringUtil.toUpperCase((String)databaseTypeValues[i]));
            }
        }
        String sqlDir = arguments.get("db.sql.dir");
        try {
            new DBBuilder(databaseName, dbTypes, sqlDir);
        }
        catch (Exception exception) {
            ArgumentsUtil.processMainException(arguments, exception);
        }
    }

    public DBBuilder(String databaseName, DBType[] dbTypes, String sqlDir) throws Exception {
        this._databaseName = databaseName;
        this._dbTypes = dbTypes;
        if (!sqlDir.endsWith("/META-INF/sql") && !sqlDir.endsWith("/WEB-INF/sql")) {
            this._buildSQLFile(sqlDir, "portal");
            this._buildSQLFile(sqlDir, "portal-tables");
        } else {
            this._buildSQLFile(sqlDir, "tables");
        }
        this._buildSQLFile(sqlDir, "indexes");
        this._buildSQLFile(sqlDir, "sequences");
        this._buildSQLFile(sqlDir, "update-6.1.0-6.1.1");
        this._buildSQLFiles(sqlDir, "update-6.1.1-6.2.0*");
        this._buildSQLFiles(sqlDir, "update-6.2.0-7.0.0*");
        this._buildSQLFiles(sqlDir, "update-7.0.0-7.0.1*");
        this._buildCreateFile(sqlDir);
    }

    private void _appendFile(StringBundler sb, String sqlDir, String pathPrefix, DBType dbType) throws Exception {
        String fileName = StringBundler.concat((Object[])new Object[]{sqlDir, pathPrefix, dbType, ".sql"});
        if (FileUtil.exists((String)fileName)) {
            sb.append(FileUtil.read((String)fileName));
        }
    }

    private void _buildCreateFile(String sqlDir) throws Exception {
        for (DBType dbType : this._dbTypes) {
            DB db;
            if (dbType == DBType.HYPERSONIC || (db = DBManagerUtil.getDB((DBType)dbType, null)) == null) continue;
            String recreateSQL = db.getRecreateSQL(this._databaseName);
            if (!sqlDir.endsWith("/WEB-INF/sql")) {
                FileUtil.write((String)StringBundler.concat((Object[])new Object[]{sqlDir, "/create-bare/create-bare-", db.getDBType(), ".sql"}), (String)recreateSQL);
            }
            StringBundler sb = new StringBundler(6);
            String tablesPrefix = "/portal/portal-";
            if (sqlDir.endsWith("/WEB-INF/sql")) {
                tablesPrefix = "/tables/tables-";
            }
            this._appendFile(sb, sqlDir, tablesPrefix, db.getDBType());
            sb.append("\n\n");
            this._appendFile(sb, sqlDir, "/indexes/indexes-", db.getDBType());
            sb.append("\n\n");
            this._appendFile(sb, sqlDir, "/sequences/sequences-", db.getDBType());
            sb.append("\n");
            String content = db.getPopulateSQL(this._databaseName, sb.toString());
            if (content.isEmpty()) continue;
            FileUtil.write((String)StringBundler.concat((Object[])new Object[]{sqlDir, "/create/create-", db.getDBType(), ".sql"}), (String)recreateSQL.concat(content));
        }
    }

    private void _buildSQLFile(String sqlDir, String fileName) throws Exception {
        if (!FileUtil.exists((String)StringBundler.concat((String[])new String[]{sqlDir, "/", fileName, ".sql"}))) {
            return;
        }
        this._generateSQLFile(sqlDir, fileName);
    }

    private void _buildSQLFiles(String sqlDir, String regex) throws Exception {
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(sqlDir, new String[0]), regex);){
            for (Path path : paths) {
                String fileName = String.valueOf(path.getFileName());
                this._generateSQLFile(sqlDir, StringUtil.removeSubstring((String)fileName, (String)".sql"));
            }
        }
    }

    private void _generateSQLFile(String sqlDir, String fileName) throws IOException, SQLException {
        for (DBType dbType : this._dbTypes) {
            DB db = DBManagerUtil.getDB((DBType)dbType, null);
            if (db == null) continue;
            String template = FileUtil.read((String)StringBundler.concat((String[])new String[]{sqlDir, "/", fileName, ".sql"}));
            if (fileName.equals("portal")) {
                StringBundler sb = new StringBundler();
                try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));){
                    String line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (line.startsWith("@include ")) {
                            int pos = line.indexOf(" ");
                            String includeFileName = line.substring(pos + 1);
                            File includeFile = new File(sqlDir + "/" + includeFileName);
                            if (!includeFile.exists()) continue;
                            sb.append(FileUtil.read((File)includeFile));
                            sb.append("\n\n");
                            continue;
                        }
                        sb.append(line);
                        sb.append("\n");
                    }
                }
                template = sb.toString();
            } else if (fileName.equals("indexes") && dbType == DBType.SYBASE) {
                template = this._removeBooleanIndexes(sqlDir, template);
            }
            if (Validator.isNull((String)template)) {
                return;
            }
            template = db.buildSQL(template);
            FileUtil.write((String)StringBundler.concat((Object[])new Object[]{sqlDir, "/", fileName, "/", fileName, "-", db.getDBType(), ".sql"}), (String)template);
        }
    }

    private String _removeBooleanIndexes(String sqlDir, String data) throws IOException {
        String portalData = FileUtil.read((String)(sqlDir + "/portal-tables.sql"));
        if (Validator.isNull((String)portalData)) {
            return "";
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                boolean append = true;
                int x = line.indexOf(" on ");
                if (x != -1) {
                    int y = line.indexOf(" (", x);
                    String table = line.substring(x + 4, y);
                    x = y + 2;
                    y = line.indexOf(")", x);
                    String[] columns = StringUtil.split((String)line.substring(x, y));
                    x = portalData.indexOf("create table " + table + " (");
                    y = portalData.indexOf(");", x);
                    String portalTableData = portalData.substring(x, y);
                    for (String column : columns) {
                        if (!portalTableData.contains(column.trim() + " BOOLEAN")) continue;
                        append = false;
                        break;
                    }
                }
                if (!append) continue;
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

