/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class UpgradeResourcePermission
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (SafeCloseable safeCloseable = this.addTempIndex("ResourcePermission", false, new String[]{"name"});){
            this.upgradeResourcePermissions();
        }
    }

    protected void upgradeResourcePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update ResourcePermission set viewActionId = [$FALSE$] where MOD(actionIds, 2) = 0");
            this.runSQL("update ResourcePermission set viewActionId = [$TRUE$] where MOD(actionIds, 2) = 1");
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select distinct name from ResourcePermission");
                 ResultSet resultSet1 = preparedStatement1.executeQuery();
                 PreparedStatement preparedStatement2 = this.connection.prepareStatement("select distinct primKey from ResourcePermission where name = ?");){
                while (resultSet1.next()) {
                    ArrayList<String> primKeys = new ArrayList<String>();
                    String name = resultSet1.getString("name");
                    preparedStatement2.setString(1, name);
                    try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                        while (resultSet2.next()) {
                            String primKey = resultSet2.getString("primKey");
                            if (GetterUtil.getLong((String)primKey) > 0L || primKey.contains("_LAYOUT_")) continue;
                            primKeys.add(primKey);
                        }
                    }
                    String[][] primKeysArray = null;
                    if (!primKeys.isEmpty()) {
                        primKeysArray = (String[][])ArrayUtil.split((Object)primKeys.toArray(new String[0]), (int)this._getPrimKeysSplitSize(primKeys.size()));
                    }
                    this._updatePrimKeyIdsByName(name, primKeysArray);
                }
            }
        }
    }

    private String _createInClause(String[] primKeys) {
        StringBundler sb = new StringBundler(primKeys.length + 1);
        sb.append("in (?");
        for (int i = 1; i < primKeys.length; ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        return sb.toString();
    }

    private int _getPrimKeysSplitSize(int primKeysCount) {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.ORACLE) {
            return 1000;
        }
        return primKeysCount;
    }

    private void _updatePrimKeyIds(String sql, String name, String[] primKeys) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SQLTransformer.transform(sql));){
            preparedStatement.setString(1, name);
            for (int i = 0; i < primKeys.length; ++i) {
                String primKey = primKeys[i];
                preparedStatement.setString(i + 2, primKey);
            }
            preparedStatement.executeUpdate();
        }
    }

    private void _updatePrimKeyIdsByName(String name, String[][] primKeysArray) throws Exception {
        if (ArrayUtil.isEmpty((Object[])primKeysArray)) {
            this._updatePrimKeyIds("update ResourcePermission set primKeyId = CAST_LONG(primKey) where name = ? and primKey not like '%_LAYOUT_%'", name, new String[0]);
            this._updatePrimKeyIds("update ResourcePermission set primKeyId = 0 where name = ? and primKey like '%_LAYOUT_%'", name, new String[0]);
            return;
        }
        for (String[] primKeys : primKeysArray) {
            String inClause = this._createInClause(primKeys);
            this._updatePrimKeyIds(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKeyId = 0 where name = ", "? and (primKey like '%_LAYOUT_%' or primKey ", inClause, ")"}), name, primKeys);
        }
        this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKeyId = CAST_LONG(primKey", ") where name = '", name, "' and (primKey not like '%_LAYOUT_%' and (primKeyId IS NULL ", "or primKeyId != 0))"}));
    }
}

