/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class JavaScriptBundleUtil {
    private static final String _CACHE_NAME = JavaScriptBundleUtil.class.getName();
    private static final PortalCache<String, String[]> _portalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)_CACHE_NAME);

    public static void clearCache() {
        _portalCache.removeAll();
    }

    public static String[] getFileNames(String bundleId) {
        String[] fileNames = (String[])_portalCache.get((Serializable)((Object)bundleId));
        if (fileNames == null) {
            ArrayList<String> fileNamesList = new ArrayList<String>();
            Set<String> dependencies = JavaScriptBundleUtil._getDependencies(bundleId, new LinkedHashSet<String>());
            for (String dependency : dependencies) {
                String[] dependencyFileNames;
                for (String dependencyFileName : dependencyFileNames = PropsUtil.getArray(dependency)) {
                    fileNamesList.add(dependencyFileName);
                }
            }
            fileNames = fileNamesList.toArray(new String[0]);
            _portalCache.put((Serializable)((Object)bundleId), (Object)fileNames);
        }
        return fileNames;
    }

    private static Set<String> _getDependencies(String bundleId, Set<String> dependencies) {
        String[] bundleDependencies;
        if (!ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)bundleId)) {
            return dependencies;
        }
        for (String bundleDependency : bundleDependencies = PropsUtil.getArray("javascript.bundle.dependencies", new Filter(bundleId))) {
            Object[] bundleDependencyDependencies = PropsUtil.getArray("javascript.bundle.dependencies", new Filter(bundleDependency));
            if (!ArrayUtil.contains((Object[])bundleDependencyDependencies, (Object)bundleId)) {
                JavaScriptBundleUtil._getDependencies(bundleDependency, dependencies);
            }
            dependencies.add(bundleDependency);
        }
        dependencies.add(bundleId);
        return dependencies;
    }
}

