/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Deprecated
public class VerifyGroup
extends VerifyProcess {
    private static final String[] _LEGACY_STAGED_PORTLET_TYPE_SETTINGS_KEYS = new String[]{"staged-portlet_39", "staged-portlet_54", "staged-portlet_56", "staged-portlet_59", "staged-portlet_107", "staged-portlet_108", "staged-portlet_110", "staged-portlet_166", "staged-portlet_169"};
    private static final Log _log = LogFactoryUtil.getLog(VerifyGroup.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyStagedGroups();
    }

    protected void verifyStagedGroups() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List groups = GroupLocalServiceUtil.getLiveGroups();
            for (Group group : groups) {
                if (!group.hasStagingGroup()) continue;
                UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
                this.verifyStagingTypeSettingsProperties(typeSettingsUnicodeProperties);
                GroupLocalServiceUtil.updateGroup((long)group.getGroupId(), (String)typeSettingsUnicodeProperties.toString());
                Group stagingGroup = group.getStagingGroup();
                if (stagingGroup.isStagedRemotely()) continue;
                this.verifyStagingGroupOrganizationMembership(stagingGroup);
                this.verifyStagingGroupRoleMembership(stagingGroup);
                this.verifyStagingGroupUserGroupMembership(stagingGroup);
                this.verifyStagingGroupUserMembership(stagingGroup);
                this.verifyStagingUserGroupRolesAssignments(stagingGroup);
                this.verifyStagingUserGroupGroupRolesAssignments(stagingGroup);
            }
        }
    }

    protected void verifyStagingGroupOrganizationMembership(Group stagingGroup) throws Exception {
        List stagingOrganizations = OrganizationLocalServiceUtil.getGroupOrganizations((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingOrganizations)) {
            return;
        }
        List liveOrganizations = OrganizationLocalServiceUtil.getGroupOrganizations((long)stagingGroup.getLiveGroupId());
        for (Organization stagingGroupOrganization : stagingOrganizations) {
            if (liveOrganizations.contains(stagingGroupOrganization)) continue;
            OrganizationLocalServiceUtil.addGroupOrganization((long)stagingGroup.getLiveGroupId(), (Organization)stagingGroupOrganization);
        }
        OrganizationLocalServiceUtil.clearGroupOrganizations((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingGroupRoleMembership(Group stagingGroup) {
        List stagingRoles = RoleLocalServiceUtil.getGroupRoles((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingRoles)) {
            return;
        }
        List liveRoles = RoleLocalServiceUtil.getGroupRoles((long)stagingGroup.getLiveGroupId());
        for (Role stagingRole : stagingRoles) {
            if (liveRoles.contains(stagingRole)) continue;
            RoleLocalServiceUtil.addGroupRole((long)stagingGroup.getLiveGroupId(), (Role)stagingRole);
        }
        RoleLocalServiceUtil.clearGroupRoles((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingGroupUserGroupMembership(Group stagingGroup) {
        List stagingUserGroups = UserGroupLocalServiceUtil.getGroupUserGroups((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingUserGroups)) {
            return;
        }
        List liveUserGroups = UserGroupLocalServiceUtil.getGroupUserGroups((long)stagingGroup.getLiveGroupId());
        for (UserGroup stagingUserGroup : stagingUserGroups) {
            if (liveUserGroups.contains(stagingUserGroup)) continue;
            UserGroupLocalServiceUtil.addGroupUserGroup((long)stagingGroup.getLiveGroupId(), (UserGroup)stagingUserGroup);
        }
        UserGroupLocalServiceUtil.clearGroupUserGroups((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingGroupUserMembership(Group stagingGroup) {
        List stagingGroupUsers = UserLocalServiceUtil.getGroupUsers((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingGroupUsers)) {
            return;
        }
        List liveGroupUsers = UserLocalServiceUtil.getGroupUsers((long)stagingGroup.getLiveGroupId());
        for (User stagingGroupUser : stagingGroupUsers) {
            if (liveGroupUsers.contains(stagingGroupUser)) continue;
            UserLocalServiceUtil.addGroupUser((long)stagingGroup.getLiveGroupId(), (User)stagingGroupUser);
        }
        UserLocalServiceUtil.clearGroupUsers((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingTypeSettingsProperties(UnicodeProperties typeSettingsUnicodeProperties) {
        Set keys = typeSettingsUnicodeProperties.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!ArrayUtil.contains((Object[])_LEGACY_STAGED_PORTLET_TYPE_SETTINGS_KEYS, (Object)key)) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Removing type settings property " + key));
            }
            iterator.remove();
        }
    }

    protected void verifyStagingUserGroupGroupRolesAssignments(Group stagingGroup) {
        DynamicQuery dynamicQuery = UserGroupGroupRoleLocalServiceUtil.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)stagingGroup.getGroupId()));
        List stagingUserGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (stagingUserGroupGroupRoles.isEmpty()) {
            return;
        }
        dynamicQuery = UserGroupGroupRoleLocalServiceUtil.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)stagingGroup.getLiveGroupId()));
        List liveUserGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (UserGroupGroupRole userGroupGroupRole : stagingUserGroupGroupRoles) {
            userGroupGroupRole.setGroupId(stagingGroup.getLiveGroupId());
            if (liveUserGroupGroupRoles.contains(userGroupGroupRole)) continue;
            UserGroupGroupRoleLocalServiceUtil.updateUserGroupGroupRole((UserGroupGroupRole)userGroupGroupRole);
        }
        UserGroupGroupRoleLocalServiceUtil.deleteUserGroupGroupRolesByGroupId((long)stagingGroup.getGroupId());
    }

    protected void verifyStagingUserGroupRolesAssignments(Group stagingGroup) {
        List stagingUserGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroup((long)stagingGroup.getGroupId());
        if (ListUtil.isEmpty((List)stagingUserGroupRoles)) {
            return;
        }
        List liveUserGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroup((long)stagingGroup.getLiveGroupId());
        for (UserGroupRole stagingUserGroupRole : stagingUserGroupRoles) {
            stagingUserGroupRole.setGroupId(stagingGroup.getLiveGroupId());
            if (liveUserGroupRoles.contains(stagingUserGroupRole)) continue;
            UserGroupRoleLocalServiceUtil.updateUserGroupRole((UserGroupRole)stagingUserGroupRole);
        }
        UserGroupRoleLocalServiceUtil.deleteUserGroupRolesByGroupId((long)stagingGroup.getGroupId());
    }
}

