/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.async.PortletAsyncScopeManager;
import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

public class PortletAsyncScopingRunnable
implements Runnable {
    private static final Log _log = LogFactoryUtil.getLog(PortletAsyncScopingRunnable.class);
    private final AsyncListener _asyncListener;
    private final PortletAsyncScopeManager _portletAsyncScopeManager;
    private final Runnable _runnable;

    public PortletAsyncScopingRunnable(Runnable runnable, AsyncListener asyncListener, PortletAsyncScopeManager portletAsyncScopeManager) {
        this._runnable = runnable;
        this._asyncListener = asyncListener;
        this._portletAsyncScopeManager = portletAsyncScopeManager;
    }

    @Override
    public void run() {
        this._portletAsyncScopeManager.activateScopeContexts();
        try {
            this._runnable.run();
        }
        catch (Throwable throwable) {
            try {
                this._asyncListener.onError(new AsyncEvent(null, throwable));
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        finally {
            this._portletAsyncScopeManager.deactivateScopeContexts(false);
        }
    }
}

