/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.convert.ConvertException;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.MaintenanceUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.StopWatch;

public abstract class BaseConvertProcess
implements ConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseConvertProcess.class);
    private String[] _paramValues;

    @Override
    public void convert() throws ConvertException {
        try {
            Class<?> clazz;
            if (this.getPath() != null) {
                return;
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isInfoEnabled()) {
                clazz = this.getClass();
                _log.info((Object)("Starting conversion for " + clazz.getName()));
            }
            this.doConvert();
            if (_log.isInfoEnabled()) {
                clazz = this.getClass();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Finished conversion for ", clazz.getName(), " in ", stopWatch.getTime(), " ms"}));
            }
        }
        catch (Exception exception) {
            throw new ConvertException(exception);
        }
        finally {
            this.setParameterValues(null);
            if (MaintenanceUtil.isMaintaining()) {
                MaintenanceUtil.cancel();
            }
        }
    }

    @Override
    public String getConfigurationErrorMessage() {
        return null;
    }

    @Override
    public abstract String getDescription();

    @Override
    public String getParameterDescription() {
        return null;
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    public String[] getParameterValues() {
        return this._paramValues;
    }

    @Override
    public boolean includeCustomView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String jspPath = this.getJspPath();
        if (Validator.isNull((String)jspPath)) {
            return false;
        }
        ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)httpServletRequest.getAttribute("RESOURCE_BUNDLE_LOADER");
        ServletContext servletContext = this.getServletContext(httpServletRequest);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(jspPath);
        try {
            httpServletRequest.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)this.getResourceBundleLoader(httpServletRequest));
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            boolean bl = true;
            return bl;
        }
        catch (ServletException servletException) {
            _log.error((Object)("Unable to include JSP " + jspPath), (Throwable)servletException);
            throw new IOException("Unable to include " + jspPath, servletException);
        }
        finally {
            httpServletRequest.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)resourceBundleLoader);
        }
    }

    @Override
    public abstract boolean isEnabled();

    @Override
    public void setParameterValues(String[] values) {
        this._paramValues = values;
    }

    @Override
    public void validate() throws ConvertException {
    }

    protected abstract void doConvert() throws Exception;

    protected String getJspPath() {
        return null;
    }

    protected ResourceBundleLoader getResourceBundleLoader(HttpServletRequest httpServletRequest) {
        ServletContext servletContext = this.getServletContext(httpServletRequest);
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName((String)servletContext.getServletContextName());
        if (resourceBundleLoader == null) {
            resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        }
        return resourceBundleLoader;
    }

    protected ServletContext getServletContext(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getServletContext();
    }
}

