/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.increment;

import com.liferay.portal.internal.increment.BufferedIncrementConfiguration;
import com.liferay.portal.internal.increment.BufferedIncrementProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BufferedIncrementProcessorUtil {
    private static final Map<String, BufferedIncrementProcessor> _bufferedIncrementProcessors = new ConcurrentHashMap<String, BufferedIncrementProcessor>();

    public static BufferedIncrementProcessor getBufferedIncrementProcessor(String configuration) {
        return _bufferedIncrementProcessors.computeIfAbsent(configuration, key -> {
            BufferedIncrementConfiguration bufferedIncrementConfiguration = new BufferedIncrementConfiguration((String)key);
            return new BufferedIncrementProcessor(bufferedIncrementConfiguration, (String)key);
        });
    }

    public void destroy() {
        for (BufferedIncrementProcessor bufferedIncrementProcessor : _bufferedIncrementProcessors.values()) {
            bufferedIncrementProcessor.destroy();
        }
    }
}

