/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.MethodParametersResolverUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.Objects;

public class JSONWebServiceActionConfig
implements Comparable<JSONWebServiceActionConfig>,
JSONWebServiceActionMapping {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceActionConfig.class);
    private final Class<?> _actionClass;
    private final Method _actionMethod;
    private final Object _actionObject;
    private final String _contextName;
    private final String _contextPath;
    private final boolean _deprecated;
    private final String _method;
    private final String _path;
    private final Method _realActionMethod;
    private final String _signature;

    public JSONWebServiceActionConfig(String contextName, String contextPath, Object actionObject, Class<?> actionClass, Method actionMethod, String path, String method) {
        Method realActionMethod;
        block7: {
            this._contextName = GetterUtil.getString((String)contextName);
            this._contextPath = GetterUtil.getString((String)contextPath);
            this._actionObject = actionObject;
            this._actionClass = actionClass;
            Method newActionMethod = actionMethod;
            if (actionObject != null) {
                try {
                    Class<?> actionObjectClass = actionObject.getClass();
                    newActionMethod = actionObjectClass.getMethod(actionMethod.getName(), actionMethod.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalArgumentException(noSuchMethodException);
                }
            }
            this._actionMethod = newActionMethod;
            if (Validator.isNotNull((String)this._contextName)) {
                path = StringBundler.concat((String[])new String[]{"/", this._contextName, ".", path.substring(1)});
            }
            this._path = path;
            this._method = method;
            Deprecated deprecated = actionMethod.getAnnotation(Deprecated.class);
            this._deprecated = deprecated != null;
            realActionMethod = null;
            try {
                realActionMethod = this._actionClass.getDeclaredMethod(actionMethod.getName(), actionMethod.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Throwable)noSuchMethodException);
            }
        }
        this._realActionMethod = realActionMethod;
        Class<?>[] parameterTypes = this._actionMethod.getParameterTypes();
        StringBundler sb = new StringBundler(parameterTypes.length * 2 + 3);
        sb.append(this._path);
        sb.append("-");
        sb.append(parameterTypes.length);
        for (Class<?> parameterType : parameterTypes) {
            sb.append("-");
            sb.append(parameterType.getName());
        }
        this._signature = sb.toString();
    }

    @Override
    public int compareTo(JSONWebServiceActionConfig jsonWebServiceActionConfig) {
        return this._signature.compareTo(jsonWebServiceActionConfig._signature);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JSONWebServiceActionConfig)) {
            return false;
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)object;
        return Objects.equals(this._signature, jsonWebServiceActionConfig._signature);
    }

    public Class<?> getActionClass() {
        return this._actionClass;
    }

    public Method getActionMethod() {
        return this._actionMethod;
    }

    public Object getActionObject() {
        return this._actionObject;
    }

    public String getContextName() {
        return this._contextName;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getMethod() {
        return this._method;
    }

    public MethodParameter[] getMethodParameters() {
        if (this._realActionMethod == null) {
            return new MethodParameter[0];
        }
        return MethodParametersResolverUtil.resolveMethodParameters((Method)this._realActionMethod);
    }

    public String getPath() {
        return this._path;
    }

    public Method getRealActionMethod() {
        return this._realActionMethod;
    }

    public String getSignature() {
        return this._signature;
    }

    public int hashCode() {
        return this._signature.hashCode();
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{actionClass=", this._actionClass, ", actionMethod=", this._actionMethod, ", contextName=", this._contextName, ", contextPath=", this._contextPath, ", deprecated=", this._deprecated, ", method=", this._method, ", path=", this._path, ", realActionMethod=", this._realActionMethod, ", signature=", this._signature, "}"});
    }
}

