/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class JSONWebServiceScannerUtil {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceScannerUtil.class);

    public static Method[] scan(Object service) {
        Class<?> clazz = JSONWebServiceScannerUtil._getTargetClass(service);
        Method[] methods = clazz.getMethods();
        ArrayList<Method> serviceMethods = new ArrayList<Method>(methods.length);
        for (Method method : methods) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != clazz) continue;
            serviceMethods.add(method);
        }
        return serviceMethods.toArray(new Method[0]);
    }

    private static Class<?> _getTargetClass(Object service) {
        while (ProxyUtil.isProxyClass(service.getClass())) {
            InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)service);
            if (invocationHandler instanceof ClassLoaderBeanHandler) {
                ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
                Object bean = classLoaderBeanHandler.getBean();
                if (bean instanceof ServiceWrapper) {
                    ServiceWrapper serviceWrapper = (ServiceWrapper)bean;
                    service = serviceWrapper.getWrappedService();
                    continue;
                }
                service = bean;
                continue;
            }
            Class<?> invocationHandlerClass = invocationHandler.getClass();
            try {
                Method method = invocationHandlerClass.getMethod("getTarget", new Class[0]);
                service = method.invoke((Object)invocationHandler, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)reflectiveOperationException);
            }
        }
        return service.getClass();
    }
}

